/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.utils.OverlayIcon;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UiUtils.class);
    private static final ImageIcon ICON_STATIC = UiUtils.openIcon("static_co");
    private static final ImageIcon ICON_FINAL = UiUtils.openIcon("final_co");
    private static final ImageIcon ICON_ABSTRACT = UiUtils.openIcon("abstract_co");
    private static final ImageIcon ICON_NATIVE = UiUtils.openIcon("native_co");
    public static final long MIN_FREE_MEMORY = UiUtils.calculateMinFreeMemory();
    public static final int CTRL_BNT_KEY = UiUtils.getCtrlButton();

    private UiUtils() {
    }

    public static ImageIcon openIcon(String name) {
        String iconPath = "/icons-16/" + name + ".png";
        URL resource = UiUtils.class.getResource(iconPath);
        if (resource == null) {
            throw new JadxRuntimeException("Icon not found: " + iconPath);
        }
        return new ImageIcon(resource);
    }

    public static Image openImage(String path) {
        URL resource = UiUtils.class.getResource(path);
        if (resource == null) {
            throw new JadxRuntimeException("Image not found: " + path);
        }
        return Toolkit.getDefaultToolkit().createImage(resource);
    }

    public static void addKeyBinding(JComponent comp, KeyStroke key, String id, Action action) {
        comp.getInputMap().put(key, id);
        comp.getActionMap().put(id, action);
    }

    public static String typeFormat(String name, ArgType type) {
        return "<html><body><nobr>" + UiUtils.escapeHtml(name) + "<span style='color:#888888;'> " + UiUtils.escapeHtml(UiUtils.typeStr(type)) + "</span></nobr></body></html>";
    }

    public static String escapeHtml(String str) {
        return str.replace("<", "&lt;");
    }

    public static String typeStr(ArgType type) {
        if (type == null) {
            return "null";
        }
        if (type.isObject()) {
            String cls = type.toString();
            int dot = cls.lastIndexOf(46);
            if (dot != -1) {
                return cls.substring(dot + 1);
            }
            return cls;
        }
        if (type.isArray()) {
            return UiUtils.typeStr(type.getArrayElement()) + "[]";
        }
        return type.toString();
    }

    public static OverlayIcon makeIcon(AccessInfo af, Icon pub, Icon pri, Icon pro, Icon def) {
        Icon icon = af.isPublic() ? pub : (af.isPrivate() ? pri : (af.isProtected() ? pro : def));
        OverlayIcon overIcon = new OverlayIcon(icon);
        if (af.isFinal()) {
            overIcon.add(ICON_FINAL);
        }
        if (af.isStatic()) {
            overIcon.add(ICON_STATIC);
        }
        if (af.isAbstract()) {
            overIcon.add(ICON_ABSTRACT);
        }
        if (af.isNative()) {
            overIcon.add(ICON_NATIVE);
        }
        return overIcon;
    }

    public static long calculateMinFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long minFree = (long)((double)runtime.maxMemory() * 0.2);
        return Math.min(minFree, 0x20000000L);
    }

    public static boolean isFreeMemoryAvailable() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalFree = runtime.freeMemory() + (maxMemory - runtime.totalMemory());
        return totalFree > MIN_FREE_MEMORY;
    }

    public static String memoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return "heap: " + UiUtils.format(allocatedMemory - freeMemory) + ", allocated: " + UiUtils.format(allocatedMemory) + ", free: " + UiUtils.format(freeMemory) + ", total free: " + UiUtils.format(freeMemory + maxMemory - allocatedMemory) + ", max: " + UiUtils.format(maxMemory);
    }

    private static String format(long mem) {
        return (long)((double)mem / 1048576.0) + "MB";
    }

    public static char caseChar(char ch, boolean toLower) {
        return toLower ? Character.toLowerCase(ch) : ch;
    }

    public static void setClipboardString(String text) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection transferable = new StringSelection(text);
            clipboard.setContents(transferable, null);
            LOG.debug("String '{}' copied to clipboard", (Object)text);
        }
        catch (Exception e) {
            LOG.error("Failed copy string '{}' to clipboard", (Object)text, (Object)e);
        }
    }

    public static void setWindowIcons(Window window) {
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(UiUtils.openImage("/logos/jadx-logo-16px.png"));
        icons.add(UiUtils.openImage("/logos/jadx-logo-32px.png"));
        icons.add(UiUtils.openImage("/logos/jadx-logo-48px.png"));
        icons.add(UiUtils.openImage("/logos/jadx-logo.png"));
        window.setIconImages(icons);
    }

    private static int getCtrlButton() {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        return 128;
    }

    public static int ctrlButton() {
        return CTRL_BNT_KEY;
    }
}

