/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.gui.treemodel.ApkSignature;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.HtmlPanel;
import jadx.gui.ui.ImagePanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.TabComponent;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.CodeContentPanel;
import jadx.gui.utils.JumpManager;
import jadx.gui.utils.JumpPosition;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabbedPane
extends JTabbedPane {
    private static final Logger LOG = LoggerFactory.getLogger(TabbedPane.class);
    private static final long serialVersionUID = -8833600618794570904L;
    private final transient MainWindow mainWindow;
    private final transient Map<JNode, ContentPanel> openTabs = new LinkedHashMap<JNode, ContentPanel>();
    private final transient JumpManager jumps = new JumpManager();

    TabbedPane(MainWindow window) {
        this.mainWindow = window;
        this.setTabLayoutPolicy(1);
        this.addMouseWheelListener(e -> {
            int direction = e.getWheelRotation();
            int index = this.getSelectedIndex();
            int maxIndex = this.getTabCount() - 1;
            index = index == 0 && direction < 0 || index == maxIndex && direction > 0 ? maxIndex - index : (index += direction);
            this.setSelectedIndex(index);
        });
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    private void showCode(JumpPosition pos) {
        AbstractCodeContentPanel contentPanel = (AbstractCodeContentPanel)this.getContentPanel(pos.getNode());
        if (contentPanel == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.setSelectedComponent(contentPanel);
            AbstractCodeArea codeArea = contentPanel.getCodeArea();
            int line = pos.getLine();
            if (line < 0) {
                try {
                    line = 1 + codeArea.getLineOfOffset(-line);
                }
                catch (BadLocationException e) {
                    LOG.error("Can't get line for: {}", (Object)pos, (Object)e);
                    line = pos.getNode().getLine();
                }
            }
            codeArea.scrollToLine(line);
            codeArea.requestFocus();
        });
    }

    public void showResource(JResource res) {
        ContentPanel contentPanel = this.getContentPanel(res);
        if (contentPanel == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.setSelectedComponent(contentPanel));
    }

    public void showSimpleNode(JNode node) {
        ContentPanel contentPanel = this.getContentPanel(node);
        if (contentPanel == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.setSelectedComponent(contentPanel));
    }

    public void codeJump(JumpPosition pos) {
        JumpPosition curPos = this.getCurrentPosition();
        if (curPos != null) {
            this.jumps.addPosition(curPos);
            this.jumps.addPosition(pos);
        }
        this.showCode(pos);
    }

    @Nullable
    private JumpPosition getCurrentPosition() {
        ContentPanel selectedCodePanel = this.getSelectedCodePanel();
        if (selectedCodePanel instanceof AbstractCodeContentPanel) {
            return ((AbstractCodeContentPanel)selectedCodePanel).getCodeArea().getCurrentPosition();
        }
        return null;
    }

    public void navBack() {
        JumpPosition pos = this.jumps.getPrev();
        if (pos != null) {
            this.showCode(pos);
        }
    }

    public void navForward() {
        JumpPosition pos = this.jumps.getNext();
        if (pos != null) {
            this.showCode(pos);
        }
    }

    private void addContentPanel(ContentPanel contentPanel) {
        this.openTabs.put(contentPanel.getNode(), contentPanel);
        this.add(contentPanel);
    }

    public void closeCodePanel(ContentPanel contentPanel) {
        this.openTabs.remove(contentPanel.getNode());
        this.remove(contentPanel);
    }

    @Nullable
    private ContentPanel getContentPanel(JNode node) {
        ContentPanel panel = this.openTabs.get(node);
        if (panel == null) {
            panel = this.makeContentPanel(node);
            if (panel == null) {
                return null;
            }
            this.addContentPanel(panel);
            this.setTabComponentAt(this.indexOfComponent(panel), this.makeTabComponent(panel));
        }
        return panel;
    }

    @Nullable
    private ContentPanel makeContentPanel(JNode node) {
        if (node instanceof JResource) {
            JResource res = (JResource)node;
            ResourceFile resFile = res.getResFile();
            if (resFile != null) {
                if (resFile.getType() == ResourceType.IMG) {
                    return new ImagePanel(this, res);
                }
                return new CodeContentPanel(this, node);
            }
            return null;
        }
        if (node instanceof ApkSignature) {
            return new HtmlPanel(this, node);
        }
        return new ClassCodeContentPanel(this, node);
    }

    @Nullable
    ContentPanel getSelectedCodePanel() {
        return (ContentPanel)this.getSelectedComponent();
    }

    private Component makeTabComponent(ContentPanel contentPanel) {
        return new TabComponent(this, contentPanel);
    }

    public void closeAllTabs() {
        ArrayList<ContentPanel> contentPanels = new ArrayList<ContentPanel>(this.openTabs.values());
        for (ContentPanel panel : contentPanels) {
            this.closeCodePanel(panel);
        }
    }

    public Map<JNode, ContentPanel> getOpenTabs() {
        return this.openTabs;
    }

    public void loadSettings() {
        for (ContentPanel panel : this.openTabs.values()) {
            panel.loadSettings();
        }
        int tabCount = this.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component tabComponent = this.getTabComponentAt(i);
            if (!(tabComponent instanceof TabComponent)) continue;
            ((TabComponent)tabComponent).loadSettings();
        }
    }
}

