/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.internal.SearchContext;

public final class FetchDocValuesPhase
implements FetchSubPhase {
    private static final String USE_DEFAULT_FORMAT = "use_field_mapping";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(FetchDocValuesPhase.class));

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (context.collapse() != null) {
            String name = context.collapse().getFieldName();
            if (context.docValuesContext() == null) {
                context.docValuesContext(new FetchDocValuesContext(Collections.singletonList(new FetchDocValuesContext.FieldAndFormat(name, null))));
            } else if (!context.docValuesContext().fields().stream().map(ff -> ff.field).anyMatch(name::equals)) {
                context.docValuesContext().fields().add(new FetchDocValuesContext.FieldAndFormat(name, null));
            }
        }
        if (context.docValuesContext() == null) {
            return;
        }
        if (context.docValuesContext().fields().stream().map(f -> f.format).filter(USE_DEFAULT_FORMAT::equals).findAny().isPresent()) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("explicit_default_format", "[use_field_mapping] is a special format that was only used to ease the transition to 7.x. It has become the default and shouldn't be set explicitly anymore.", new Object[0]);
        }
        for (FetchDocValuesContext.FieldAndFormat fieldAndFormat : context.docValuesContext().fields()) {
            String field = fieldAndFormat.field;
            MappedFieldType fieldType = context.mapperService().fieldType(field);
            if (fieldType == null) continue;
            Object indexFieldData = context.getForField(fieldType);
            boolean isNanosecond = indexFieldData instanceof IndexNumericFieldData ? ((IndexNumericFieldData)indexFieldData).getNumericType() == IndexNumericFieldData.NumericType.DATE_NANOSECONDS : false;
            String formatDesc = fieldAndFormat.format;
            if (Objects.equals(formatDesc, USE_DEFAULT_FORMAT)) {
                formatDesc = null;
            }
            DocValueFormat format = isNanosecond ? DocValueFormat.withNanosecondResolution(fieldType.docValueFormat(formatDesc, null)) : fieldType.docValueFormat(formatDesc, null);
            LeafReaderContext subReaderContext = null;
            LeafFieldData data = null;
            SortedBinaryDocValues binaryValues = null;
            SortedNumericDocValues longValues = null;
            SortedNumericDoubleValues doubleValues = null;
            for (SearchHit hit : hits) {
                int i;
                int count;
                DocumentField hitField;
                if (subReaderContext == null || hit.docId() >= subReaderContext.docBase + subReaderContext.reader().maxDoc()) {
                    int readerIndex = ReaderUtil.subIndex((int)hit.docId(), (List)context.searcher().getIndexReader().leaves());
                    subReaderContext = (LeafReaderContext)context.searcher().getIndexReader().leaves().get(readerIndex);
                    data = (LeafFieldData)indexFieldData.load(subReaderContext);
                    if (indexFieldData instanceof IndexNumericFieldData) {
                        IndexNumericFieldData.NumericType numericType = ((IndexNumericFieldData)indexFieldData).getNumericType();
                        if (numericType.isFloatingPoint()) {
                            doubleValues = ((LeafNumericFieldData)data).getDoubleValues();
                        } else {
                            longValues = isNanosecond ? ((SortedNumericIndexFieldData.NanoSecondFieldData)data).getLongValuesAsNanos() : ((LeafNumericFieldData)data).getLongValues();
                        }
                    } else {
                        data = (LeafFieldData)indexFieldData.load(subReaderContext);
                        binaryValues = data.getBytesValues();
                    }
                }
                if ((hitField = hit.field(field)) == null) {
                    hitField = new DocumentField(field, new ArrayList<Object>(2));
                    hit.setDocumentField(field, hitField);
                }
                List<Object> values = hitField.getValues();
                int subDocId = hit.docId() - subReaderContext.docBase;
                if (binaryValues != null) {
                    if (!binaryValues.advanceExact(subDocId)) continue;
                    count = binaryValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(binaryValues.nextValue()));
                    }
                    continue;
                }
                if (longValues != null) {
                    if (!longValues.advanceExact(subDocId)) continue;
                    count = longValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(longValues.nextValue()));
                    }
                    continue;
                }
                if (doubleValues != null) {
                    if (!doubleValues.advanceExact(subDocId)) continue;
                    count = doubleValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(doubleValues.nextValue()));
                    }
                    continue;
                }
                throw new AssertionError((Object)"Unreachable code");
            }
        }
    }
}

