/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class OracleRDBDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public OracleRDBDatabaseMeta(String name, String access, String host, String db, String port, String user, String pass) {
        super(name, access, host, db, port, user, pass);
    }

    public OracleRDBDatabaseMeta() {
    }

    public String getDatabaseTypeDesc() {
        return "ORACLERDB";
    }

    public String getDatabaseTypeDescLong() {
        return "Oracle RDB";
    }

    public int getDatabaseType() {
        return 22;
    }

    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT /*+FIRST_ROWS*/ * FROM " + tableName + " WHERE ROWNUM < 1";
    }

    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "oracle.rdb.jdbc.rdbThin.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:rdbThin://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean supportsOptionsInURL() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsRepository() {
        return false;
    }

    public String getSQLSequenceExists(String sequenceName) {
        return "SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName.toUpperCase() + "'";
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".currval FROM DUAL";
    }

    public String getSQLNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".nextval FROM dual";
    }

    public boolean useSchemaNameForTableList() {
        return true;
    }

    public boolean supportsSynonyms() {
        return true;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD ( " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP ( " + v.getName() + " ) " + Const.CR;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY (" + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " )";
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        StringBuffer retval = new StringBuffer(128);
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval.append("DATE");
                break;
            }
            case 4: {
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                retval.append("NUMBER");
                if (length <= 0) break;
                retval.append('(').append(length);
                if (precision > 0) {
                    retval.append(", ").append(precision);
                }
                retval.append(')');
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval.append("CLOB");
                    break;
                }
                if (length > 0 && length <= 2000) {
                    retval.append("VARCHAR2(").append(length).append(')');
                    break;
                }
                if (length <= 0) {
                    retval.append("VARCHAR2(2000)");
                    break;
                }
                retval.append("CLOB");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (add_cr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String[] getReservedWords() {
        return new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    }

    public String getSQLLockTables(String[] tableNames) {
        StringBuffer sql = new StringBuffer(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("LOCK TABLE ").append(tableNames[i]).append(" IN EXCLUSIVE MODE;").append(Const.CR);
        }
        return sql.toString();
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    public String[] getUsedLibraries() {
        return new String[]{"rdbthin.jar"};
    }
}

