/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationHelper;
import org.zaproxy.zap.authentication.AuthenticationIndicatorsPanel;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.GenericAuthenticationCredentials;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.EncodingUtils;
import org.zaproxy.zap.view.DynamicFieldsPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ScriptBasedAuthenticationMethodType
extends AuthenticationMethodType {
    public static final String CONTEXT_CONFIG_AUTH_SCRIPT = "context.authentication.script";
    public static final String CONTEXT_CONFIG_AUTH_SCRIPT_NAME = "context.authentication.script.name";
    public static final String CONTEXT_CONFIG_AUTH_SCRIPT_PARAMS = "context.authentication.script.params";
    public static final int METHOD_IDENTIFIER = 4;
    private static final Logger log = Logger.getLogger(ScriptBasedAuthenticationMethodType.class);
    public static final String SCRIPT_TYPE_AUTH = "authentication";
    private static final String API_METHOD_NAME = "scriptBasedAuthentication";
    private static final ImageIcon SCRIPT_ICON_AUTH = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-auth.png"));
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.script.name");
    private ExtensionScript extensionScript;
    private static final String PARAM_SCRIPT_NAME = "scriptName";
    private static final String PARAM_SCRIPT_CONFIG_PARAMS = "scriptConfigParams";

    @Override
    public void hook(ExtensionHook extensionHook) {
        if (this.getScriptsExtension() != null) {
            log.debug((Object)"Registering Script...");
            this.getScriptsExtension().registerScriptType(new ScriptType(SCRIPT_TYPE_AUTH, "authentication.method.script.type", SCRIPT_ICON_AUTH, false, new String[]{"append"}));
        }
    }

    @Override
    public ScriptBasedAuthenticationMethod createAuthenticationMethod(int contextId) {
        return new ScriptBasedAuthenticationMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public int getUniqueIdentifier() {
        return 4;
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return new ScriptBasedAuthenticationMethodOptionsPanel();
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials credentials, Context uiSharedContext) {
        return new GenericAuthenticationCredentials.GenericAuthenticationCredentialsOptionsPanel((GenericAuthenticationCredentials)credentials);
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod method) {
        return method instanceof ScriptBasedAuthenticationMethod;
    }

    @Override
    public ScriptBasedAuthenticationMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        ScriptBasedAuthenticationMethod method = this.createAuthenticationMethod(contextId);
        this.loadMethod(method, session.getContextDataStrings(contextId, 201), session.getContextDataStrings(contextId, 202));
        return method;
    }

    public void loadMethod(ScriptBasedAuthenticationMethod method, List<String> scripts, List<String> paramValuesS) {
        String scriptName = "";
        if (scripts != null && scripts.size() > 0) {
            scriptName = scripts.get(0);
            ScriptWrapper script = this.getScriptsExtension().getScript(scriptName);
            if (script == null) {
                log.error((Object)("Unable to find script while loading Script Based Authentication Method for name: " + scriptName));
                if (View.isInitialised()) {
                    View.getSingleton().showMessageDialog(Constant.messages.getString("authentication.method.script.load.errorScriptNotFound", scriptName));
                }
                return;
            }
            log.info((Object)("Loaded script:" + script.getName()));
            method.script = script;
            AuthenticationScript s = this.getScriptInterfaceV2(script);
            if (s == null) {
                s = this.getScriptInterface(script);
            }
            if (s == null) {
                log.error((Object)("Unable to load Script Based Authentication method. The script " + scriptName + " does not properly implement the Authentication Script interface."));
                return;
            }
            try {
                if (s instanceof AuthenticationScriptV2) {
                    AuthenticationScript sV2 = s;
                    method.setLoggedInIndicatorPattern(sV2.getLoggedInIndicator());
                    method.setLoggedOutIndicatorPattern(sV2.getLoggedOutIndicator());
                }
                ScriptBasedAuthenticationMethod.access$902(method, s.getCredentialsParamsNames());
            }
            catch (Exception e) {
                this.getScriptsExtension().handleScriptException(script, e);
            }
        }
        Map<String, String> paramValues = null;
        if (paramValuesS != null && paramValuesS.size() > 0) {
            paramValues = EncodingUtils.stringToMap(paramValuesS.get(0));
            method.paramValues = paramValues;
        } else {
            method.paramValues = new HashMap();
            log.error((Object)("Unable to load script parameter values loading Script Based Authentication Method for name: " + scriptName));
        }
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, AuthenticationMethod authMethod) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException, DatabaseException {
        if (!(authMethod instanceof ScriptBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Script based authentication type only supports: " + ScriptBasedAuthenticationMethod.class);
        }
        ScriptBasedAuthenticationMethod method = (ScriptBasedAuthenticationMethod)authMethod;
        session.setContextData(contextId, 201, method.script.getName());
        session.setContextData(contextId, 202, EncodingUtils.mapToString(method.paramValues));
    }

    @Override
    public AuthenticationCredentials createAuthenticationCredentials() {
        return new GenericAuthenticationCredentials(new String[0]);
    }

    public Class<GenericAuthenticationCredentials> getAuthenticationCredentialsType() {
        return GenericAuthenticationCredentials.class;
    }

    private ExtensionScript getScriptsExtension() {
        if (this.extensionScript == null) {
            this.extensionScript = Control.getSingleton().getExtensionLoader().getExtension(ExtensionScript.class);
        }
        return this.extensionScript;
    }

    private AuthenticationScript getScriptInterface(ScriptWrapper script) {
        try {
            return this.getScriptsExtension().getInterface(script, AuthenticationScript.class);
        }
        catch (Exception e) {
            this.getScriptsExtension().handleFailedScriptInterface(script, Constant.messages.getString("authentication.method.script.dialog.error.text.interface", script.getName()));
            return null;
        }
    }

    private AuthenticationScriptV2 getScriptInterfaceV2(ScriptWrapper script) {
        try {
            AuthenticationScriptV2 authScript = this.getScriptsExtension().getInterface(script, AuthenticationScriptV2.class);
            authScript.getLoggedInIndicator();
            authScript.getLoggedOutIndicator();
            return authScript;
        }
        catch (Exception ignore) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Script '" + script.getName() + "' is not a AuthenticationScriptV2 interface!"), (Throwable)ignore);
            }
            return null;
        }
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, new String[]{PARAM_SCRIPT_NAME}, new String[]{PARAM_SCRIPT_CONFIG_PARAMS}){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                String scriptName = ApiUtils.getNonEmptyStringParam(params, ScriptBasedAuthenticationMethodType.PARAM_SCRIPT_NAME);
                ScriptBasedAuthenticationMethod method = ScriptBasedAuthenticationMethodType.this.createAuthenticationMethod(context.getId());
                ScriptWrapper script = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getScript(scriptName);
                if (script == null) {
                    log.error((Object)("Unable to find script while loading Script Based Authentication Method for name: " + scriptName));
                    throw new ApiException(ApiException.Type.SCRIPT_NOT_FOUND, scriptName);
                }
                log.info((Object)("Loaded script for API:" + script.getName()));
                method.script = script;
                AuthenticationScript s = ScriptBasedAuthenticationMethodType.this.getScriptInterfaceV2(script);
                if (s == null) {
                    s = ScriptBasedAuthenticationMethodType.this.getScriptInterface(script);
                }
                if (s == null) {
                    log.error((Object)("Unable to load Script Based Authentication method. The script " + script.getName() + " does not properly implement the Authentication Script interface."));
                    throw new ApiException(ApiException.Type.BAD_SCRIPT_FORMAT, "Does not follow Authentication script interface");
                }
                try {
                    if (s instanceof AuthenticationScriptV2) {
                        AuthenticationScript sV2 = s;
                        method.setLoggedInIndicatorPattern(sV2.getLoggedInIndicator());
                        method.setLoggedOutIndicatorPattern(sV2.getLoggedOutIndicator());
                    }
                    ScriptBasedAuthenticationMethod.access$902(method, s.getCredentialsParamsNames());
                    Object[] requiredParams = s.getRequiredParamsNames();
                    Object[] optionalParams = s.getOptionalParamsNames();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loaded authentication script - required parameters: " + Arrays.toString(requiredParams) + " - optional parameters: " + Arrays.toString(optionalParams)));
                    }
                    HashMap<Object, String> paramValues = new HashMap<Object, String>();
                    for (Object rp : requiredParams) {
                        String val = ApiUtils.getNonEmptyStringParam(params, (String)rp);
                        paramValues.put(rp, val);
                    }
                    for (Object op : optionalParams) {
                        paramValues.put(op, ApiUtils.getOptionalStringParam(params, (String)op));
                    }
                    method.paramValues = paramValues;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loaded authentication script parameters:" + paramValues));
                    }
                }
                catch (ApiException e) {
                    throw e;
                }
                catch (Exception e) {
                    ScriptBasedAuthenticationMethodType.this.getScriptsExtension().handleScriptException(script, e);
                    log.error((Object)("Unable to load Script Based Authentication method. The script " + script.getName() + " contains errors."));
                    throw new ApiException(ApiException.Type.BAD_SCRIPT_FORMAT, e.getMessage());
                }
                context.setAuthenticationMethod(method);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return GenericAuthenticationCredentials.getSetCredentialsForUserApiAction(this);
    }

    @Override
    public void exportData(Configuration config, AuthenticationMethod authMethod) {
        if (!(authMethod instanceof ScriptBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Script based authentication type only supports: " + ScriptBasedAuthenticationMethod.class.getName());
        }
        ScriptBasedAuthenticationMethod method = (ScriptBasedAuthenticationMethod)authMethod;
        config.setProperty(CONTEXT_CONFIG_AUTH_SCRIPT_NAME, (Object)method.script.getName());
        config.setProperty(CONTEXT_CONFIG_AUTH_SCRIPT_PARAMS, (Object)EncodingUtils.mapToString(method.paramValues));
    }

    @Override
    public void importData(Configuration config, AuthenticationMethod authMethod) throws ConfigurationException {
        if (!(authMethod instanceof ScriptBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Script based authentication type only supports: " + ScriptBasedAuthenticationMethod.class.getName());
        }
        ScriptBasedAuthenticationMethod method = (ScriptBasedAuthenticationMethod)authMethod;
        this.loadMethod(method, this.objListToStrList(config.getList(CONTEXT_CONFIG_AUTH_SCRIPT_NAME)), this.objListToStrList(config.getList(CONTEXT_CONFIG_AUTH_SCRIPT_PARAMS)));
    }

    private List<String> objListToStrList(List<Object> oList) {
        ArrayList<String> sList = new ArrayList<String>(oList.size());
        for (Object o : oList) {
            sList.add(o.toString());
        }
        return sList;
    }

    public static interface AuthenticationScriptV2
    extends AuthenticationScript {
        public String getLoggedInIndicator();

        public String getLoggedOutIndicator();
    }

    public static interface AuthenticationScript {
        public String[] getRequiredParamsNames();

        public String[] getOptionalParamsNames();

        public String[] getCredentialsParamsNames();

        public HttpMessage authenticate(AuthenticationHelper var1, Map<String, String> var2, GenericAuthenticationCredentials var3) throws ScriptException;
    }

    private static class ScriptWrapperRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);
        private ScriptBasedAuthenticationMethodOptionsPanel panel;

        public ScriptWrapperRenderer(ScriptBasedAuthenticationMethodOptionsPanel panel) {
            this.panel = panel;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setBorder(BORDER);
                ScriptWrapper item = (ScriptWrapper)value;
                if (this.panel.loadedScript == item) {
                    this.setText("<html><b>" + StringEscapeUtils.unescapeHtml((String)item.getName()) + " (loaded)</b></html>");
                } else {
                    this.setText(item.getName());
                }
            }
            return this;
        }
    }

    public class ScriptBasedAuthenticationMethodOptionsPanel
    extends AbstractAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = 7812841049435409987L;
        private final String SCRIPT_NAME_LABEL = Constant.messages.getString("authentication.method.script.field.label.scriptName");
        private final String LABEL_NOT_LOADED = Constant.messages.getString("authentication.method.script.field.label.notLoaded");
        private JComboBox<ScriptWrapper> scriptsComboBox;
        private JButton loadScriptButton;
        private ScriptBasedAuthenticationMethod method;
        private AuthenticationIndicatorsPanel indicatorsPanel;
        private ScriptWrapper loadedScript;
        private JPanel dynamicContentPanel;
        private DynamicFieldsPanel dynamicFieldsPanel;
        private String[] loadedCredentialParams;

        public ScriptBasedAuthenticationMethodOptionsPanel() {
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(this.SCRIPT_NAME_LABEL), LayoutHelper.getGBC(0, 0, 1, 0.0, 0.0));
            this.scriptsComboBox = new JComboBox();
            this.scriptsComboBox.setRenderer(new ScriptWrapperRenderer(this));
            this.add(this.scriptsComboBox, LayoutHelper.getGBC(1, 0, 1, 1.0, 0.0));
            this.loadScriptButton = new JButton("Load");
            this.add((Component)this.loadScriptButton, LayoutHelper.getGBC(2, 0, 1, 0.0, 0.0));
            this.loadScriptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptBasedAuthenticationMethodOptionsPanel.this.loadScript((ScriptWrapper)ScriptBasedAuthenticationMethodOptionsPanel.this.scriptsComboBox.getSelectedItem(), true);
                }
            });
            this.loadScriptButton.setEnabled(false);
            this.scriptsComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptBasedAuthenticationMethodOptionsPanel.this.loadScriptButton.setEnabled(ScriptBasedAuthenticationMethodOptionsPanel.this.scriptsComboBox.getSelectedIndex() >= 0);
                }
            });
            this.dynamicContentPanel = new JPanel(new BorderLayout());
            this.add((Component)this.dynamicContentPanel, LayoutHelper.getGBC(0, 1, 3, 1.0, 0.0));
            this.dynamicContentPanel.add(new JLabel(this.LABEL_NOT_LOADED));
        }

        @Override
        public void validateFields() throws IllegalStateException {
            if (this.loadedScript == null) {
                this.scriptsComboBox.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.script.dialog.error.text.notLoadedNorConfigured"));
            }
            this.dynamicFieldsPanel.validateFields();
        }

        @Override
        public void saveMethod() {
            this.method.script = (ScriptWrapper)this.scriptsComboBox.getSelectedItem();
            if (this.dynamicFieldsPanel != null) {
                this.method.paramValues = this.dynamicFieldsPanel.getFieldValues();
            } else {
                this.method.paramValues = Collections.emptyMap();
            }
            if (this.loadedScript != null) {
                ScriptBasedAuthenticationMethod.access$902(this.method, this.loadedCredentialParams);
            }
        }

        @Override
        public void bindMethod(AuthenticationMethod method) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException {
            this.method = (ScriptBasedAuthenticationMethod)method;
            List<ScriptWrapper> scripts = ScriptBasedAuthenticationMethodType.this.getScriptsExtension().getScripts(ScriptBasedAuthenticationMethodType.SCRIPT_TYPE_AUTH);
            DefaultComboBoxModel<ScriptWrapper> model = new DefaultComboBoxModel<ScriptWrapper>(scripts.toArray(new ScriptWrapper[scripts.size()]));
            this.scriptsComboBox.setModel(model);
            this.scriptsComboBox.setSelectedItem(this.method.script);
            this.loadScriptButton.setEnabled(this.method.script != null);
            if (this.method.script != null) {
                this.loadScript(this.method.script, false);
                if (this.dynamicFieldsPanel != null) {
                    this.dynamicFieldsPanel.bindFieldValues(this.method.paramValues);
                }
            }
        }

        @Override
        public void bindMethod(AuthenticationMethod method, AuthenticationIndicatorsPanel indicatorsPanel) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException {
            this.indicatorsPanel = indicatorsPanel;
            this.bindMethod(method);
        }

        @Override
        public AuthenticationMethod getMethod() {
            return this.method;
        }

        private void loadScript(ScriptWrapper scriptW, boolean adaptOldValues) {
            AuthenticationScript script = ScriptBasedAuthenticationMethodType.this.getScriptInterfaceV2(scriptW);
            if (script == null) {
                script = ScriptBasedAuthenticationMethodType.this.getScriptInterface(scriptW);
            }
            if (script == null) {
                log.warn((Object)("The script " + scriptW.getName() + " does not properly implement the Authentication Script interface."));
                this.warnAndResetPanel(Constant.messages.getString("authentication.method.script.dialog.error.text.interface", scriptW.getName()));
                return;
            }
            try {
                if (script instanceof AuthenticationScriptV2) {
                    AuthenticationScript scriptV2 = script;
                    String toolTip = Constant.messages.getString("authentication.method.script.dialog.loggedInOutIndicatorsInScript.toolTip");
                    String loggedInIndicator = scriptV2.getLoggedInIndicator();
                    this.method.setLoggedInIndicatorPattern(loggedInIndicator);
                    this.indicatorsPanel.setLoggedInIndicatorPattern(loggedInIndicator);
                    this.indicatorsPanel.setLoggedInIndicatorEnabled(false);
                    this.indicatorsPanel.setLoggedInIndicatorToolTip(toolTip);
                    String loggedOutIndicator = scriptV2.getLoggedOutIndicator();
                    this.method.setLoggedOutIndicatorPattern(loggedOutIndicator);
                    this.indicatorsPanel.setLoggedOutIndicatorPattern(loggedOutIndicator);
                    this.indicatorsPanel.setLoggedOutIndicatorEnabled(false);
                    this.indicatorsPanel.setLoggedOutIndicatorToolTip(toolTip);
                } else {
                    this.indicatorsPanel.setLoggedInIndicatorEnabled(true);
                    this.indicatorsPanel.setLoggedInIndicatorToolTip(null);
                    this.indicatorsPanel.setLoggedOutIndicatorEnabled(true);
                    this.indicatorsPanel.setLoggedOutIndicatorToolTip(null);
                }
                Object[] requiredParams = script.getRequiredParamsNames();
                Object[] optionalParams = script.getOptionalParamsNames();
                this.loadedCredentialParams = script.getCredentialsParamsNames();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded authentication script - required parameters: " + Arrays.toString(requiredParams) + " - optional parameters: " + Arrays.toString(optionalParams)));
                }
                Map<String, String> oldValues = null;
                if (adaptOldValues && this.dynamicFieldsPanel != null) {
                    oldValues = this.dynamicFieldsPanel.getFieldValues();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trying to adapt old values: " + oldValues));
                    }
                }
                this.dynamicFieldsPanel = new DynamicFieldsPanel((String[])requiredParams, (String[])optionalParams);
                this.loadedScript = scriptW;
                if (adaptOldValues && oldValues != null) {
                    this.dynamicFieldsPanel.bindFieldValues(oldValues);
                }
                this.dynamicContentPanel.removeAll();
                this.dynamicContentPanel.add((Component)this.dynamicFieldsPanel, "Center");
                this.dynamicContentPanel.revalidate();
            }
            catch (Exception e) {
                ScriptBasedAuthenticationMethodType.this.getScriptsExtension().handleScriptException(scriptW, e);
                log.error((Object)"Error while calling authentication script", (Throwable)e);
                this.warnAndResetPanel(Constant.messages.getString("authentication.method.script.dialog.error.text.loading", ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        private void warnAndResetPanel(String errorMessage) {
            JOptionPane.showMessageDialog(this, errorMessage, Constant.messages.getString("authentication.method.script.dialog.error.title"), 0);
            this.loadedScript = null;
            this.scriptsComboBox.setSelectedItem(null);
            this.dynamicFieldsPanel = null;
            this.dynamicContentPanel.removeAll();
            this.dynamicContentPanel.add((Component)new JLabel(this.LABEL_NOT_LOADED), "Center");
            this.dynamicContentPanel.revalidate();
        }
    }

    public class ScriptBasedAuthenticationMethod
    extends AuthenticationMethod {
        private ScriptWrapper script;
        private String[] credentialsParamNames;
        private Map<String, String> paramValues;
        private HttpSender httpSender;

        protected HttpSender getHttpSender() {
            if (this.httpSender == null) {
                this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 5);
            }
            return this.httpSender;
        }

        public void loadScript(ScriptWrapper scriptW) {
            AuthenticationScript script = ScriptBasedAuthenticationMethodType.this.getScriptInterfaceV2(scriptW);
            if (script == null) {
                script = ScriptBasedAuthenticationMethodType.this.getScriptInterface(scriptW);
            }
            if (script == null) {
                log.warn((Object)("The script " + scriptW.getName() + " does not properly implement the Authentication Script interface."));
                throw new IllegalArgumentException(Constant.messages.getString("authentication.method.script.dialog.error.text.interface", scriptW.getName()));
            }
            try {
                if (script instanceof AuthenticationScriptV2) {
                    AuthenticationScript scriptV2 = script;
                    this.setLoggedInIndicatorPattern(scriptV2.getLoggedInIndicator());
                    this.setLoggedOutIndicatorPattern(scriptV2.getLoggedOutIndicator());
                }
                Object[] requiredParams = script.getRequiredParamsNames();
                Object[] optionalParams = script.getOptionalParamsNames();
                this.credentialsParamNames = script.getCredentialsParamsNames();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded authentication script - required parameters: " + Arrays.toString(requiredParams) + " - optional parameters: " + Arrays.toString(optionalParams)));
                }
                Map<Object, Object> oldValues = this.paramValues != null ? this.paramValues : Collections.emptyMap();
                this.paramValues = new HashMap<String, String>(requiredParams.length + optionalParams.length);
                for (Object param : requiredParams) {
                    this.paramValues.put((String)param, (String)oldValues.get(param));
                }
                for (Object param : optionalParams) {
                    this.paramValues.put((String)param, (String)oldValues.get(param));
                }
                this.script = scriptW;
                log.info((Object)("Successfully loaded new script for ScriptBasedAuthentication: " + this));
            }
            catch (Exception e) {
                log.error((Object)"Error while loading authentication script", (Throwable)e);
                ScriptBasedAuthenticationMethodType.this.getScriptsExtension().handleScriptException(this.script, e);
                throw new IllegalArgumentException(Constant.messages.getString("authentication.method.script.dialog.error.text.loading", e.getMessage()));
            }
        }

        public String toString() {
            return "ScriptBasedAuthenticationMethod [script=" + this.script + ", paramValues=" + this.paramValues + ", credentialsParamNames=" + Arrays.toString(this.credentialsParamNames) + "]";
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        protected AuthenticationMethod duplicate() {
            ScriptBasedAuthenticationMethod method = new ScriptBasedAuthenticationMethod();
            method.script = this.script;
            method.paramValues = this.paramValues != null ? new HashMap<String, String>(this.paramValues) : null;
            method.credentialsParamNames = this.credentialsParamNames;
            return method;
        }

        @Override
        public boolean validateCreationOfAuthenticationCredentials() {
            if (this.credentialsParamNames != null) {
                return true;
            }
            if (View.isInitialised()) {
                View.getSingleton().showMessageDialog(Constant.messages.getString("authentication.method.script.dialog.error.text.notLoaded"));
            }
            return false;
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new GenericAuthenticationCredentials(this.credentialsParamNames);
        }

        @Override
        public AuthenticationMethodType getType() {
            return new ScriptBasedAuthenticationMethodType();
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials credentials, User user) throws AuthenticationMethod.UnsupportedAuthenticationCredentialsException {
            if (!(credentials instanceof GenericAuthenticationCredentials)) {
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Script based Authentication method only supports " + GenericAuthenticationCredentials.class.getSimpleName() + ". Received: " + credentials.getClass());
            }
            GenericAuthenticationCredentials cred = (GenericAuthenticationCredentials)credentials;
            AuthenticationScript script = ScriptBasedAuthenticationMethodType.this.getScriptInterfaceV2(this.script);
            if (script == null) {
                script = ScriptBasedAuthenticationMethodType.this.getScriptInterface(this.script);
            }
            if (script == null) {
                return null;
            }
            HttpMessage msg = null;
            try {
                if (script instanceof AuthenticationScriptV2) {
                    AuthenticationScript scriptV2 = script;
                    this.setLoggedInIndicatorPattern(scriptV2.getLoggedInIndicator());
                    this.setLoggedOutIndicatorPattern(scriptV2.getLoggedOutIndicator());
                }
                msg = script.authenticate(new AuthenticationHelper(this.getHttpSender(), sessionManagementMethod, user), this.paramValues, cred);
            }
            catch (Exception e) {
                log.error((Object)("An error occurred while trying to authenticate using the Authentication Script: " + this.script.getName()), (Throwable)e);
                ScriptBasedAuthenticationMethodType.this.getScriptsExtension().handleScriptException(this.script, e);
                return null;
            }
            if (msg.getRequestHeader().getURI() == null) {
                String error = String.format("Auth request returned by the script '%s' does not have the request-target.", this.script.getName());
                log.error((Object)error);
                error = "ERROR: " + error + "\n";
                ScriptBasedAuthenticationMethodType.this.getScriptsExtension().handleScriptError(this.script, error);
                if (View.isInitialised()) {
                    View.getSingleton().getOutputPanel().appendAsync(error);
                }
                return null;
            }
            if (this.isAuthenticated(msg)) {
                AuthenticationHelper.notifyOutputAuthSuccessful(msg);
            } else {
                AuthenticationHelper.notifyOutputAuthFailure(msg);
            }
            AuthenticationHelper.addAuthMessageToHistory(msg);
            return sessionManagementMethod.extractWebSession(msg);
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("methodName", ScriptBasedAuthenticationMethodType.API_METHOD_NAME);
            values.put(ScriptBasedAuthenticationMethodType.PARAM_SCRIPT_NAME, this.script.getName());
            values.putAll(this.paramValues);
            return new AuthenticationMethod.AuthMethodApiResponseRepresentation(values);
        }

        static /* synthetic */ String[] access$902(ScriptBasedAuthenticationMethod x0, String[] x1) {
            x0.credentialsParamNames = x1;
            return x1;
        }
    }
}

