/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.channel;

import com.cloudhopper.smpp.impl.SmppSessionChannelListener;
import com.cloudhopper.smpp.pdu.Pdu;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SmppSessionWrapper
extends SimpleChannelInboundHandler<Pdu> {
    private static final Logger logger = LoggerFactory.getLogger(SmppSessionWrapper.class);
    private SmppSessionChannelListener listener;

    public SmppSessionWrapper(SmppSessionChannelListener listener) {
        this.listener = listener;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Pdu msg) throws Exception {
        this.listener.firePduReceived(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.listener.fireChannelClosed();
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.listener.fireExceptionThrown(cause.getCause());
    }
}

