/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.action.Action;
import tr.util.Utils;
import tr.view.actions.screens.filters.FilterChoice;
import tr.view.filters.Choice;
import tr.view.filters.ChoiceAll;
import tr.view.filters.ChoiceMultiple;
import tr.view.filters.ChoiceMultipleEdit;
import tr.view.filters.FilterComboAbstract;
import tr.view.filters.MultiChoiceDialog;

public class FilterStatus
extends FilterChoice
implements PropertyChangeListener {
    public static final byte INDEX = 1;
    private static final Logger LOG = Logger.getLogger("tr.view.actions");

    public FilterStatus() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new StatusComboBox();
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Choice choice = (Choice)this.combo.getSelectedItem();
        if (choice == null) {
            this.fireMatchAll();
        } else if (choice instanceof All) {
            this.fireMatchAll();
        } else if (choice instanceof Multiple) {
            Multiple m = (Multiple)choice;
            this.fireChanged(new StatusMatcher(m.getChosen()));
        } else {
            this.fireChanged(new StatusMatcher(choice));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-status");
    }

    public String[] getSerialValues() {
        if (this.combo == null) {
            return null;
        }
        Choice item = (Choice)this.combo.getSelectedItem();
        if (item == null) {
            return null;
        }
        if (item instanceof Multiple) {
            Multiple m = (Multiple)item;
            if (m == null || m.getChosen() == null) {
                return null;
            }
            String[] values = new String[m.getChosen().size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((Choice)m.getChosen().get(i)).getID();
            }
            return values;
        }
        return new String[]{item.getID()};
    }

    public void setSerialValues(String[] values) {
        if (this.combo == null) {
            return;
        }
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else if (values.length == 1) {
            this.combo.setSelectedItem((Object)this.getChoice(values[0]));
        } else if (values.length > 1) {
            this.combo.setSelectedIndex(1);
            Multiple multiple = (Multiple)((Object)this.combo.getItemAt(1));
            multiple.setChosen(new Vector());
            for (String id : values) {
                multiple.getChosen().add(this.getChoice(id));
            }
            this.combo.setSelectedItem((Object)multiple);
        }
        this.combo.startChangeEvents();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterStatus)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Choice thisChoice = (Choice)this.combo.getSelectedItem();
        Choice thatChoice = (Choice)((FilterChoice)((Object)object)).combo.getSelectedItem();
        return Utils.equal((Object)thisChoice, (Object)thatChoice);
    }

    private Choice getChoice(String id) {
        if (id == null) {
            return null;
        }
        if (id.equals("0")) {
            return new All();
        }
        if (id.equals("3")) {
            return new ChoiceDoASAP();
        }
        if (id.equals("4")) {
            return new ChoiceInactive();
        }
        if (id.equals("2")) {
            return new ChoiceDelegated();
        }
        if (id.equals("5")) {
            return new ChoiceScheduled();
        }
        return null;
    }

    public byte getIndex() {
        return 1;
    }

    protected boolean canExcludeNulls() {
        return false;
    }

    public class StatusComboBox
    extends FilterComboAbstract {
        private final Vector<Choice> options;
        private final ActionListener listener;
        private Object lastSelectedItem;

        public StatusComboBox() {
            super((ComboBoxModel)new StatusComboBoxModel());
            this.options = new Vector();
            this.options.add(new ChoiceDoASAP());
            this.options.add(new ChoiceInactive());
            this.options.add(new ChoiceDelegated());
            this.options.add(new ChoiceScheduled());
            this.listener = !Utilities.isMac() ? new WindowsActionListener() : new RealActionListener();
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
            this.lastSelectedItem = this.getSelectedItem();
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        private final class WindowsActionListener
        implements ActionListener {
            private WindowsActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = StatusComboBox.this.getSelectedItem();
                if (object instanceof ChoiceMultipleEdit) {
                    StatusComboBoxModel model = (StatusComboBoxModel)StatusComboBox.this.getModel();
                    Multiple m = model.multiple;
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)StatusComboBox.this), StatusComboBox.this.options, m.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-topic"));
                    d.setLocationRelativeTo((Component)((Object)StatusComboBox.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        m.setChosen(d.getChosen());
                        StatusComboBox.this.setSelectedItem((Object)m);
                        StatusComboBox.this.lastSelectedItem = (Object)m;
                    } else {
                        StatusComboBox.this.setSelectedItem(StatusComboBox.this.lastSelectedItem);
                    }
                } else {
                    StatusComboBox.this.lastSelectedItem = object;
                }
                StatusComboBox.this.fireValueChange();
            }
        }

        private final class RealActionListener
        implements ActionListener {
            private RealActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = StatusComboBox.this.getSelectedItem();
                if (object instanceof Multiple) {
                    Multiple m = (Multiple)((Object)object);
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)StatusComboBox.this), StatusComboBox.this.options, m.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-status"));
                    d.setLocationRelativeTo((Component)((Object)StatusComboBox.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        m.setChosen(d.getChosen());
                    }
                }
                StatusComboBox.this.fireValueChange();
            }
        }
    }

    private class StatusComboBoxModel
    extends DefaultComboBoxModel {
        private final Choice all;
        private final Multiple multiple;
        private final ChoiceMultipleEdit multipleEdit;
        private final Choice doasap;
        private final Choice inactive;
        private final Choice delegated;
        private final Choice scheduled;
        private final Choice[] items;

        public StatusComboBoxModel() {
            this.all = new All();
            this.multiple = new Multiple();
            this.multipleEdit = new ChoiceMultipleEdit();
            this.doasap = new ChoiceDoASAP();
            this.inactive = new ChoiceInactive();
            this.delegated = new ChoiceDelegated();
            this.scheduled = new ChoiceScheduled();
            this.items = !Utilities.isMac() ? new Choice[]{this.all, this.multiple, this.multipleEdit, this.doasap, this.inactive, this.delegated, this.scheduled} : new Choice[]{this.all, this.multiple, this.doasap, this.inactive, this.delegated, this.scheduled};
        }

        public Object getElementAt(int index) {
            return this.items[index];
        }

        public int getSize() {
            return this.items.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatusMatcher
    implements Matcher<Action> {
        private final List<Choice> choices;

        public StatusMatcher(Choice choice) {
            this.choices = new Vector<Choice>();
            this.choices.add(choice);
        }

        public StatusMatcher(List<Choice> choices) {
            this.choices = choices;
        }

        public boolean matches(Action action) {
            for (Choice choice : this.choices) {
                if (choice instanceof All) {
                    return true;
                }
                if (action.isStateASAP() && choice instanceof ChoiceDoASAP) {
                    return true;
                }
                if (action.isStateInactive() && choice instanceof ChoiceInactive) {
                    return true;
                }
                if (action.isStateScheduled() && choice instanceof ChoiceScheduled) {
                    return true;
                }
                if (!action.isStateDelegated() || !(choice instanceof ChoiceDelegated)) continue;
                return true;
            }
            return false;
        }
    }

    public class ChoiceScheduled
    extends Choice {
        public static final String ID = "5";

        public String getID() {
            return ID;
        }

        public String getLabel() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-status-scheduled");
        }
    }

    public class ChoiceInactive
    extends Choice {
        public static final String ID = "4";

        public String getID() {
            return ID;
        }

        public String getLabel() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-status-inactive");
        }
    }

    public class ChoiceDoASAP
    extends Choice {
        public static final String ID = "3";

        public String getID() {
            return ID;
        }

        public String getLabel() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-status-doasap");
        }
    }

    public class ChoiceDelegated
    extends Choice {
        public static final String ID = "2";

        public String getID() {
            return ID;
        }

        public String getLabel() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-status-delegated");
        }
    }

    private class Multiple
    extends ChoiceMultiple {
        public static final String ID = "1";

        private Multiple() {
        }

        public String getID() {
            return ID;
        }
    }

    public class All
    extends ChoiceAll {
        public static final String ID = "0";

        public String getID() {
            return ID;
        }
    }
}

