/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkDynamicConfig;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperStatusHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int ZOOKEEPER_DEFAULT_PORT = 2181;
    private static final String STATUS_RED = "red";
    private static final String STATUS_GREEN = "green";
    private static final String STATUS_YELLOW = "yellow";
    private static final String STATUS_NA = "N/A";
    private CoreContainer cores;

    public ZookeeperStatusHandler(CoreContainer cc) {
        this.cores = cc;
    }

    @Override
    public String getDescription() {
        return "Fetch Zookeeper status";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        NamedList values = rsp.getValues();
        if (!this.cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The Zookeeper status API is only available in Cloud mode");
        }
        String zkHost = this.cores.getZkController().getZkServerAddress();
        SolrZkClient zkClient = this.cores.getZkController().getZkClient();
        ZkDynamicConfig dynConfig = ZkDynamicConfig.parseLines((String)zkClient.getConfig());
        values.add("zkStatus", this.getZkStatus(zkHost, dynConfig));
    }

    protected Map<String, Object> getZkStatus(String zkHost, ZkDynamicConfig zkDynamicConfig) {
        ZkDynamicConfig zookeepers;
        boolean dynamicReconfig;
        ZkDynamicConfig hostsFromConnectionString = ZkDynamicConfig.fromZkConnectString((String)zkHost);
        ArrayList<String> errors = new ArrayList<String>();
        String status = STATUS_NA;
        if (zkDynamicConfig.size() == 0) {
            dynamicReconfig = false;
            zookeepers = hostsFromConnectionString;
        } else {
            List dynamicHosts;
            dynamicReconfig = true;
            List connStringHosts = hostsFromConnectionString.getServers().stream().map(h -> h.resolveClientPortAddress() + ":" + h.clientPort).sorted().collect(Collectors.toList());
            if (!connStringHosts.containsAll(dynamicHosts = zkDynamicConfig.getServers().stream().map(h -> h.resolveClientPortAddress() + ":" + (h.clientPort != null ? h.clientPort : ((ZkDynamicConfig.Server)hostsFromConnectionString.getServers().get((int)0)).clientPort)).sorted().collect(Collectors.toList()))) {
                errors.add("Your ZK connection string (" + connStringHosts.size() + " hosts) is different from the dynamic ensemble config (" + dynamicHosts.size() + " hosts). Solr does not currently support dynamic reconfiguration and will only be able to connect to the zk hosts in your connection string.");
                status = STATUS_YELLOW;
            }
            zookeepers = ((ZkDynamicConfig.Server)zkDynamicConfig.getServers().get((int)0)).clientPort != null ? zkDynamicConfig : hostsFromConnectionString;
        }
        HashMap<String, Object> zkStatus = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> details = new ArrayList<Map<String, Object>>();
        int numOk = 0;
        int standalone = 0;
        int followers = 0;
        int reportedFollowers = 0;
        int leaders = 0;
        zkStatus.put("ensembleSize", zookeepers.size());
        zkStatus.put("zkHost", zkHost);
        for (ZkDynamicConfig.Server zk : zookeepers.getServers()) {
            String zkClientHostPort = zk.resolveClientPortAddress() + ":" + zk.clientPort;
            try {
                String state;
                Map<String, Object> stat = this.monitorZookeeper(zkClientHostPort);
                if (stat.containsKey("errors")) {
                    errors.addAll((List)stat.get("errors"));
                    stat.remove("errors");
                }
                details.add(stat);
                if ("true".equals(String.valueOf(stat.get("ok")))) {
                    ++numOk;
                }
                if ("follower".equals(state = String.valueOf(stat.get("zk_server_state"))) || "observer".equals(state)) {
                    ++followers;
                } else if ("leader".equals(state)) {
                    ++leaders;
                    reportedFollowers = Math.max(Integer.parseInt((String)stat.getOrDefault("zk_followers", "0")), Integer.parseInt((String)stat.getOrDefault("zk_synced_followers", "0")));
                } else if ("standalone".equals(state)) {
                    ++standalone;
                }
                if (zk.role == null) continue;
                stat.put("role", zk.role);
            }
            catch (SolrException se) {
                log.warn("Failed talking to zookeeper {}", (Object)zkClientHostPort, (Object)se);
                errors.add(se.getMessage());
                HashMap<String, Object> stat = new HashMap<String, Object>();
                stat.put("host", zkClientHostPort);
                stat.put("ok", false);
                status = STATUS_YELLOW;
                details.add(stat);
            }
        }
        zkStatus.put("details", details);
        zkStatus.put("dynamicReconfig", dynamicReconfig);
        if (followers + leaders > 0 && standalone > 0) {
            status = STATUS_RED;
            errors.add("The zk nodes do not agree on their mode, check details");
        }
        if (standalone > 1) {
            status = STATUS_RED;
            errors.add("Only one zk allowed in standalone mode");
        }
        if (leaders > 1) {
            zkStatus.put("mode", "ensemble");
            status = STATUS_RED;
            errors.add("Only one leader allowed, got " + leaders);
        }
        if (followers > 0 && leaders == 0) {
            zkStatus.put("mode", "ensemble");
            status = STATUS_RED;
            errors.add("We do not have a leader");
        }
        if (leaders > 0 && followers != reportedFollowers) {
            zkStatus.put("mode", "ensemble");
            status = STATUS_RED;
            errors.add("Leader reports " + reportedFollowers + " followers, but we only found " + followers + ". Please check zkHost configuration");
        }
        if (followers + leaders == 0 && standalone == 1) {
            zkStatus.put("mode", "standalone");
        }
        if (followers + leaders > 0 && zookeepers.size() % 2 == 0) {
            if (!STATUS_RED.equals(status)) {
                status = STATUS_YELLOW;
            }
            errors.add("We have an even number of zookeepers which is not recommended");
        }
        if (followers + leaders > 0 && standalone == 0) {
            zkStatus.put("mode", "ensemble");
        }
        if (status.equals(STATUS_NA)) {
            if (numOk == zookeepers.size()) {
                status = STATUS_GREEN;
            } else if (numOk < zookeepers.size() && numOk > zookeepers.size() / 2) {
                status = STATUS_YELLOW;
                errors.add("Some zookeepers are down: " + numOk + "/" + zookeepers.size());
            } else {
                status = STATUS_RED;
                errors.add("Mismatch in number of zookeeper nodes live. numOK=" + numOk + ", expected " + zookeepers.size());
            }
        }
        zkStatus.put("status", status);
        if (!errors.isEmpty()) {
            zkStatus.put("errors", errors);
        }
        return zkStatus;
    }

    protected Map<String, Object> monitorZookeeper(String zkHostPort) throws SolrException {
        String err;
        String[] parts;
        HashMap<String, Object> obj = new HashMap<String, Object>();
        ArrayList<String> errors = new ArrayList<String>();
        obj.put("host", zkHostPort);
        List<String> lines = this.getZkRawResponse(zkHostPort, "ruok");
        this.validateZkRawResponse(lines, zkHostPort, "ruok");
        boolean ok = "imok".equals(lines.get(0));
        obj.put("ok", ok);
        lines = this.getZkRawResponse(zkHostPort, "mntr");
        this.validateZkRawResponse(lines, zkHostPort, "mntr");
        for (String line : lines) {
            parts = line.split("\t");
            if (parts.length >= 2) {
                obj.put(parts[0], parts[1]);
                continue;
            }
            err = String.format(Locale.ENGLISH, "Unexpected line in 'mntr' response from Zookeeper %s: %s", zkHostPort, line);
            log.warn(err);
            errors.add(err);
        }
        lines = this.getZkRawResponse(zkHostPort, "conf");
        this.validateZkRawResponse(lines, zkHostPort, "conf");
        for (String line : lines) {
            parts = line.split("=");
            if (parts.length >= 2) {
                obj.put(parts[0], parts[1]);
                continue;
            }
            if (line.startsWith("membership:")) continue;
            err = String.format(Locale.ENGLISH, "Unexpected line in 'conf' response from Zookeeper %s: %s", zkHostPort, line);
            log.warn(err);
            errors.add(err);
        }
        obj.put("errors", errors);
        return obj;
    }

    /*
     * Exception decompiling
     */
    protected List<String> getZkRawResponse(String zkHostPort, String fourLetterWordCommand) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean validateZkRawResponse(List<String> response, String zkHostPort, String fourLetterWordCommand) {
        if (response == null || response.isEmpty() || response.size() == 1 && response.get(0).trim().isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Empty response from Zookeeper " + zkHostPort);
        }
        if (response.size() == 1 && response.get(0).contains("not in the whitelist")) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not execute " + fourLetterWordCommand + " towards ZK host " + zkHostPort + ". Add this line to the 'zoo.cfg' configuration file on each zookeeper node: '4lw.commands.whitelist=mntr,conf,ruok'. See also chapter 'Setting Up an External ZooKeeper Ensemble' in the Solr Reference Guide.");
        }
        return true;
    }
}

