/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_REQUIRE_HEALTHY_CORES = "requireHealthyCores";
    private static final List<Replica.State> UNHEALTHY_STATES = Arrays.asList(Replica.State.DOWN, Replica.State.RECOVERING);
    CoreContainer coreContainer;

    public HealthCheckHandler() {
    }

    public HealthCheckHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        rsp.setHttpCaching(false);
        if (cores == null || cores.isShutDown()) {
            rsp.setException((Exception)((Object)new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreContainer is either not initialized or shutting down")));
            return;
        }
        if (!cores.isZooKeeperAware()) {
            rsp.setException((Exception)((Object)new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Health check is only available when running in SolrCloud mode")));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoked HealthCheckHandler on [{}]", (Object)this.coreContainer.getZkController().getNodeName());
        }
        ZkStateReader zkStateReader = cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        if (zkStateReader.getZkClient().isClosed() || !zkStateReader.getZkClient().isConnected()) {
            rsp.add("status", "FAILURE");
            rsp.setException((Exception)((Object)new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Host Unavailable: Not connected to zk")));
            return;
        }
        if (!clusterState.getLiveNodes().contains(cores.getZkController().getNodeName())) {
            rsp.add("status", "FAILURE");
            rsp.setException((Exception)((Object)new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Host Unavailable: Not in live nodes as per zk")));
            return;
        }
        if (req.getParams().getBool(PARAM_REQUIRE_HEALTHY_CORES, false)) {
            Collection coreDescriptors = cores.getCores().stream().map(c -> c.getCoreDescriptor().getCloudDescriptor()).collect(Collectors.toList());
            long unhealthyCores = HealthCheckHandler.findUnhealthyCores(coreDescriptors, clusterState);
            if (unhealthyCores > 0L) {
                rsp.add("status", "FAILURE");
                rsp.add("num_cores_unhealthy", unhealthyCores);
                rsp.setException((Exception)((Object)new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, unhealthyCores + " out of " + cores.getAllCoreNames().size() + " replicas are currently initializing or recovering")));
                return;
            }
            rsp.add("message", "All cores are healthy");
        }
        rsp.add("status", "OK");
    }

    static long findUnhealthyCores(Collection<CloudDescriptor> cores, ClusterState clusterState) {
        return cores.stream().filter(c -> !c.hasRegistered() || UNHEALTHY_STATES.contains(c.getLastPublished())).filter(c -> clusterState.hasCollection(c.getCollectionName())).filter(c -> clusterState.getCollection(c.getCollectionName()).getActiveSlicesMap().containsKey(c.getShardId())).count();
    }

    @Override
    public String getDescription() {
        return "Health check handler for SolrCloud node";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }
}

