/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.draw;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.apache.poi.sl.draw.BitmapImageRenderer;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.Units;

public class HemfImageRenderer
implements ImageRenderer {
    HemfPicture image;
    double alpha;

    public boolean canRender(String contentType) {
        return PictureData.PictureType.EMF.contentType.equalsIgnoreCase(contentType);
    }

    public void loadImage(InputStream data, String contentType) throws IOException {
        if (!PictureData.PictureType.EMF.contentType.equals(contentType)) {
            throw new IOException("Invalid picture type");
        }
        this.image = new HemfPicture(data);
    }

    public void loadImage(byte[] data, String contentType) throws IOException {
        if (!PictureData.PictureType.EMF.contentType.equals(contentType)) {
            throw new IOException("Invalid picture type");
        }
        this.image = new HemfPicture(new ByteArrayInputStream(data));
    }

    public Dimension2D getDimension() {
        return Units.pointsToPixel((Dimension2D)(this.image == null ? new Dimension() : this.image.getSize()));
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public BufferedImage getImage() {
        return this.getImage(this.getDimension());
    }

    public BufferedImage getImage(Dimension2D dim) {
        if (this.image == null) {
            return new BufferedImage(1, 1, 2);
        }
        BufferedImage bufImg = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), 2);
        Graphics2D g = bufImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.image.draw(g, new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight()));
        g.dispose();
        return BitmapImageRenderer.setAlpha((BufferedImage)bufImg, (double)this.alpha);
    }

    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor) {
        return this.drawImage(graphics, anchor, null);
    }

    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor, Insets clip) {
        if (this.image == null) {
            return false;
        }
        this.image.draw(graphics, anchor);
        return true;
    }

    public GenericRecord getGenericRecord() {
        return this.image;
    }
}

