/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.NodeUtils;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.util.StringUtils;
import org.slf4j.Logger;

public class SimpleNode
implements Node {
    protected RuntimeServices rsvc = null;
    protected Logger log = null;
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    protected int info;
    public boolean state;
    protected boolean invalid = false;
    protected Token first;
    protected Token last;
    protected Template template;
    protected String literal = null;
    protected int line;
    protected int column;
    protected String firstImage;
    protected String lastImage;

    public RuntimeServices getRuntimeServices() {
        return this.rsvc;
    }

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser, int n) {
        this(n);
        this.parser = parser;
        this.template = this.parser.currentTemplate;
    }

    @Override
    public void jjtOpen() {
        this.first = this.parser.getToken(1);
    }

    @Override
    public void jjtClose() {
        this.last = this.parser.getToken(0);
    }

    public void setFirstToken(Token token) {
        this.first = token;
    }

    @Override
    public Token getFirstToken() {
        return this.first;
    }

    @Override
    public Token getLastToken() {
        return this.last;
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    @Override
    public Object childrenAccept(ParserVisitor parserVisitor, Object object) {
        if (this.children != null) {
            for (Node node : this.children) {
                node.jjtAccept(parserVisitor, object);
            }
        }
        return object;
    }

    public String toString(String string) {
        return string + "_" + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString());
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                System.out.print(string + " |_");
                if (simpleNode == null) continue;
                simpleNode.dump(string + (i == this.children.length - 1 ? "   " : " | "));
            }
        }
    }

    protected String getLocation(InternalContextAdapter internalContextAdapter) {
        return StringUtils.formatFileString(this);
    }

    @Override
    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        if (this.first == this.last) {
            this.literal = NodeUtils.tokenLiteral(this.first);
            return this.literal;
        }
        Token token = this.first;
        StringBuilder stringBuilder = new StringBuilder(NodeUtils.tokenLiteral(token));
        while (token != this.last) {
            token = token.next;
            stringBuilder.append(NodeUtils.tokenLiteral(token));
        }
        this.literal = stringBuilder.toString();
        return this.literal;
    }

    @Override
    public Object init(InternalContextAdapter internalContextAdapter, Object object) throws TemplateInitException {
        this.rsvc = (RuntimeServices)object;
        this.log = this.rsvc.getLog("rendering");
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            this.jjtGetChild(i).init(internalContextAdapter, object);
        }
        this.line = this.first.beginLine;
        this.column = this.first.beginColumn;
        return object;
    }

    @Override
    public boolean evaluate(InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        return false;
    }

    @Override
    public Object value(InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        return null;
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer) throws IOException, MethodInvocationException, ParseErrorException, ResourceNotFoundException {
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            this.jjtGetChild(i).render(internalContextAdapter, writer);
        }
        return true;
    }

    @Override
    public Object execute(Object object, InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        return null;
    }

    @Override
    public int getType() {
        return this.id;
    }

    @Override
    public void setInfo(int n) {
        this.info = n;
    }

    @Override
    public int getInfo() {
        return this.info;
    }

    @Override
    public void setInvalid() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.getFirstToken();
        while (object != null) {
            stringBuilder.append("[").append(((Token)object).image).append("]");
            if (((Token)object).next != null) {
                if (object.equals(this.getLastToken())) break;
                stringBuilder.append(", ");
            }
            object = ((Token)object).next;
        }
        if (((String)(object = stringBuilder.toString())).length() > 50) {
            object = ((String)object).substring(0, 50) + "...";
        }
        return this.getClass().getSimpleName() + " [id=" + this.id + ", info=" + this.info + ", invalid=" + this.invalid + ", tokens=" + (String)object + "]";
    }

    @Override
    public String getTemplateName() {
        return this.template.getName();
    }

    public void saveTokenImages() {
        if (this.first != null) {
            this.firstImage = this.first.image;
        }
        if (this.last != null) {
            this.lastImage = this.last.image;
        }
    }

    public void cleanupParserAndTokens() {
        this.parser = null;
        this.first = null;
        this.last = null;
    }

    @Override
    public String getFirstTokenImage() {
        return this.firstImage;
    }

    @Override
    public String getLastTokenImage() {
        return this.lastImage;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }
}

