/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.pydev;

import java.util.Iterator;

public final class FastStringBuffer {
    private char[] value;
    private int count;

    public FastStringBuffer() {
        this(128);
    }

    public FastStringBuffer(int initialSize) {
        this.value = new char[initialSize];
        this.count = 0;
    }

    public FastStringBuffer(String s, int additionalSize) {
        this.count = s.length();
        this.value = new char[this.count + additionalSize];
        s.getChars(0, this.count, this.value, 0);
    }

    public FastStringBuffer append(String string) {
        int strLen = string.length();
        int newCount = this.count + strLen;
        if (newCount > this.value.length) {
            this.resizeForMinimum(newCount);
        }
        string.getChars(0, strLen, this.value, this.count);
        this.count = newCount;
        return this;
    }

    private void resizeForMinimum(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public FastStringBuffer append(int n) {
        this.append(String.valueOf(n));
        return this;
    }

    public FastStringBuffer append(char n) {
        if (this.count + 1 > this.value.length) {
            this.resizeForMinimum(this.count + 1);
        }
        this.value[this.count] = n;
        ++this.count;
        return this;
    }

    public FastStringBuffer append(long n) {
        this.append(String.valueOf(n));
        return this;
    }

    public FastStringBuffer append(boolean b) {
        this.append(String.valueOf(b));
        return this;
    }

    public FastStringBuffer append(char[] chars) {
        int newCount = this.count + chars.length;
        if (newCount > this.value.length) {
            this.resizeForMinimum(newCount);
        }
        System.arraycopy(chars, 0, this.value, this.count, chars.length);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer other) {
        this.append(other.value, 0, other.count);
        return this;
    }

    public FastStringBuffer append(char[] chars, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.resizeForMinimum(newCount);
        }
        System.arraycopy(chars, offset, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer reverse() {
        int limit = this.count / 2;
        for (int i = 0; i < limit; ++i) {
            char c = this.value[i];
            this.value[i] = this.value[this.count - i - 1];
            this.value[this.count - i - 1] = c;
        }
        return this;
    }

    public FastStringBuffer clear() {
        this.count = 0;
        return this;
    }

    public int length() {
        return this.count;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public char[] toCharArray() {
        char[] v = new char[this.count];
        System.arraycopy(this.value, 0, v, 0, this.count);
        return v;
    }

    public void deleteLast() {
        if (this.count > 0) {
            --this.count;
        }
    }

    public char charAt(int i) {
        return this.value[i];
    }

    public FastStringBuffer insert(int offset, String str) {
        int len = str.length();
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.resizeForMinimum(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer insert(int offset, char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            this.resizeForMinimum(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newCount;
        return this;
    }

    public FastStringBuffer appendObject(Object object) {
        return this.append(object != null ? object.toString() : "null");
    }

    public void setCount(int newLen) {
        this.count = newLen;
    }

    public FastStringBuffer delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public FastStringBuffer replace(int start, int end, String str) {
        int len;
        int newCount;
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (end > this.count) {
            end = this.count;
        }
        if (end > this.count) {
            end = this.count;
        }
        if ((newCount = this.count + (len = str.length()) - (end - start)) > this.value.length) {
            this.resizeForMinimum(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, len, this.value, start);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer replaceAll(String replace, String with2) {
        int replaceLen = replace.length();
        int withLen = with2.length();
        int matchPos = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.value[i] == replace.charAt(matchPos)) {
                if (++matchPos != replaceLen) continue;
                this.replace(i - (replaceLen - 1), i + 1, with2);
                matchPos = 0;
                i -= replaceLen - withLen;
                continue;
            }
            matchPos = 0;
        }
        return this;
    }

    public FastStringBuffer deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.count; ++i) {
            if (c != this.value[i]) continue;
            return i;
        }
        return -1;
    }

    public char firstChar() {
        return this.value[0];
    }

    public char lastChar() {
        return this.value[this.count - 1];
    }

    public BackwardCharIterator reverseIterator() {
        return new BackwardCharIterator(this);
    }

    public void rightTrim() {
        char c;
        while ((c = this.lastChar()) == ' ' || c == '\t') {
            this.deleteLast();
        }
    }

    public char deleteFirst() {
        char ret = this.value[0];
        this.deleteCharAt(0);
        return ret;
    }

    public FastStringBuffer appendN(String val, int n) {
        int min = this.count + n * val.length();
        if (min > this.value.length) {
            this.resizeForMinimum(min);
        }
        int strLen = val.length();
        while (n-- > 0) {
            val.getChars(0, strLen, this.value, this.count);
            this.count += strLen;
        }
        return this;
    }

    public FastStringBuffer appendN(char val, int n) {
        if (this.count + n > this.value.length) {
            this.resizeForMinimum(this.count + n);
        }
        while (n-- > 0) {
            this.value[this.count] = val;
            ++this.count;
        }
        return this;
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.length());
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int offset) {
        char[] ta = this.value;
        int to = offset;
        char[] pa = prefix.toCharArray();
        int po = 0;
        int pc = pa.length;
        if (offset < 0 || offset > this.count - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public void setCharAt(int i, char c) {
        this.value[i] = c;
    }

    public void setLength(int i) {
        this.count = i;
    }

    public static final class BackwardCharIterator
    implements Iterable<Character> {
        private int i;
        private final FastStringBuffer fastStringBuffer;

        public BackwardCharIterator(FastStringBuffer fastStringBuffer) {
            this.fastStringBuffer = fastStringBuffer;
            this.i = fastStringBuffer.length();
        }

        @Override
        public Iterator<Character> iterator() {
            return new Iterator<Character>(){

                @Override
                public boolean hasNext() {
                    return i > 0;
                }

                @Override
                public Character next() {
                    return Character.valueOf(fastStringBuffer.value[--i]);
                }

                @Override
                public void remove() {
                    throw new RuntimeException("Not implemented");
                }
            };
        }
    }
}

