/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.BackgroundTaskGroup;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.BranchMerger;
import org.jetbrains.idea.svn.integrate.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.integrate.LocalChangesPromptTask;
import org.jetbrains.idea.svn.integrate.LookForBranchOriginTask;
import org.jetbrains.idea.svn.integrate.MergeCalculatorTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeTask;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SelectMergeItemsResult;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;

public class QuickMerge
extends BackgroundTaskGroup {
    private static final Logger LOG = Logger.getInstance(QuickMerge.class);
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final QuickMergeInteraction myInteraction;
    @NotNull
    private final Semaphore mySemaphore;

    public QuickMerge(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) {
        if (mergeContext == null) {
            QuickMerge.$$$reportNull$$$0(0);
        }
        if (interaction == null) {
            QuickMerge.$$$reportNull$$$0(1);
        }
        super(mergeContext.getProject(), mergeContext.getTitle());
        this.mySemaphore = new Semaphore();
        this.myMergeContext = mergeContext;
        this.myInteraction = interaction;
    }

    @NotNull
    public MergeContext getMergeContext() {
        MergeContext mergeContext = this.myMergeContext;
        if (mergeContext == null) {
            QuickMerge.$$$reportNull$$$0(2);
        }
        return mergeContext;
    }

    @NotNull
    public QuickMergeInteraction getInteraction() {
        QuickMergeInteraction quickMergeInteraction = this.myInteraction;
        if (quickMergeInteraction == null) {
            QuickMerge.$$$reportNull$$$0(3);
        }
        return quickMergeInteraction;
    }

    @Override
    public void showErrors() {
        if (!this.myExceptions.isEmpty()) {
            this.myInteraction.showErrors(this.myMergeContext.getTitle(), this.myExceptions);
        }
    }

    public void waitForTasksToFinish() {
        super.waitForTasksToFinish();
        this.mySemaphore.waitFor();
    }

    @Override
    public void end() {
        super.end();
        this.mySemaphore.up();
    }

    public void end(@NotNull String message, boolean isError) {
        if (message == null) {
            QuickMerge.$$$reportNull$$$0(4);
        }
        LOG.info((isError ? "Error: " : "Info: ") + message);
        this.clear();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myInteraction.showErrors(message, isError);
            this.mySemaphore.up();
        });
    }

    public boolean is18() {
        return this.myMergeContext.getWcInfo().getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_EIGHT);
    }

    public void execute() {
        FileDocumentManager.getInstance().saveAllDocuments();
        this.mySemaphore.down();
        this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> {
            if (QuickMerge.areInSameHierarchy(this.myMergeContext.getSourceUrl(), this.myMergeContext.getWcInfo().getUrl())) {
                this.end("Cannot merge from self", true);
            } else if (!this.hasSwitchedRoots() || this.myInteraction.shouldContinueSwitchedRootFound()) {
                this.runInBackground("Checking repository capabilities", (ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> {
                    if (this.supportsMergeInfo()) {
                        this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)this::selectMergeVariant));
                    } else {
                        this.mergeAll(false);
                    }
                }));
            }
        }));
    }

    private void selectMergeVariant() {
        switch (this.myInteraction.selectMergeVariant()) {
            case all: {
                this.mergeAll(true);
                break;
            }
            case showLatest: {
                this.runInBackground("Loading recent " + this.myMergeContext.getBranchName() + " revisions", new MergeCalculatorTask(this, null, (Consumer<MergeCalculatorTask>)((Consumer)task -> this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> this.selectRevisionsToMerge((MergeCalculatorTask)task, false))))));
                break;
            }
            case select: {
                this.runInBackground("Looking for branch origin", new LookForBranchOriginTask(this, false, (Consumer<? super SvnBranchPointsCalculator.WrapperInvertor>)((Consumer)copyPoint -> this.runInBackground("Filtering " + this.myMergeContext.getBranchName() + " revisions", new MergeCalculatorTask(this, (SvnBranchPointsCalculator.WrapperInvertor)copyPoint, (Consumer<MergeCalculatorTask>)((Consumer)task -> this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> this.selectRevisionsToMerge((MergeCalculatorTask)task, true)))))))));
            }
        }
    }

    private void selectRevisionsToMerge(@NotNull MergeCalculatorTask task, boolean allStatusesCalculated) {
        if (task == null) {
            QuickMerge.$$$reportNull$$$0(5);
        }
        SelectMergeItemsResult result = this.myInteraction.selectMergeItems(task.getChangeLists(), task.getMergeChecker(), allStatusesCalculated, task.areAllListsLoaded());
        switch (result.getResultCode()) {
            case all: {
                this.mergeAll(true);
                break;
            }
            case showLatest: 
            case select: {
                this.merge(result.getSelectedLists());
                break;
            }
        }
    }

    private void mergeAll(boolean supportsMergeInfo) {
        if (supportsMergeInfo && this.is18()) {
            this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> this.checkReintegrateIsAllowedAndMergeAll(null, true)));
        } else {
            this.runInBackground("Looking for branch origin", new LookForBranchOriginTask(this, true, (Consumer<? super SvnBranchPointsCalculator.WrapperInvertor>)((Consumer)copyPoint -> this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> this.checkReintegrateIsAllowedAndMergeAll((SvnBranchPointsCalculator.WrapperInvertor)copyPoint, supportsMergeInfo))))));
        }
    }

    private void checkReintegrateIsAllowedAndMergeAll(@Nullable SvnBranchPointsCalculator.WrapperInvertor copyPoint, boolean supportsMergeInfo) {
        boolean reintegrate;
        boolean bl = reintegrate = copyPoint != null && copyPoint.isInvertedSense();
        if (!reintegrate || this.myInteraction.shouldReintegrate(copyPoint.inverted().getTarget())) {
            MergerFactory mergerFactory = this.createMergeAllFactory(reintegrate, copyPoint, supportsMergeInfo);
            String title = "Merging all from " + this.myMergeContext.getBranchName() + (reintegrate ? " (reintegrate)" : "");
            this.merge(title, mergerFactory, null);
        }
    }

    private void merge(@NotNull List<SvnChangeList> changeLists) {
        if (changeLists == null) {
            QuickMerge.$$$reportNull$$$0(6);
        }
        if (!changeLists.isEmpty()) {
            ChangeListsMergerFactory mergerFactory = new ChangeListsMergerFactory(changeLists, false, false, true);
            this.merge(this.myMergeContext.getTitle(), mergerFactory, changeLists);
        }
    }

    private void merge(@NotNull String title, @NotNull MergerFactory mergerFactory, @Nullable List<SvnChangeList> changeLists) {
        if (title == null) {
            QuickMerge.$$$reportNull$$$0(7);
        }
        if (mergerFactory == null) {
            QuickMerge.$$$reportNull$$$0(8);
        }
        this.runInEdt(new LocalChangesPromptTask(this, changeLists, () -> this.runInEdt(new MergeTask(this, () -> this.newIntegrateTask(title, mergerFactory).queue()))));
    }

    @NotNull
    private Task newIntegrateTask(@NotNull String title, @NotNull MergerFactory mergerFactory) {
        if (title == null) {
            QuickMerge.$$$reportNull$$$0(9);
        }
        if (mergerFactory == null) {
            QuickMerge.$$$reportNull$$$0(10);
        }
        return new SvnIntegrateChangesTask(this.myMergeContext.getVcs(), new WorkingCopyInfo(this.myMergeContext.getWcInfo().getPath(), true), mergerFactory, this.myMergeContext.getSourceUrl(), title, false, this.myMergeContext.getBranchName()){

            public void onFinished() {
                super.onFinished();
                QuickMerge.this.mySemaphore.up();
            }
        };
    }

    private boolean hasSwitchedRoots() {
        File currentRoot = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        return this.myMergeContext.getVcs().getAllWcInfos().stream().filter(info2 -> NestedCopyType.switched.equals((Object)info2.getType())).anyMatch(info2 -> FileUtil.isAncestor((File)currentRoot, (File)info2.getRootInfo().getIoFile(), (boolean)true));
    }

    private boolean supportsMergeInfo() {
        return this.myMergeContext.getWcInfo().getFormat().supportsMergeInfo() && SvnUtil.checkRepositoryVersion15(this.myMergeContext.getVcs(), this.myMergeContext.getSourceUrl());
    }

    @NotNull
    private MergerFactory createMergeAllFactory(boolean reintegrate, @Nullable SvnBranchPointsCalculator.WrapperInvertor copyPoint, boolean supportsMergeInfo) {
        long revision = copyPoint != null ? (reintegrate ? copyPoint.getWrapped().getTargetRevision() : copyPoint.getWrapped().getSourceRevision()) : -1L;
        MergerFactory mergerFactory = (vcs, target, handler, currentBranchUrl, branchName) -> new BranchMerger(vcs, currentBranchUrl, this.myMergeContext.getWcInfo().getPath(), handler, reintegrate, this.myMergeContext.getBranchName(), revision, supportsMergeInfo);
        if (mergerFactory == null) {
            QuickMerge.$$$reportNull$$$0(11);
        }
        return mergerFactory;
    }

    private static boolean areInSameHierarchy(@NotNull Url url1, @NotNull Url url2) {
        if (url1 == null) {
            QuickMerge.$$$reportNull$$$0(12);
        }
        if (url2 == null) {
            QuickMerge.$$$reportNull$$$0(13);
        }
        return SvnUtil.isAncestor(url1, url2) || SvnUtil.isAncestor(url2, url1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interaction";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/QuickMerge";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergerFactory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/QuickMerge";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteraction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeAllFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "end";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectRevisionsToMerge";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newIntegrateTask";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areInSameHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

