/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHNotFoundException;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRDetailsService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHServiceUtil;
import org.jetbrains.plugins.github.util.CollectionDelta;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J2\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "adjustAssignees", "Ljava/util/concurrent/CompletableFuture;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "delta", "Lorg/jetbrains/plugins/github/util/CollectionDelta;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "adjustLabels", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "adjustReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "loadDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "progressIndicator", "updateDetails", "title", "", "description", "Companion", "intellij.vcs.github"})
public final class GHPRDetailsServiceImpl
implements GHPRDetailsService {
    private final GithubServerPath serverPath;
    private final GHRepositoryPath repoPath;
    private final ProgressManager progressManager;
    private final GithubApiRequestExecutor requestExecutor;
    private final GHRepositoryCoordinates repository;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public CompletableFuture<GHPullRequest> loadDetails(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkParameterIsNotNull((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkParameterIsNotNull((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(GithubAsyncUtilKt.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequest>(this, pullRequestId){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;

            @NotNull
            public final GHPullRequest invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GHPullRequest gHPullRequest = (GHPullRequest)GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.findOne(GHPRDetailsServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getNumber()));
                if (gHPullRequest == null) {
                    throw (Throwable)new GHNotFoundException("Pull request " + this.$pullRequestId.getNumber() + " does not exist");
                }
                return gHPullRequest;
            }
            {
                this.this$0 = gHPRDetailsServiceImpl;
                this.$pullRequestId = gHPRIdentifier;
                super(1);
            }
        }), LOG, "Error occurred while loading PR details");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequest> updateDetails(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @Nullable String title, @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(GithubAsyncUtilKt.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, GHPullRequest>(this, pullRequestId, title, description){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ String $title;
            final /* synthetic */ String $description;

            @NotNull
            public final GHPullRequest invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (GHPullRequest)GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.update(GHPRDetailsServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getId(), this.$title, this.$description));
            }
            {
                this.this$0 = gHPRDetailsServiceImpl;
                this.$pullRequestId = gHPRIdentifier;
                this.$title = string;
                this.$description = string2;
                super(1);
            }
        }), LOG, "Error occurred while loading PR details");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustReviewers(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @NotNull CollectionDelta<? extends GHPullRequestRequestedReviewer> delta) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkParameterIsNotNull(delta, (String)"delta");
        return GHServiceUtil.INSTANCE.logError(GithubAsyncUtilKt.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, Unit>(this, delta, pullRequestId){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ CollectionDelta $delta;
            final /* synthetic */ GHPRIdentifier $pullRequestId;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Collection<T> newItems;
                String string;
                Object object;
                Collection<String> collection;
                Collection destination$iv$iv;
                GithubApiRequestExecutor githubApiRequestExecutor;
                ProgressIndicator progressIndicator;
                GithubServerPath githubServerPath;
                String string2;
                String string3;
                long l;
                Collection<T> removedItems;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable<Object> iterable = removedItems = this.$delta.getRemovedItems();
                boolean bl = false;
                if (!iterable.isEmpty()) {
                    GHTeam it2;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    it.setText2(GithubBundle.message("pull.request.removing.reviewers", new Object[0]));
                    iterable = CollectionsKt.filterIsInstance((Iterable)removedItems, GHUser.class);
                    l = this.$pullRequestId.getNumber();
                    string3 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                    string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                    githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                    progressIndicator = it;
                    githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                    boolean $i$f$map = false;
                    void var5_12 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        GHUser gHUser = (GHUser)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        object = ((GHUser)((Object)it2)).getLogin();
                        collection.add((String)object);
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = CollectionsKt.filterIsInstance((Iterable)removedItems, GHTeam.class);
                    collection = collection;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (GHTeam)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl3 = false;
                        string = it2.getSlug();
                        object.add(string);
                    }
                    object = (List)destination$iv$iv;
                    githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.PullRequests.Reviewers.remove(githubServerPath, string2, string3, l, collection, (List<String>)object));
                }
                Iterable<Object> $i$f$map = newItems = this.$delta.getNewItems();
                boolean $this$mapTo$iv$iv = false;
                if (!$i$f$map.isEmpty()) {
                    Iterable $this$mapTo$iv$iv2;
                    Iterable $this$map$iv;
                    it.setText2(GithubBundle.message("pull.request.adding.reviewers", new Object[0]));
                    $i$f$map = CollectionsKt.filterIsInstance((Iterable)newItems, GHUser.class);
                    l = this.$pullRequestId.getNumber();
                    string3 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                    string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                    githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                    progressIndicator = it;
                    githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        void it3;
                        GHUser bl3 = (GHUser)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl4 = false;
                        object = it3.getLogin();
                        collection.add((String)object);
                    }
                    collection = (List)destination$iv$iv2;
                    $this$map$iv = CollectionsKt.filterIsInstance((Iterable)newItems, GHTeam.class);
                    $i$f$map2 = false;
                    $this$mapTo$iv$iv2 = $this$map$iv;
                    destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        GHTeam it3 = (GHTeam)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl5 = false;
                        string = it3.getSlug();
                        object.add(string);
                    }
                    object = (List)destination$iv$iv2;
                    githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.PullRequests.Reviewers.add(githubServerPath, string2, string3, l, collection, (List<String>)object));
                }
            }
            {
                this.this$0 = gHPRDetailsServiceImpl;
                this.$delta = collectionDelta;
                this.$pullRequestId = gHPRIdentifier;
                super(1);
            }
        }), LOG, "Error occurred while adjusting the list of reviewers");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustAssignees(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @NotNull CollectionDelta<GHUser> delta) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkParameterIsNotNull(delta, (String)"delta");
        return GHServiceUtil.INSTANCE.logError(GithubAsyncUtilKt.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId, delta){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ CollectionDelta $delta;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable iterable = this.$delta.getNewCollection();
                String string = String.valueOf(this.$pullRequestId.getNumber());
                String string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                String string3 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                GithubServerPath githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                ProgressIndicator progressIndicator = it;
                GithubApiRequestExecutor githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                boolean $i$f$map = false;
                void var4_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    GHUser gHUser = (GHUser)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string4 = it2.getLogin();
                    collection.add(string4);
                }
                collection = (List)destination$iv$iv;
                githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.Issues.updateAssignees(githubServerPath, string3, string2, string, collection));
            }
            {
                this.this$0 = gHPRDetailsServiceImpl;
                this.$pullRequestId = gHPRIdentifier;
                this.$delta = collectionDelta;
                super(1);
            }
        }), LOG, "Error occurred while adjusting the list of assignees");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustLabels(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @NotNull CollectionDelta<GHLabel> delta) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkParameterIsNotNull(delta, (String)"delta");
        return GHServiceUtil.INSTANCE.logError(GithubAsyncUtilKt.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, Unit>(this, indicator, pullRequestId, delta){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ CollectionDelta $delta;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable iterable = this.$delta.getNewCollection();
                String string = String.valueOf(this.$pullRequestId.getNumber());
                String string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                String string3 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                GithubServerPath githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                ProgressIndicator progressIndicator = this.$indicator;
                GithubApiRequestExecutor githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                boolean $i$f$map = false;
                void var4_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    GHLabel gHLabel = (GHLabel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string4 = it2.getName();
                    collection.add(string4);
                }
                collection = (List)destination$iv$iv;
                githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.Issues.Labels.replace(githubServerPath, string3, string2, string, collection));
            }
            {
                this.this$0 = gHPRDetailsServiceImpl;
                this.$indicator = progressIndicator;
                this.$pullRequestId = gHPRIdentifier;
                this.$delta = collectionDelta;
                super(1);
            }
        }), LOG, "Error occurred while adjusting the list of labels");
    }

    public GHPRDetailsServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.progressManager = progressManager;
        this.requestExecutor = requestExecutor;
        this.repository = repository;
        this.serverPath = this.repository.getServerPath();
        this.repoPath = this.repository.getRepositoryPath();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRDetailsService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRDetailsServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHRepositoryCoordinates access$getRepository$p(GHPRDetailsServiceImpl $this) {
        return $this.repository;
    }

    public static final /* synthetic */ GithubServerPath access$getServerPath$p(GHPRDetailsServiceImpl $this) {
        return $this.serverPath;
    }

    public static final /* synthetic */ GHRepositoryPath access$getRepoPath$p(GHPRDetailsServiceImpl $this) {
        return $this.repoPath;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

