/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public final class IdeGlassPaneUtil {
    private IdeGlassPaneUtil() {
    }

    @NotNull
    public static IdeGlassPane find(@NotNull Component component) {
        if (component == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(0);
        }
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("Component must be instance of JComponent");
        }
        JRootPane root = ((JComponent)component).getRootPane();
        if (root == null) {
            throw new IllegalArgumentException("Component must be visible in order to find glass pane for it");
        }
        Component gp = root.getGlassPane();
        if (!(gp instanceof IdeGlassPane)) {
            throw new IllegalArgumentException("Glass pane should be " + IdeGlassPane.class.getName());
        }
        IdeGlassPane ideGlassPane = (IdeGlassPane)((Object)gp);
        if (ideGlassPane == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(1);
        }
        return ideGlassPane;
    }

    public static void installPainter(final @NotNull JComponent target, final @NotNull Painter painter, final @NotNull Disposable parent) {
        if (target == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(2);
        }
        if (painter == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(4);
        }
        UiNotifyConnector connector = new UiNotifyConnector(target, new Activatable(){
            private IdeGlassPane myPane;
            private Disposable myPanePainterListeners = Disposer.newDisposable();

            @Override
            public void showNotify() {
                IdeGlassPane pane = IdeGlassPaneUtil.find(target);
                if (this.myPane != null && this.myPane != pane) {
                    Disposer.dispose((Disposable)this.myPanePainterListeners);
                }
                this.myPane = pane;
                this.myPanePainterListeners = Disposer.newDisposable((String)"PanePainterListeners");
                Disposer.register((Disposable)parent, (Disposable)this.myPanePainterListeners);
                this.myPane.addPainter(target, painter, this.myPanePainterListeners);
            }

            @Override
            public void hideNotify() {
                Disposer.dispose((Disposable)this.myPanePainterListeners);
            }
        });
        Disposer.register((Disposable)parent, (Disposable)connector);
    }

    public static boolean canBePreprocessed(@NotNull MouseEvent e) {
        if (e == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(5);
        }
        Component c = UIUtil.getDeepestComponentAt((Component)e.getComponent(), (int)e.getX(), (int)e.getY());
        if (JBPopupFactory.getInstance().getParentBalloonFor(c) != null && e.getID() != 506) {
            return false;
        }
        if (c instanceof IdeGlassPane.TopComponent) {
            return ((IdeGlassPane.TopComponent)((Object)c)).canBePreprocessed(e);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/IdeGlassPaneUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/IdeGlassPaneUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installPainter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBePreprocessed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

