/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEventLogWhitelistPersistence {
    private static final Logger LOG = Logger.getInstance(BaseEventLogWhitelistPersistence.class);
    public static final String DEPRECATED_FUS_METADATA_DIR = "event-log-whitelist";
    public static final String FUS_METADATA_DIR = "event-log-metadata";

    @Nullable
    public abstract String getCachedMetadata();

    public static File getDefaultMetadataFile(@NotNull String recorderId, @NotNull String fileName, @Nullable String deprecatedFileName) throws IOException {
        File deprecated;
        File file;
        if (recorderId == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(1);
        }
        if (!(file = BaseEventLogWhitelistPersistence.getMetadataByDir(FUS_METADATA_DIR, recorderId, fileName)).exists() && StringUtil.isNotEmpty((String)deprecatedFileName) && (deprecated = BaseEventLogWhitelistPersistence.getMetadataByDir(DEPRECATED_FUS_METADATA_DIR, recorderId, deprecatedFileName)).exists()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Moving deprecated metadata file to new directory: " + fileName);
            }
            if (!FileUtil.createParentDirs((File)file)) {
                LOG.info("Cannot create directories for event log metadata");
                return file;
            }
            FileUtil.copy((File)deprecated, (File)file);
            if (!FileUtil.delete((File)deprecated)) {
                LOG.info("Failed deleting deprecated metadata file");
            }
        }
        return file;
    }

    @NotNull
    public static Path getDeprecatedMetadataDir() {
        return BaseEventLogWhitelistPersistence.getMetadataConfigRoot(DEPRECATED_FUS_METADATA_DIR);
    }

    @NotNull
    private static File getMetadataByDir(@NotNull String dir, @NotNull String recorderId, @NotNull String fileName) throws IOException {
        if (dir == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(2);
        }
        if (recorderId == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(4);
        }
        Path metadataDir = BaseEventLogWhitelistPersistence.getMetadataConfigRoot(dir);
        File file = metadataDir.resolve(StringUtil.toLowerCase((String)recorderId)).resolve(fileName).toFile().getCanonicalFile();
        if (file == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    private static Path getMetadataConfigRoot(@NotNull String dir) {
        if (dir == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(6);
        }
        Path path = PathManager.getConfigDir().resolve(dir);
        if (path == null) {
            BaseEventLogWhitelistPersistence.$$$reportNull$$$0(7);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/persistence/BaseEventLogWhitelistPersistence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/persistence/BaseEventLogWhitelistPersistence";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataByDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataConfigRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMetadataFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMetadataByDir";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMetadataConfigRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

