/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.PlainTextIdIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PlainTextTodoIndexer
extends VersionedTodoIndexer {
    private static final Logger LOG = Logger.getInstance(PlainTextTodoIndexer.class);

    @NotNull
    public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
        IndexPattern[] indexPatterns;
        if (inputData == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(0);
        }
        if ((indexPatterns = IndexPatternUtil.getIndexPatterns()).length <= 0) {
            Map<TodoIndexEntry, Integer> map2 = Collections.emptyMap();
            if (map2 == null) {
                PlainTextTodoIndexer.$$$reportNull$$$0(1);
            }
            return map2;
        }
        String chars = inputData.getContentAsText().toString();
        OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
        for (IndexPattern indexPattern : indexPatterns) {
            if (!PlainTextTodoIndexer.idIndexContainAllWords(indexPattern.getWordsToFindFirst(), indexPattern.isCaseSensitive(), inputData)) continue;
            Pattern pattern = indexPattern.getOptimizedIndexingPattern();
            try {
                if (pattern == null) continue;
                Matcher matcher = pattern.matcher(StringPattern.newBombedCharSequence((CharSequence)chars));
                while (matcher.find()) {
                    if (matcher.start() == matcher.end()) continue;
                    occurrenceConsumer.incTodoOccurrence(indexPattern);
                }
            }
            catch (StackOverflowError error) {
                LOG.error((Throwable)error);
            }
        }
        HashMap<TodoIndexEntry, Integer> map3 = new HashMap<TodoIndexEntry, Integer>();
        for (IndexPattern indexPattern : indexPatterns) {
            int count = occurrenceConsumer.getOccurrenceCount(indexPattern);
            if (count <= 0) continue;
            map3.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
        }
        HashMap<TodoIndexEntry, Integer> hashMap = map3;
        if (hashMap == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static boolean idIndexContainAllWords(@NotNull List<String> words, boolean caseSensitive, @NotNull FileContent content2) {
        if (words == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            PlainTextTodoIndexer.$$$reportNull$$$0(4);
        }
        Map<IdIndexEntry, Integer> idIndexData = PlainTextIdIndexer.getIdIndexData(content2);
        return words.stream().allMatch(word -> idIndexData.containsKey(new IdIndexEntry((String)word, caseSensitive)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/todo/PlainTextTodoIndexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/PlainTextTodoIndexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "idIndexContainAllWords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

