/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.cellvalidators.CellTooltipManager;
import com.intellij.openapi.ui.cellvalidators.StatefulValidatingCellEditor;
import com.intellij.openapi.ui.cellvalidators.ValidatingTableCellRendererWrapper;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginHostsConfigurable
implements Configurable.NoScroll,
Configurable {
    private final ListTableModel<UrlInfo> myModel = new ListTableModel<UrlInfo>(new ColumnInfo[0]){

        public void addRow() {
            this.addRow(new UrlInfo(""));
        }
    };
    private final AnimatedIcon.Default myAnimatedIcon = new AnimatedIcon.Default();
    private final Disposable myDisposable = Disposer.newDisposable();
    private final JBTable myTable = new JBTable((TableModel)this.myModel){

        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                2.$$$reportNull$$$0(0);
            }
            super.paintComponent(g);
            Rectangle bounds2 = g.getClipBounds();
            int startRow = Math.max(0, this.rowAtPoint(bounds2.getLocation()));
            int endRow = this.rowAtPoint(new Point(bounds2.x + bounds2.width, bounds2.y + bounds2.height));
            if (endRow == -1) {
                endRow = PluginHostsConfigurable.this.myModel.getRowCount() - 1;
            }
            int iconWidth = PluginHostsConfigurable.this.myAnimatedIcon.getIconWidth();
            int cellHeight = PluginHostsConfigurable.this.myAnimatedIcon.getIconHeight();
            int offset = JBUIScale.scale((int)5);
            int editingRow = this.getEditingRow();
            int selectedRow = this.getSelectedRow();
            Border border = UIUtil.getTableFocusCellHighlightBorder();
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                UrlInfo item = (UrlInfo)PluginHostsConfigurable.this.myModel.getItem(i2);
                if (!item.progress || i2 == editingRow) continue;
                Rectangle rect = this.getCellRect(i2, 0, true);
                int x = rect.x + rect.width - iconWidth - offset;
                int xx = 0;
                int yy = 0;
                int hh = 0;
                if (i2 == selectedRow) {
                    Insets insets = border.getBorderInsets(null);
                    xx = insets.right;
                    yy = insets.top;
                    hh = insets.top + insets.bottom + 1;
                }
                g.setColor(i2 == selectedRow ? this.getSelectionBackground() : this.getBackground());
                g.fillRect(x - offset, rect.y + yy, iconWidth + offset * 2 - xx, rect.height - hh);
                PluginHostsConfigurable.this.myAnimatedIcon.paintIcon((Component)((Object)this), g, x, rect.y + (rect.height - cellHeight) / 2);
            }
        }

        public void editingCanceled(ChangeEvent e) {
            int row = this.getEditingRow();
            super.editingCanceled(e);
            if (row >= 0 && row < PluginHostsConfigurable.this.myModel.getRowCount() && StringUtil.isEmpty((String)((UrlInfo)((PluginHostsConfigurable)PluginHostsConfigurable.this).myModel.getRowValue((int)row)).name)) {
                PluginHostsConfigurable.this.myModel.removeRow(row);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/plugins/PluginHostsConfigurable$2", "paintComponent"));
        }
    };

    @Nullable
    public JComponent createComponent() {
        this.myModel.setColumnInfos(new ColumnInfo[]{new ColumnInfo<UrlInfo, String>(""){

            @Nullable
            public String valueOf(UrlInfo info) {
                return info.name;
            }

            public boolean isCellEditable(UrlInfo info) {
                return true;
            }

            public void setValue(UrlInfo info, String value2) {
                int row = PluginHostsConfigurable.this.myTable.getSelectedRow();
                if (StringUtil.isEmpty((String)value2) && row >= 0 && row < PluginHostsConfigurable.this.myModel.getRowCount()) {
                    PluginHostsConfigurable.this.myModel.removeRow(row);
                } else {
                    info.name = PluginHostsConfigurable.correctRepositoryRule(value2);
                    PluginHostsConfigurable.this.validateRepositories(Collections.singletonList(info));
                }
            }
        }});
        this.myTable.getColumnModel().setColumnMargin(0);
        this.myTable.setShowColumns(false);
        this.myTable.setShowGrid(false);
        this.myTable.getEmptyText().setText(IdeBundle.message((String)"update.no.update.hosts", (Object[])new Object[0]));
        this.myTable.setSelectionMode(0);
        ExtendableTextField cellEditor = new ExtendableTextField();
        StatefulValidatingCellEditor editor = new StatefulValidatingCellEditor((JTextField)cellEditor, this.myDisposable).withStateUpdater(vi -> ValidationUtils.setExtension((ExtendableTextComponent)cellEditor, (ValidationInfo)vi));
        editor.setClickCountToStart(1);
        this.myTable.setDefaultEditor(Object.class, (TableCellEditor)editor);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)new ValidatingTableCellRendererWrapper((TableCellRenderer)new ColoredTableCellRenderer(){
            {
                this.setIpad((Insets)JBUI.emptyInsets());
            }

            protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                if (row >= 0 && row < PluginHostsConfigurable.this.myModel.getRowCount()) {
                    UrlInfo info = (UrlInfo)PluginHostsConfigurable.this.myModel.getRowValue(row);
                    this.setForeground(selected2 ? table.getSelectionForeground() : table.getForeground());
                    this.setBackground(selected2 ? table.getSelectionBackground() : table.getBackground());
                    this.append(info.name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
                return attributes;
            }
        }).bindToEditorSize(() -> cellEditor.getPreferredSize()).withCellValidator((value2, row, column) -> {
            if (row >= 0 && row < this.myModel.getRowCount()) {
                UrlInfo info = (UrlInfo)this.myModel.getRowValue(row);
                return info.errorTooltip == null || info.progress ? null : new ValidationInfo(info.errorTooltip);
            }
            return null;
        }));
        new CellTooltipManager(this.myDisposable).withCellComponentProvider(CellComponentProvider.forTable((JTable)this.myTable)).installOn((JComponent)this.myTable);
        return ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().createPanel();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void validateRepositories(@NotNull List<? extends UrlInfo> urls) {
        if (urls == null) {
            PluginHostsConfigurable.$$$reportNull$$$0(0);
        }
        final ArrayList<UrlInfo> infos = new ArrayList<UrlInfo>();
        final ArrayList<Object> results = new ArrayList<Object>();
        for (UrlInfo urlInfo : urls) {
            urlInfo.progress = true;
            infos.add(urlInfo);
            results.add(null);
        }
        this.myTable.repaint();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"progress.title.checking.plugins.repository", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                int size = infos.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    try {
                        if (RepositoryHelper.loadPlugins(((UrlInfo)infos.get((int)i2)).name, indicator).size() != 0) continue;
                        results.set(i2, "No plugins found. Please check log file for possible errors.");
                        continue;
                    }
                    catch (Exception ignore) {
                        results.set(i2, "Connection failed.");
                    }
                }
            }

            public void onSuccess() {
                this.finish(true);
            }

            public void onCancel() {
                this.finish(false);
            }

            private void finish(boolean success) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (success) {
                        int size = infos.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            UrlInfo info = (UrlInfo)infos.get(i2);
                            info.errorTooltip = (String)results.get(i2);
                            info.progress = false;
                        }
                    } else {
                        for (UrlInfo info : infos) {
                            info.progress = false;
                        }
                    }
                    PluginHostsConfigurable.this.myTable.repaint();
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginHostsConfigurable$5", "run"));
            }
        });
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.PluginHostsConfigurable.display.name", (Object[])new Object[0]);
    }

    public void reset() {
        ArrayList<UrlInfo> infos = new ArrayList<UrlInfo>();
        for (String host : UpdateSettings.getInstance().getStoredPluginHosts()) {
            infos.add(new UrlInfo(host));
        }
        this.myModel.setItems(infos);
        ApplicationManager.getApplication().invokeLater(() -> this.validateRepositories(infos), ModalityState.any());
    }

    public boolean isModified() {
        ArrayList<String> hosts = new ArrayList<String>();
        for (UrlInfo item : this.myModel.getItems()) {
            hosts.add(item.name);
        }
        return !UpdateSettings.getInstance().getStoredPluginHosts().equals(hosts);
    }

    public void apply() throws ConfigurationException {
        this.myTable.editingStopped(null);
        List<String> list2 = UpdateSettings.getInstance().getStoredPluginHosts();
        list2.clear();
        for (UrlInfo item : this.myModel.getItems()) {
            list2.add(item.name);
        }
    }

    @NotNull
    private static String correctRepositoryRule(@NotNull String input) {
        if (input == null) {
            PluginHostsConfigurable.$$$reportNull$$$0(1);
        }
        if (VirtualFileManager.extractProtocol((String)input) == null) {
            String string = VirtualFileManager.constructUrl((String)"http", (String)input);
            if (string == null) {
                PluginHostsConfigurable.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = input;
        if (string == null) {
            PluginHostsConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginHostsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginHostsConfigurable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "correctRepositoryRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateRepositories";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "correctRepositoryRule";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UrlInfo {
        String name;
        boolean progress;
        String errorTooltip;

        UrlInfo(@NotNull String name) {
            if (name == null) {
                UrlInfo.$$$reportNull$$$0(0);
            }
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/plugins/PluginHostsConfigurable$UrlInfo", "<init>"));
        }
    }
}

