/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.SingleTargetElementInfo;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationPlaceAwareProvider;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTypeDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware,
CtrlMouseAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        GotoTypeDeclarationAction gotoTypeDeclarationAction = this;
        if (gotoTypeDeclarationAction == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(0);
        }
        return gotoTypeDeclarationAction;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(1);
        }
        if (TypeDeclarationProvider.EP_NAME.getExtensionList().size() == 0) {
            event.getPresentation().setVisible(false);
            return;
        }
        for (TypeDeclarationProvider provider : TypeDeclarationProvider.EP_NAME.getExtensionList()) {
            String text = provider.getActionText(event.getDataContext());
            if (text == null) continue;
            Presentation presentation2 = event.getPresentation();
            presentation2.setText(text);
            break;
        }
        super.update(event);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(4);
        }
        DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
            try {
                int offset = editor.getCaretModel().getOffset();
                PsiElement[] symbolTypes = (PsiElement[])ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> GotoTypeDeclarationAction.findSymbolTypes(editor, offset));
                if (symbolTypes == null || symbolTypes.length == 0) {
                    return;
                }
                if (symbolTypes.length == 1) {
                    GotoTypeDeclarationAction.navigate(project, symbolTypes[0]);
                } else {
                    NavigationUtil.getPsiElementPopup(symbolTypes, CodeInsightBundle.message((String)"choose.type.popup.title", (Object[])new Object[0])).showInBestPositionFor(editor);
                }
            }
            catch (IndexNotReadyException e) {
                DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"message.navigation.is.not.available.here.during.index.update", (Object[])new Object[0]));
            }
        });
    }

    private static void navigate(@NotNull Project project, @NotNull PsiElement symbolType) {
        if (project == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(5);
        }
        if (symbolType == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(6);
        }
        PsiElement element2 = symbolType.getNavigationElement();
        assert (element2 != null) : "SymbolType :" + symbolType + "; file: " + symbolType.getContainingFile();
        VirtualFile file2 = element2.getContainingFile().getVirtualFile();
        if (file2 != null) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, element2.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findSymbolType(@NotNull Editor editor, int offset) {
        PsiElement[] psiElements;
        if (editor == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(7);
        }
        if ((psiElements = GotoTypeDeclarationAction.findSymbolTypes(editor, offset)) != null && psiElements.length > 0) {
            return psiElements[0];
        }
        return null;
    }

    @VisibleForTesting
    public static PsiElement @Nullable [] findSymbolTypes(@NotNull Editor editor, int offset) {
        PsiElement targetElement;
        if (editor == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(8);
        }
        if ((targetElement = TargetElementUtil.getInstance().findTargetElement(editor, 11, offset)) != null) {
            PsiElement[] symbolType = GotoTypeDeclarationAction.getSymbolTypeDeclarations(targetElement, editor, offset);
            return symbolType == null ? PsiElement.EMPTY_ARRAY : symbolType;
        }
        PsiReference psiReference = TargetElementUtil.findReference(editor, offset);
        if (psiReference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)psiReference).multiResolve(false);
            THashSet types = new THashSet();
            for (ResolveResult r : results) {
                PsiElement[] declarations;
                PsiElement element2 = r.getElement();
                if (element2 == null || (declarations = GotoTypeDeclarationAction.getSymbolTypeDeclarations(element2, editor, offset)) == null) continue;
                for (PsiElement declaration : declarations) {
                    assert (declaration != null);
                    types.add(declaration);
                }
            }
            if (!types.isEmpty()) {
                return PsiUtilCore.toPsiElementArray((Collection)types);
            }
        }
        return null;
    }

    private static PsiElement @Nullable [] getSymbolTypeDeclarations(@NotNull PsiElement targetElement, Editor editor, int offset) {
        if (targetElement == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(9);
        }
        for (TypeDeclarationProvider provider : TypeDeclarationProvider.EP_NAME.getExtensionList()) {
            PsiElement[] result2 = provider instanceof TypeDeclarationPlaceAwareProvider ? ((TypeDeclarationPlaceAwareProvider)provider).getSymbolTypeDeclarations(targetElement, editor, offset) : provider.getSymbolTypeDeclarations(targetElement);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    @Nullable
    public CtrlMouseInfo getCtrlMouseInfo(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        PsiElement targetElement;
        if (editor == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            GotoTypeDeclarationAction.$$$reportNull$$$0(11);
        }
        if ((targetElement = GotoTypeDeclarationAction.findSymbolType(editor, offset)) == null || !targetElement.isPhysical()) {
            return null;
        }
        PsiElement elementAtPointer = file2.findElementAt(offset);
        if (elementAtPointer != null) {
            return new SingleTargetElementInfo(elementAtPointer, targetElement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolTypeDeclarations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCtrlMouseInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

