/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;

public class Parsing {
    private static final Logger LOG = Logger.getInstance(Parsing.class);

    public static void parseProperty(PsiBuilder builder) {
        if (builder.getTokenType() == PropertiesTokenTypes.KEY_CHARACTERS) {
            PsiBuilder.Marker prop = builder.mark();
            Parsing.parseKey(builder);
            if (builder.getTokenType() == PropertiesTokenTypes.KEY_VALUE_SEPARATOR) {
                Parsing.parseKeyValueSeparator(builder);
            }
            if (builder.getTokenType() == PropertiesTokenTypes.VALUE_CHARACTERS) {
                Parsing.parseValue(builder);
            }
            prop.done((IElementType)PropertiesElementTypes.PROPERTY);
        } else {
            builder.advanceLexer();
            builder.error(PropertiesBundle.message("property.key.expected.parsing.error.message", new Object[0]));
        }
    }

    private static void parseKeyValueSeparator(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == PropertiesTokenTypes.KEY_VALUE_SEPARATOR);
        builder.advanceLexer();
    }

    private static void parseValue(PsiBuilder builder) {
        if (builder.getTokenType() == PropertiesTokenTypes.VALUE_CHARACTERS) {
            builder.advanceLexer();
        }
    }

    private static void parseKey(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == PropertiesTokenTypes.KEY_CHARACTERS);
        builder.advanceLexer();
    }
}

