/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.gpg;

import com.intellij.credentialStore.gpg.GpgToolWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0006\u0010\u0015\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/credentialStore/gpg/GpgToolWrapperImpl;", "Lcom/intellij/credentialStore/gpg/GpgToolWrapper;", "gpgPath", "", "timeoutInMilliseconds", "", "(Ljava/lang/String;I)V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "isAddStringOutputRelatedOptions", "", "createCommandLineForEncodeOrDecode", "decrypt", "", "data", "doEncryptOrDecrypt", "commandLine", "doExecute", "encrypt", "recipient", "listSecretKeys", "version", "intellij.platform.credentialStore"})
public final class GpgToolWrapperImpl
implements GpgToolWrapper {
    private final String gpgPath;
    private final int timeoutInMilliseconds;

    @NotNull
    public final String version() {
        GeneralCommandLine commandLine = GpgToolWrapperImpl.createCommandLine$default(this, false, 1, null);
        commandLine.addParameter("--version");
        return this.doExecute(commandLine);
    }

    @Override
    @NotNull
    public String listSecretKeys() {
        GeneralCommandLine commandLine = GpgToolWrapperImpl.createCommandLine$default(this, false, 1, null);
        commandLine.addParameter("--list-secret-keys");
        return this.doExecute(commandLine);
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] data, @NotNull String recipient) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        GeneralCommandLine commandLine = this.createCommandLineForEncodeOrDecode();
        commandLine.addParameter("--encrypt");
        commandLine.addParameter("--recipient");
        commandLine.addParameter(recipient);
        return this.doEncryptOrDecrypt(commandLine, data);
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        GeneralCommandLine commandLine = this.createCommandLineForEncodeOrDecode();
        commandLine.addParameter("--decrypt");
        return this.doEncryptOrDecrypt(commandLine, data);
    }

    private final GeneralCommandLine createCommandLineForEncodeOrDecode() {
        GeneralCommandLine result = this.createCommandLine(false);
        result.addParameter("--trust-model");
        result.addParameter("always");
        return result;
    }

    private final byte[] doEncryptOrDecrypt(GeneralCommandLine commandLine, byte[] data) {
        byte[] internalBuffer;
        Object object;
        Process process = commandLine.createProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"commandLine.createProcess()");
        Process process2 = process;
        BufferExposingByteArrayOutputStream output = new BufferExposingByteArrayOutputStream();
        BufferExposingByteArrayOutputStream errorOutput = new BufferExposingByteArrayOutputStream();
        try {
            CompletableFuture[] completableFutureArray;
            int n = 0;
            CompletableFuture[] completableFutureArray2 = completableFutureArray = new CompletableFuture[3];
            boolean $i$f$runAsync = false;
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(process2, data){
                final /* synthetic */ Process $process$inlined;
                final /* synthetic */ byte[] $data$inlined;
                {
                    this.$process$inlined = process;
                    this.$data$inlined = byArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean bl = false;
                    Closeable closeable = this.$process$inlined.getOutputStream();
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        OutputStream it = (OutputStream)closeable;
                        boolean bl3 = false;
                        it.write(this.$data$inlined);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }, AppExecutorUtil.getAppExecutorService());
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.runAsy\u2026.getAppExecutorService())");
            object = completableFuture;
            completableFutureArray[n] = object;
            n = 1;
            completableFutureArray = completableFutureArray2;
            $i$f$runAsync = false;
            CompletableFuture<Void> completableFuture2 = CompletableFuture.runAsync(new Runnable(process2, output){
                final /* synthetic */ Process $process$inlined;
                final /* synthetic */ BufferExposingByteArrayOutputStream $output$inlined;
                {
                    this.$process$inlined = process;
                    this.$output$inlined = bufferExposingByteArrayOutputStream;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean bl = false;
                    Closeable closeable = this.$process$inlined.getInputStream();
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl3 = false;
                        FileUtilRt.copy((InputStream)it, (OutputStream)((OutputStream)this.$output$inlined));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }, AppExecutorUtil.getAppExecutorService());
            Intrinsics.checkExpressionValueIsNotNull(completableFuture2, (String)"CompletableFuture.runAsy\u2026.getAppExecutorService())");
            object = completableFuture2;
            completableFutureArray[n] = object;
            n = 2;
            completableFutureArray = completableFutureArray2;
            $i$f$runAsync = false;
            CompletableFuture<Void> completableFuture3 = CompletableFuture.runAsync(new Runnable(process2, errorOutput){
                final /* synthetic */ Process $process$inlined;
                final /* synthetic */ BufferExposingByteArrayOutputStream $errorOutput$inlined;
                {
                    this.$process$inlined = process;
                    this.$errorOutput$inlined = bufferExposingByteArrayOutputStream;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean bl = false;
                    Closeable closeable = this.$process$inlined.getErrorStream();
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl3 = false;
                        FileUtilRt.copy((InputStream)it, (OutputStream)((OutputStream)this.$errorOutput$inlined));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }, AppExecutorUtil.getAppExecutorService());
            Intrinsics.checkExpressionValueIsNotNull(completableFuture3, (String)"CompletableFuture.runAsy\u2026.getAppExecutorService())");
            object = completableFuture3;
            completableFutureArray[n] = object;
            CompletableFuture.allOf(completableFutureArray2).get(3L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Cannot execute ").append(commandLine.getCommandLineString()).append("\nerror output: ");
            byte[] byArray = errorOutput.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"errorOutput.toByteArray()");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            boolean bl2 = false;
            String string = new String(byArray2, charset);
            Throwable throwable = e.getCause();
            String string2 = stringBuilder2.append(string).toString();
            throw (Throwable)new RuntimeException(string2, throwable);
        }
        if (!process2.waitFor(5L, TimeUnit.SECONDS)) {
            throw (Throwable)new RuntimeException("Cannot execute " + this.gpgPath + ": timeout");
        }
        int exitCode = process2.exitValue();
        if (exitCode != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Cannot execute ").append(commandLine.getCommandLineString()).append("\nexit code ").append(exitCode).append(", error output: ");
            byte[] byArray = errorOutput.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"errorOutput.toByteArray()");
            byte[] byArray3 = byArray;
            Charset charset = Charsets.UTF_8;
            StringBuilder stringBuilder3 = stringBuilder;
            boolean bl = false;
            boolean bl3 = false;
            object = new String(byArray3, charset);
            String string = stringBuilder3.append((String)object).toString();
            throw (Throwable)new RuntimeException(string);
        }
        byte[] result = output.toByteArray();
        if (result != (internalBuffer = output.getInternalBuffer())) {
            Intrinsics.checkExpressionValueIsNotNull((Object)internalBuffer, (String)"internalBuffer");
            ArraysKt.fill$default((byte[])internalBuffer, (byte)0, (int)0, (int)0, (int)6, null);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"result");
        return result;
    }

    private final String doExecute(GeneralCommandLine commandLine) {
        ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)this.timeoutInMilliseconds);
        int exitCode = processOutput.getExitCode();
        if (exitCode != 0) {
            throw (Throwable)new RuntimeException("Cannot execute " + this.gpgPath + ": exit code " + exitCode + ", error output: " + processOutput.getStderr());
        }
        String string = processOutput.getStdout();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processOutput.stdout");
        return string;
    }

    private final GeneralCommandLine createCommandLine(boolean isAddStringOutputRelatedOptions) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.gpgPath);
        if (isAddStringOutputRelatedOptions) {
            commandLine.addParameter("--with-colons");
            commandLine.addParameter("--fixed-list-mode");
        }
        commandLine.addParameter("--no-tty");
        commandLine.addParameter("--yes");
        commandLine.addParameter("--display-charset");
        commandLine.addParameter("utf-8");
        return commandLine;
    }

    static /* synthetic */ GeneralCommandLine createCommandLine$default(GpgToolWrapperImpl gpgToolWrapperImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return gpgToolWrapperImpl.createCommandLine(bl);
    }

    public GpgToolWrapperImpl(@NotNull String gpgPath, int timeoutInMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)gpgPath, (String)"gpgPath");
        this.gpgPath = gpgPath;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public /* synthetic */ GpgToolWrapperImpl(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "gpg";
        }
        if ((n2 & 2) != 0) {
            n = 5000;
        }
        this(string, n);
    }

    public GpgToolWrapperImpl() {
        this(null, 0, 3, null);
    }
}

