/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * length(0.0lf) => 0.0lf
 * length(-1.3333333333333333lf) => 1.3333333333333333lf
 * length(0.85lf) => 0.85lf
 */
#version 400

void main()
{
  double[distance(length(0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance(length(-1.3333333333333333lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array1;
  double[distance(length(0.85lf), 0.85lf) <= 8.5e-06lf ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
