/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul >> 0u) => 0ul
 * (0ul >> 1u) => 0ul
 * (0ul >> 2u) => 0ul
 * (0ul >> 5u) => 0ul
 * (0ul >> 25u) => 0ul
 * (0ul >> 31u) => 0ul
 * (3ul >> 0u) => 3ul
 * (3ul >> 1u) => 1ul
 * (3ul >> 2u) => 0ul
 * (3ul >> 5u) => 0ul
 * (3ul >> 25u) => 0ul
 * (3ul >> 31u) => 0ul
 * (1192ul >> 0u) => 1192ul
 * (1192ul >> 1u) => 596ul
 * (1192ul >> 2u) => 298ul
 * (1192ul >> 5u) => 37ul
 * (1192ul >> 25u) => 0ul
 * (1192ul >> 31u) => 0ul
 * (1048576ul >> 0u) => 1048576ul
 * (1048576ul >> 1u) => 524288ul
 * (1048576ul >> 2u) => 262144ul
 * (1048576ul >> 5u) => 32768ul
 * (1048576ul >> 25u) => 0ul
 * (1048576ul >> 31u) => 0ul
 * (4251475ul >> 0u) => 4251475ul
 * (4251475ul >> 1u) => 2125737ul
 * (4251475ul >> 2u) => 1062868ul
 * (4251475ul >> 5u) => 132858ul
 * (4251475ul >> 25u) => 0ul
 * (4251475ul >> 31u) => 0ul
 * (29852643761ul >> 0u) => 29852643761ul
 * (29852643761ul >> 1u) => 14926321880ul
 * (29852643761ul >> 2u) => 7463160940ul
 * (29852643761ul >> 5u) => 932895117ul
 * (29852643761ul >> 25u) => 889ul
 * (29852643761ul >> 31u) => 13ul
 * (4398046511104ul >> 0u) => 4398046511104ul
 * (4398046511104ul >> 1u) => 2199023255552ul
 * (4398046511104ul >> 2u) => 1099511627776ul
 * (4398046511104ul >> 5u) => 137438953472ul
 * (4398046511104ul >> 25u) => 131072ul
 * (4398046511104ul >> 31u) => 2048ul
 * (3948976685146ul >> 0u) => 3948976685146ul
 * (3948976685146ul >> 1u) => 1974488342573ul
 * (3948976685146ul >> 2u) => 987244171286ul
 * (3948976685146ul >> 5u) => 123405521410ul
 * (3948976685146ul >> 25u) => 117688ul
 * (3948976685146ul >> 31u) => 1838ul
 * (135763469567146206ul >> 0u) => 135763469567146206ul
 * (135763469567146206ul >> 1u) => 67881734783573103ul
 * (135763469567146206ul >> 2u) => 33940867391786551ul
 * (135763469567146206ul >> 5u) => 4242608423973318ul
 * (135763469567146206ul >> 25u) => 4046066688ul
 * (135763469567146206ul >> 31u) => 63219792ul
 * (11654173250180970009ul >> 0u) => 11654173250180970009ul
 * (11654173250180970009ul >> 1u) => 5827086625090485004ul
 * (11654173250180970009ul >> 2u) => 2913543312545242502ul
 * (11654173250180970009ul >> 5u) => 364192914068155312ul
 * (11654173250180970009ul >> 25u) => 347321428363ul
 * (11654173250180970009ul >> 31u) => 5426897318ul
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[(0ul >> 0u) == 0ul ? 1 : -1] array0;
  float[(0ul >> 1u) == 0ul ? 1 : -1] array1;
  float[(0ul >> 2u) == 0ul ? 1 : -1] array2;
  float[(0ul >> 5u) == 0ul ? 1 : -1] array3;
  float[(0ul >> 25u) == 0ul ? 1 : -1] array4;
  float[(0ul >> 31u) == 0ul ? 1 : -1] array5;
  float[(3ul >> 0u) == 3ul ? 1 : -1] array6;
  float[(3ul >> 1u) == 1ul ? 1 : -1] array7;
  float[(3ul >> 2u) == 0ul ? 1 : -1] array8;
  float[(3ul >> 5u) == 0ul ? 1 : -1] array9;
  float[(3ul >> 25u) == 0ul ? 1 : -1] array10;
  float[(3ul >> 31u) == 0ul ? 1 : -1] array11;
  float[(1192ul >> 0u) == 1192ul ? 1 : -1] array12;
  float[(1192ul >> 1u) == 596ul ? 1 : -1] array13;
  float[(1192ul >> 2u) == 298ul ? 1 : -1] array14;
  float[(1192ul >> 5u) == 37ul ? 1 : -1] array15;
  float[(1192ul >> 25u) == 0ul ? 1 : -1] array16;
  float[(1192ul >> 31u) == 0ul ? 1 : -1] array17;
  float[(1048576ul >> 0u) == 1048576ul ? 1 : -1] array18;
  float[(1048576ul >> 1u) == 524288ul ? 1 : -1] array19;
  float[(1048576ul >> 2u) == 262144ul ? 1 : -1] array20;
  float[(1048576ul >> 5u) == 32768ul ? 1 : -1] array21;
  float[(1048576ul >> 25u) == 0ul ? 1 : -1] array22;
  float[(1048576ul >> 31u) == 0ul ? 1 : -1] array23;
  float[(4251475ul >> 0u) == 4251475ul ? 1 : -1] array24;
  float[(4251475ul >> 1u) == 2125737ul ? 1 : -1] array25;
  float[(4251475ul >> 2u) == 1062868ul ? 1 : -1] array26;
  float[(4251475ul >> 5u) == 132858ul ? 1 : -1] array27;
  float[(4251475ul >> 25u) == 0ul ? 1 : -1] array28;
  float[(4251475ul >> 31u) == 0ul ? 1 : -1] array29;
  float[(29852643761ul >> 0u) == 29852643761ul ? 1 : -1] array30;
  float[(29852643761ul >> 1u) == 14926321880ul ? 1 : -1] array31;
  float[(29852643761ul >> 2u) == 7463160940ul ? 1 : -1] array32;
  float[(29852643761ul >> 5u) == 932895117ul ? 1 : -1] array33;
  float[(29852643761ul >> 25u) == 889ul ? 1 : -1] array34;
  float[(29852643761ul >> 31u) == 13ul ? 1 : -1] array35;
  float[(4398046511104ul >> 0u) == 4398046511104ul ? 1 : -1] array36;
  float[(4398046511104ul >> 1u) == 2199023255552ul ? 1 : -1] array37;
  float[(4398046511104ul >> 2u) == 1099511627776ul ? 1 : -1] array38;
  float[(4398046511104ul >> 5u) == 137438953472ul ? 1 : -1] array39;
  float[(4398046511104ul >> 25u) == 131072ul ? 1 : -1] array40;
  float[(4398046511104ul >> 31u) == 2048ul ? 1 : -1] array41;
  float[(3948976685146ul >> 0u) == 3948976685146ul ? 1 : -1] array42;
  float[(3948976685146ul >> 1u) == 1974488342573ul ? 1 : -1] array43;
  float[(3948976685146ul >> 2u) == 987244171286ul ? 1 : -1] array44;
  float[(3948976685146ul >> 5u) == 123405521410ul ? 1 : -1] array45;
  float[(3948976685146ul >> 25u) == 117688ul ? 1 : -1] array46;
  float[(3948976685146ul >> 31u) == 1838ul ? 1 : -1] array47;
  float[(135763469567146206ul >> 0u) == 135763469567146206ul ? 1 : -1] array48;
  float[(135763469567146206ul >> 1u) == 67881734783573103ul ? 1 : -1] array49;
  float[(135763469567146206ul >> 2u) == 33940867391786551ul ? 1 : -1] array50;
  float[(135763469567146206ul >> 5u) == 4242608423973318ul ? 1 : -1] array51;
  float[(135763469567146206ul >> 25u) == 4046066688ul ? 1 : -1] array52;
  float[(135763469567146206ul >> 31u) == 63219792ul ? 1 : -1] array53;
  float[(11654173250180970009ul >> 0u) == 11654173250180970009ul ? 1 : -1] array54;
  float[(11654173250180970009ul >> 1u) == 5827086625090485004ul ? 1 : -1] array55;
  float[(11654173250180970009ul >> 2u) == 2913543312545242502ul ? 1 : -1] array56;
  float[(11654173250180970009ul >> 5u) == 364192914068155312ul ? 1 : -1] array57;
  float[(11654173250180970009ul >> 25u) == 347321428363ul ? 1 : -1] array58;
  float[(11654173250180970009ul >> 31u) == 5426897318ul ? 1 : -1] array59;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length() + array54.length() + array55.length() + array56.length() + array57.length() + array58.length() + array59.length());
}
