odoo.define('website_sale.validate', function(require) {
'use strict';

var sAnimations = require('website.content.snippets.animation');

sAnimations.registry.websiteSaleValidate = sAnimations.Class.extend({
    selector: 'div.oe_website_sale_tx_status[data-order-id]',

    /**
     * @override
     */
    start: function () {
        var def = this._super.apply(this, arguments);
        if (this.editableMode) {
            return def;
        }

        this._poll_nbr = 0;
        this._paymentTransationPollStatus();

        return def;
    },

    //--------------------------------------------------------------------------
    // Private
    //--------------------------------------------------------------------------

    /**
     * @private
     */
    _paymentTransationPollStatus: function () {
        var self = this;
        this._rpc({
            route: '/shop/payment/get_status/' + parseInt(this.$el.data('order-id')),
        }).then(function (result) {
            self._poll_nbr += 1;
            if (result.recall) {
                if (self._poll_nbr < 20) {
                    setTimeout(function () {
                        self._paymentTransationPollStatus();
                    }, Math.ceil(self._poll_nbr / 3) * 1000);
                } else {
                    var $message = $(result.message);
                    $message.find('span:first').prepend(
                        $("<i title='We are waiting the confirmation of the bank or payment provider' class='fa fa-warning' style='margin-right:10px;'>")
                    );
                    result.message = $message.html();
                }
            }
            self.$el.html(result.message);
        });
    },
});
});
