function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import { EuiButtonEmpty, EuiContextMenuItem, EuiContextMenuPanel, EuiFlexGroup, EuiFlexItem, EuiPopover, EuiPopoverTitle } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { AggGroupNames } from '../../../data/public';

function DefaultEditorAggAdd(_ref) {
  var _ref$group = _ref.group,
      group = _ref$group === void 0 ? [] : _ref$group,
      groupName = _ref.groupName,
      schemas = _ref.schemas,
      addSchema = _ref.addSchema,
      stats = _ref.stats;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isPopoverOpen = _useState2[0],
      setIsPopoverOpen = _useState2[1];

  var onSelectSchema = function onSelectSchema(schema) {
    setIsPopoverOpen(false);
    addSchema(schema);
  };

  var addButton = /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    size: "xs",
    iconType: "plusInCircleFilled",
    "data-test-subj": "visEditorAdd_".concat(groupName),
    onClick: function onClick() {
      return setIsPopoverOpen(!isPopoverOpen);
    }
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.aggAdd.addButtonLabel",
    defaultMessage: "Add"
  }));
  var groupNameLabel = groupName === AggGroupNames.Buckets ? i18n.translate('visDefaultEditor.aggAdd.bucketLabel', {
    defaultMessage: 'bucket'
  }) : i18n.translate('visDefaultEditor.aggAdd.metricLabel', {
    defaultMessage: 'metric'
  });

  var isSchemaDisabled = function isSchemaDisabled(schema) {
    var count = group.filter(function (agg) {
      return agg.schema === schema.name;
    }).length;
    return count >= schema.max;
  };

  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "center",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiPopover, {
    id: "addGroupButtonPopover_".concat(groupName),
    button: addButton,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    closePopover: function closePopover() {
      return setIsPopoverOpen(false);
    }
  }, /*#__PURE__*/React.createElement(EuiPopoverTitle, null, (groupName !== AggGroupNames.Buckets || !stats.count) && /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.aggAdd.addGroupButtonLabel",
    defaultMessage: "Add {groupNameLabel}",
    values: {
      groupNameLabel: groupNameLabel
    }
  }), groupName === AggGroupNames.Buckets && stats.count > 0 && /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.aggAdd.addSubGroupButtonLabel",
    defaultMessage: "Add sub-{groupNameLabel}",
    values: {
      groupNameLabel: groupNameLabel
    }
  })), /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
    items: schemas.map(function (schema) {
      return /*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: "".concat(schema.name, "_").concat(schema.title),
        "data-test-subj": "visEditorAdd_".concat(groupName, "_").concat(schema.title),
        disabled: isPopoverOpen && isSchemaDisabled(schema),
        onClick: function onClick() {
          return onSelectSchema(schema);
        }
      }, schema.title);
    })
  }))));
}

export { DefaultEditorAggAdd };