function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as React from 'react';
import _ from 'lodash';
import { i18n } from '@kbn/i18n';
import { uiToReactComponent } from '../../../kibana_react/public';
export var defaultTitle = i18n.translate('uiActions.actionPanel.title', {
  defaultMessage: 'Options'
});
/**
 * Transforms an array of Actions to the shape EuiContextMenuPanel expects.
 */

export function buildContextMenuForActions(_x) {
  return _buildContextMenuForActions.apply(this, arguments);
}
/**
 * Transform an array of Actions into the shape needed to build an EUIContextMenu
 */

function _buildContextMenuForActions() {
  _buildContextMenuForActions = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
    var actions, actionContext, _ref$title, title, closeMenu, menuItems;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            actions = _ref.actions, actionContext = _ref.actionContext, _ref$title = _ref.title, title = _ref$title === void 0 ? defaultTitle : _ref$title, closeMenu = _ref.closeMenu;
            _context.next = 3;
            return buildEuiContextMenuPanelItems({
              actions: actions,
              actionContext: actionContext,
              closeMenu: closeMenu
            });

          case 3:
            menuItems = _context.sent;
            return _context.abrupt("return", {
              id: 'mainMenu',
              title: title,
              items: menuItems
            });

          case 5:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _buildContextMenuForActions.apply(this, arguments);
}

function buildEuiContextMenuPanelItems(_x2) {
  return _buildEuiContextMenuPanelItems.apply(this, arguments);
}

function _buildEuiContextMenuPanelItems() {
  _buildEuiContextMenuPanelItems = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(_ref2) {
    var actions, actionContext, closeMenu, items, promises;
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            actions = _ref2.actions, actionContext = _ref2.actionContext, closeMenu = _ref2.closeMenu;
            items = new Array(actions.length);
            promises = actions.map( /*#__PURE__*/function () {
              var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(action, index) {
                var isCompatible;
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        _context2.next = 2;
                        return action.isCompatible(actionContext);

                      case 2:
                        isCompatible = _context2.sent;

                        if (isCompatible) {
                          _context2.next = 5;
                          break;
                        }

                        return _context2.abrupt("return");

                      case 5:
                        _context2.next = 7;
                        return convertPanelActionToContextMenuItem({
                          action: action,
                          actionContext: actionContext,
                          closeMenu: closeMenu
                        });

                      case 7:
                        items[index] = _context2.sent;

                      case 8:
                      case "end":
                        return _context2.stop();
                    }
                  }
                }, _callee2);
              }));

              return function (_x4, _x5) {
                return _ref4.apply(this, arguments);
              };
            }());
            _context3.next = 5;
            return Promise.all(promises);

          case 5:
            return _context3.abrupt("return", items.filter(Boolean));

          case 6:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _buildEuiContextMenuPanelItems.apply(this, arguments);
}

function convertPanelActionToContextMenuItem(_x3) {
  return _convertPanelActionToContextMenuItem.apply(this, arguments);
}

function _convertPanelActionToContextMenuItem() {
  _convertPanelActionToContextMenuItem = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(_ref3) {
    var action, actionContext, closeMenu, menuPanelItem, href;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            action = _ref3.action, actionContext = _ref3.actionContext, closeMenu = _ref3.closeMenu;
            menuPanelItem = {
              name: action.MenuItem ? /*#__PURE__*/React.createElement(uiToReactComponent(action.MenuItem), {
                context: actionContext
              }) : action.getDisplayName(actionContext),
              icon: action.getIconType(actionContext),
              panel: _.get(action, 'childContextMenuPanel.id'),
              'data-test-subj': "embeddablePanelAction-".concat(action.id)
            };

            menuPanelItem.onClick = function (event) {
              if (event.currentTarget instanceof HTMLAnchorElement) {
                // from react-router's <Link/>
                if (!event.defaultPrevented && // onClick prevented default
                event.button === 0 && ( // ignore everything but left clicks
                !event.currentTarget.target || event.currentTarget.target === '_self') && // let browser handle "target=_blank" etc.
                !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey) // ignore clicks with modifier keys
                ) {
                    event.preventDefault();
                    action.execute(actionContext);
                  } else {// let browser handle navigation
                }
              } else {
                // not a link
                action.execute(actionContext);
              }

              closeMenu();
            };

            if (!action.getHref) {
              _context4.next = 8;
              break;
            }

            _context4.next = 6;
            return action.getHref(actionContext);

          case 6:
            href = _context4.sent;

            if (href) {
              menuPanelItem.href = href;
            }

          case 8:
            return _context4.abrupt("return", menuPanelItem);

          case 9:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _convertPanelActionToContextMenuItem.apply(this, arguments);
}