function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component, Fragment } from 'react';
import { EuiCallOut, EuiPanel, EuiForm, EuiFlexGroup, EuiFlexItem, EuiLink, EuiSpacer, EuiText } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { PRIVACY_STATEMENT_URL } from '../../../telemetry/common/constants';
import { OptInExampleFlyout } from './opt_in_example_flyout';
import { Field } from '../../../advanced_settings/public';
var SEARCH_TERMS = ['telemetry', 'usage', 'data', 'usage data'];
export var TelemetryManagementSection = /*#__PURE__*/function (_Component) {
  _inherits(TelemetryManagementSection, _Component);

  var _super = _createSuper(TelemetryManagementSection);

  function TelemetryManagementSection() {
    var _this;

    _classCallCheck(this, TelemetryManagementSection);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      processing: false,
      showExample: false,
      queryMatches: null,
      enabled: _this.props.telemetryService.getIsOptedIn() || false
    });

    _defineProperty(_assertThisInitialized(_this), "maybeGetAppliesSettingMessage", function () {
      if (!_this.props.showAppliesSettingMessage) {
        return null;
      }

      return /*#__PURE__*/React.createElement(EuiCallOut, {
        color: "primary",
        iconType: "spacesApp",
        title: /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "telemetry.callout.appliesSettingTitle",
          defaultMessage: "Changes to this setting apply to {allOfKibanaText} and are saved automatically.",
          values: {
            allOfKibanaText: /*#__PURE__*/React.createElement("strong", null, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "telemetry.callout.appliesSettingTitle.allOfKibanaText",
              defaultMessage: "all of Kibana"
            }))
          }
        }))
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderDescription", function () {
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "telemetry.telemetryConfigAndLinkDescription",
        defaultMessage: "Enabling data usage collection helps us manage and improve our products and services. See our {privacyStatementLink} for more details.",
        values: {
          privacyStatementLink: /*#__PURE__*/React.createElement(EuiLink, {
            href: PRIVACY_STATEMENT_URL,
            target: "_blank"
          }, /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "telemetry.readOurUsageDataPrivacyStatementLinkText",
            defaultMessage: "Privacy Statement"
          }))
        }
      })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiLink, {
        onClick: _this.toggleExample
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "telemetry.seeExampleOfWhatWeCollectLinkText",
        defaultMessage: "See an example of what we collect"
      }))));
    });

    _defineProperty(_assertThisInitialized(_this), "toggleOptIn", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var _this$props, telemetryService, toasts, newOptInValue;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _this$props = _this.props, telemetryService = _this$props.telemetryService, toasts = _this$props.toasts;
              newOptInValue = !_this.state.enabled;
              return _context2.abrupt("return", new Promise(function (resolve, reject) {
                _this.setState({
                  processing: true,
                  enabled: newOptInValue
                }, /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                  return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                      switch (_context.prev = _context.next) {
                        case 0:
                          _context.prev = 0;
                          _context.next = 3;
                          return telemetryService.setOptIn(newOptInValue);

                        case 3:
                          _this.setState({
                            processing: false
                          });

                          toasts.addSuccess(newOptInValue ? i18n.translate('telemetry.optInSuccessOn', {
                            defaultMessage: 'Usage data collection turned on.'
                          }) : i18n.translate('telemetry.optInSuccessOff', {
                            defaultMessage: 'Usage data collection turned off.'
                          }));
                          resolve(true);
                          _context.next = 12;
                          break;

                        case 8:
                          _context.prev = 8;
                          _context.t0 = _context["catch"](0);

                          _this.setState({
                            processing: false
                          });

                          reject(_context.t0);

                        case 12:
                        case "end":
                          return _context.stop();
                      }
                    }
                  }, _callee, null, [[0, 8]]);
                })));
              }));

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));

    _defineProperty(_assertThisInitialized(_this), "toggleExample", function () {
      _this.setState({
        showExample: !_this.state.showExample
      });
    });

    return _this;
  }

  _createClass(TelemetryManagementSection, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      var _this2 = this;

      var query = nextProps.query;
      var searchTerm = (query.text || '').toLowerCase();
      var searchTermMatches = this.props.telemetryService.getCanChangeOptInStatus() && SEARCH_TERMS.some(function (term) {
        return term.indexOf(searchTerm) >= 0;
      });

      if (searchTermMatches !== this.state.queryMatches) {
        this.setState({
          queryMatches: searchTermMatches
        }, function () {
          _this2.props.onQueryMatchChange(searchTermMatches);
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var telemetryService = this.props.telemetryService;
      var _this$state = this.state,
          showExample = _this$state.showExample,
          queryMatches = _this$state.queryMatches,
          enabled = _this$state.enabled,
          processing = _this$state.processing;

      if (!telemetryService.getCanChangeOptInStatus()) {
        return null;
      }

      if (queryMatches !== null && !queryMatches) {
        return null;
      }

      return /*#__PURE__*/React.createElement(Fragment, null, showExample && /*#__PURE__*/React.createElement(OptInExampleFlyout, {
        fetchExample: telemetryService.fetchExample,
        onClose: this.toggleExample
      }), /*#__PURE__*/React.createElement(EuiPanel, {
        paddingSize: "l"
      }, /*#__PURE__*/React.createElement(EuiForm, null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        alignItems: "baseline"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "telemetry.usageDataTitle",
        defaultMessage: "Usage Data"
      }))))), this.maybeGetAppliesSettingMessage(), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/React.createElement(Field, {
        setting: {
          type: 'boolean',
          name: 'telemetry:enabled',
          displayName: i18n.translate('telemetry.provideUsageStatisticsTitle', {
            defaultMessage: 'Provide usage statistics'
          }),
          value: enabled,
          description: this.renderDescription(),
          defVal: true,
          ariaName: i18n.translate('telemetry.provideUsageStatisticsAriaName', {
            defaultMessage: 'Provide usage statistics'
          })
        },
        loading: processing,
        dockLinks: null,
        toasts: null,
        handleChange: this.toggleOptIn,
        enableSaving: this.props.enableSaving
      }))));
    }
  }]);

  return TelemetryManagementSection;
}(Component); // required for lazy loading
// eslint-disable-next-line import/no-default-export

export default TelemetryManagementSection;