function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { i18n } from '@kbn/i18n';
import { Control, noValuesDisableMsg, noIndexPatternMsg } from './control';
import { PhraseFilterManager } from './filter_manager/phrase_filter_manager';
import { createSearchSource } from './create_search_source';

function getEscapedQuery() {
  var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  // https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-regexp-query.html#_standard_operators
  return query.replace(/[.?+*|{}[\]()"\\#@&<>~]/g, function (match) {
    return "\\".concat(match);
  });
}

var termsAgg = function termsAgg(_ref) {
  var field = _ref.field,
      size = _ref.size,
      direction = _ref.direction,
      query = _ref.query;
  var terms = {
    order: {
      _count: direction
    }
  };

  if (size) {
    terms.size = size < 1 ? 1 : size;
  }

  if (field === null || field === void 0 ? void 0 : field.scripted) {
    terms.script = {
      source: field.script,
      lang: field.lang
    };
    terms.value_type = field.type === 'number' ? 'float' : field.type;
  } else {
    terms.field = field === null || field === void 0 ? void 0 : field.name;
  }

  if (query) {
    terms.include = ".*".concat(getEscapedQuery(query), ".*");
  }

  return {
    termsAgg: {
      terms: terms
    }
  };
};

export var ListControl = /*#__PURE__*/function (_Control) {
  _inherits(ListControl, _Control);

  var _super = _createSuper(ListControl);

  function ListControl(controlParams, filterManager, useTimeFilter, _searchSource, deps) {
    var _this;

    _classCallCheck(this, ListControl);

    _this = _super.call(this, controlParams, filterManager, useTimeFilter);

    _defineProperty(_assertThisInitialized(_this), "getSettings", void 0);

    _defineProperty(_assertThisInitialized(_this), "timefilter", void 0);

    _defineProperty(_assertThisInitialized(_this), "searchSource", void 0);

    _defineProperty(_assertThisInitialized(_this), "abortController", void 0);

    _defineProperty(_assertThisInitialized(_this), "lastAncestorValues", void 0);

    _defineProperty(_assertThisInitialized(_this), "lastQuery", void 0);

    _defineProperty(_assertThisInitialized(_this), "partialResults", void 0);

    _defineProperty(_assertThisInitialized(_this), "selectOptions", void 0);

    _defineProperty(_assertThisInitialized(_this), "fetch", /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(query) {
        var indexPattern, ancestorFilters, ancestorValues, fieldName, settings, initialSearchSourceState, aggs, searchSource, abortSignal, resp, selectOptions;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // Abort any in-progress fetch
                if (_this.abortController) {
                  _this.abortController.abort();
                }

                _this.abortController = new AbortController();
                indexPattern = _this.filterManager.getIndexPattern();

                if (indexPattern) {
                  _context.next = 6;
                  break;
                }

                _this.disable(noIndexPatternMsg(_this.controlParams.indexPattern));

                return _context.abrupt("return");

              case 6:
                if (!_this.hasAncestors()) {
                  _context.next = 17;
                  break;
                }

                if (!_this.hasUnsetAncestor()) {
                  _context.next = 11;
                  break;
                }

                _this.disable(i18n.translate('inputControl.listControl.disableTooltip', {
                  defaultMessage: "Disabled until '{label}' is set.",
                  values: {
                    label: _this.ancestors[0].label
                  }
                }));

                _this.lastAncestorValues = undefined;
                return _context.abrupt("return");

              case 11:
                ancestorValues = _this.getAncestorValues();

                if (!(_.isEqual(ancestorValues, _this.lastAncestorValues) && _.isEqual(query, _this.lastQuery))) {
                  _context.next = 14;
                  break;
                }

                return _context.abrupt("return");

              case 14:
                _this.lastAncestorValues = ancestorValues;
                _this.lastQuery = query;
                ancestorFilters = _this.getAncestorFilters();

              case 17:
                fieldName = _this.filterManager.fieldName;
                _context.next = 20;
                return _this.getSettings();

              case 20:
                settings = _context.sent;
                initialSearchSourceState = {
                  timeout: "".concat(settings.autocompleteTimeout, "ms"),
                  terminate_after: Number(settings.autocompleteTerminateAfter)
                };
                aggs = termsAgg({
                  field: indexPattern.fields.getByName(fieldName),
                  size: _this.options.dynamicOptions ? null : _.get(_this.options, 'size', 5),
                  direction: 'desc',
                  query: query
                });
                _context.next = 25;
                return createSearchSource(_this.searchSource, initialSearchSourceState, indexPattern, aggs, _this.useTimeFilter, ancestorFilters, _this.timefilter);

              case 25:
                searchSource = _context.sent;
                abortSignal = _this.abortController.signal;
                _this.lastQuery = query;
                _context.prev = 28;
                _context.next = 31;
                return searchSource.fetch({
                  abortSignal: abortSignal
                });

              case 31:
                resp = _context.sent;
                _context.next = 40;
                break;

              case 34:
                _context.prev = 34;
                _context.t0 = _context["catch"](28);

                if (!(_context.t0.name === 'AbortError')) {
                  _context.next = 38;
                  break;
                }

                return _context.abrupt("return");

              case 38:
                _this.disable(i18n.translate('inputControl.listControl.unableToFetchTooltip', {
                  defaultMessage: 'Unable to fetch terms, error: {errorMessage}',
                  values: {
                    errorMessage: _context.t0.message
                  }
                }));

                return _context.abrupt("return");

              case 40:
                if (!(query && _this.lastQuery !== query)) {
                  _context.next = 42;
                  break;
                }

                return _context.abrupt("return");

              case 42:
                selectOptions = _.get(resp, 'aggregations.termsAgg.buckets', []).map(function (bucket) {
                  return bucket === null || bucket === void 0 ? void 0 : bucket.key;
                });

                if (!(selectOptions.length === 0 && !query)) {
                  _context.next = 46;
                  break;
                }

                _this.disable(noValuesDisableMsg(fieldName, indexPattern.title));

                return _context.abrupt("return");

              case 46:
                _this.partialResults = resp.terminated_early || resp.timed_out;
                _this.selectOptions = selectOptions;
                _this.enable = true;
                _this.disabledReason = '';

              case 50:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[28, 34]]);
      }));

      return function (_x) {
        return _ref2.apply(this, arguments);
      };
    }());

    _this.getSettings = deps.getSettings;
    _this.timefilter = deps.data.query.timefilter.timefilter;
    _this.searchSource = _searchSource;
    return _this;
  }

  _createClass(ListControl, [{
    key: "destroy",
    value: function destroy() {
      if (this.abortController) this.abortController.abort();
    }
  }, {
    key: "hasValue",
    value: function hasValue() {
      return typeof this.value !== 'undefined' && this.value.length > 0;
    }
  }]);

  return ListControl;
}(Control);
export function listControlFactory(_x2, _x3, _x4) {
  return _listControlFactory.apply(this, arguments);
}

function _listControlFactory() {
  _listControlFactory = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(controlParams, useTimeFilter, deps) {
    var _yield$deps$core$getS, _yield$deps$core$getS2, dataPluginStart, indexPattern, field, listControl;

    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return deps.core.getStartServices();

          case 2:
            _yield$deps$core$getS = _context2.sent;
            _yield$deps$core$getS2 = _slicedToArray(_yield$deps$core$getS, 2);
            dataPluginStart = _yield$deps$core$getS2[1].data;
            _context2.next = 7;
            return dataPluginStart.indexPatterns.get(controlParams.indexPattern);

          case 7:
            indexPattern = _context2.sent;
            // dynamic options are only allowed on String fields but the setting defaults to true so it could
            // be enabled for non-string fields (since UI input is hidden for non-string fields).
            // If field is not string, then disable dynamic options.
            field = indexPattern.fields.find(function (_ref3) {
              var name = _ref3.name;
              return name === controlParams.fieldName;
            });

            if (field && field.type !== 'string') {
              controlParams.options.dynamicOptions = false;
            }

            listControl = new ListControl(controlParams, new PhraseFilterManager(controlParams.id, controlParams.fieldName, indexPattern, deps.data.query.filterManager), useTimeFilter, dataPluginStart.search.searchSource, deps);
            return _context2.abrupt("return", listControl);

          case 12:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _listControlFactory.apply(this, arguments);
}