"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseField = getUseField;
exports.UseField = void 0;

var _react = _interopRequireDefault(require("react"));

var _hooks = require("../hooks");

var _form_context = require("../form_context");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function UseFieldComp(props) {
  const {
    path,
    config,
    defaultValue,
    component,
    componentProps,
    readDefaultValueOnForm = true,
    onChange,
    children,
    ...rest
  } = props;
  const form = (0, _form_context.useFormContext)();
  const componentToRender = component !== null && component !== void 0 ? component : 'input'; // For backward compatibility we merge the "componentProps" prop into the "rest"

  const propsToForward = componentProps !== undefined ? { ...componentProps,
    ...rest
  } : { ...rest
  };
  const fieldConfig = config !== undefined ? { ...config
  } : { ...form.__readFieldConfigFromSchema(path)
  };

  if (defaultValue === undefined && readDefaultValueOnForm) {
    var _form$getFieldDefault;

    // Read the field default value from the "defaultValue" object passed to the form
    fieldConfig.defaultValue = (_form$getFieldDefault = form.getFieldDefaultValue(path)) !== null && _form$getFieldDefault !== void 0 ? _form$getFieldDefault : fieldConfig.defaultValue;
  } else if (defaultValue !== undefined) {
    // Read the field default value from the propvided prop
    fieldConfig.defaultValue = defaultValue;
  }

  if (!fieldConfig.path) {
    fieldConfig.path = path;
  } else {
    if (fieldConfig.path !== path) {
      throw new Error(`Field path mismatch. Got "${path}" but field config has "${fieldConfig.path}".`);
    }
  }

  const field = (0, _hooks.useField)(form, path, fieldConfig, onChange); // Children prevails over anything else provided.

  if (children) {
    return children(field);
  }

  if (componentToRender === 'input') {
    return /*#__PURE__*/_react.default.createElement("input", _extends({
      type: field.type,
      onChange: field.onChange,
      value: field.value
    }, propsToForward));
  }

  return componentToRender({
    field,
    ...propsToForward
  });
}

const UseField = /*#__PURE__*/_react.default.memo(UseFieldComp);
/**
 * Get a <UseField /> component providing some common props for all instances.
 * @param partialProps Partial props to apply to all <UseField /> instances
 */


exports.UseField = UseField;

function getUseField(partialProps) {
  return function (props) {
    const componentProps = { ...partialProps,
      ...props
    };
    return /*#__PURE__*/_react.default.createElement(UseField, componentProps);
  };
}