function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './discover_sidebar.scss';
import React, { useCallback, useEffect, useState, useMemo } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiButtonIcon, EuiTitle } from '@elastic/eui';
import { sortBy } from 'lodash';
import { FormattedMessage, I18nProvider } from '@kbn/i18n/react';
import { DiscoverField } from './discover_field';
import { DiscoverIndexPattern } from './discover_index_pattern';
import { DiscoverFieldSearch } from './discover_field_search';
import { FIELDS_LIMIT_SETTING } from '../../../../common';
import { groupFields } from './lib/group_fields';
import { UI_SETTINGS } from '../../../../../data/public';
import { getDetails } from './lib/get_details';
import { getDefaultFieldFilter, setFieldFilterProp } from './lib/field_filter';
import { getIndexPatternFieldList } from './lib/get_index_pattern_field_list';
import { getServices } from '../../../kibana_services';
export function DiscoverSidebar(_ref) {
  var columns = _ref.columns,
      fieldCounts = _ref.fieldCounts,
      hits = _ref.hits,
      indexPatternList = _ref.indexPatternList,
      onAddField = _ref.onAddField,
      onAddFilter = _ref.onAddFilter,
      onRemoveField = _ref.onRemoveField,
      selectedIndexPattern = _ref.selectedIndexPattern,
      setIndexPattern = _ref.setIndexPattern,
      state = _ref.state;

  var _useState = useState(new Map()),
      _useState2 = _slicedToArray(_useState, 2),
      openFieldMap = _useState2[0],
      setOpenFieldMap = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      showFields = _useState4[0],
      setShowFields = _useState4[1];

  var _useState5 = useState(null),
      _useState6 = _slicedToArray(_useState5, 2),
      fields = _useState6[0],
      setFields = _useState6[1];

  var _useState7 = useState(getDefaultFieldFilter()),
      _useState8 = _slicedToArray(_useState7, 2),
      fieldFilterState = _useState8[0],
      setFieldFilterState = _useState8[1];

  var services = useMemo(function () {
    return getServices();
  }, []);
  useEffect(function () {
    var newFields = getIndexPatternFieldList(selectedIndexPattern, fieldCounts, services);
    setFields(newFields);
  }, [selectedIndexPattern, fieldCounts, hits, services]);
  var onShowDetails = useCallback(function (show, field) {
    if (!show) {
      setOpenFieldMap(new Map(openFieldMap.set(field.name, false)));
    } else {
      setOpenFieldMap(new Map(openFieldMap.set(field.name, true)));

      if (services.capabilities.discover.save) {
        selectedIndexPattern.popularizeField(field.name, 1);
      }
    }
  }, [openFieldMap, selectedIndexPattern, services.capabilities.discover.save]);
  var onChangeFieldSearch = useCallback(function (field, value) {
    var newState = setFieldFilterProp(fieldFilterState, field, value);
    setFieldFilterState(newState);
  }, [fieldFilterState]);
  var getDetailsByField = useCallback(function (ipField) {
    return getDetails(ipField, selectedIndexPattern, state, columns, hits, services);
  }, [selectedIndexPattern, state, columns, hits, services]);
  var popularLimit = services.uiSettings.get(FIELDS_LIMIT_SETTING);
  var useShortDots = services.uiSettings.get(UI_SETTINGS.SHORT_DOTS_ENABLE);

  var _useMemo = useMemo(function () {
    return groupFields(fields, columns, popularLimit, fieldCounts, fieldFilterState);
  }, [fields, columns, popularLimit, fieldCounts, fieldFilterState]),
      selectedFields = _useMemo.selected,
      popularFields = _useMemo.popular,
      unpopularFields = _useMemo.unpopular;

  var fieldTypes = useMemo(function () {
    var result = ['any'];

    if (Array.isArray(fields)) {
      var _iterator = _createForOfIteratorHelper(fields),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _field = _step.value;

          if (result.indexOf(_field.type) === -1) {
            result.push(_field.type);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    return result;
  }, [fields]);

  if (!selectedIndexPattern || !fields) {
    return null;
  }

  return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement("section", {
    className: "sidebar-list",
    "aria-label": i18n.translate('discover.fieldChooser.filter.indexAndFieldsSectionAriaLabel', {
      defaultMessage: 'Index and fields'
    })
  }, /*#__PURE__*/React.createElement(DiscoverIndexPattern, {
    selectedIndexPattern: selectedIndexPattern,
    setIndexPattern: setIndexPattern,
    indexPatternList: sortBy(indexPatternList, function (o) {
      return o.attributes.title;
    })
  }), /*#__PURE__*/React.createElement("div", {
    className: "dscSidebar__item"
  }, /*#__PURE__*/React.createElement("form", null, /*#__PURE__*/React.createElement(DiscoverFieldSearch, {
    onChange: onChangeFieldSearch,
    value: fieldFilterState.name,
    types: fieldTypes
  }))), /*#__PURE__*/React.createElement("div", {
    className: "sidebar-list"
  }, fields.length > 0 && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xxxs",
    id: "selected_fields"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.fieldChooser.filter.selectedFieldsTitle",
    defaultMessage: "Selected fields"
  }))), /*#__PURE__*/React.createElement("ul", {
    className: "dscSidebarList dscFieldList--selected",
    "aria-labelledby": "selected_fields",
    "data-test-subj": "fieldList-selected"
  }, selectedFields.map(function (field, idx) {
    return /*#__PURE__*/React.createElement("li", {
      key: "field".concat(idx),
      "data-attr-field": field.name,
      className: "dscSidebar__item"
    }, /*#__PURE__*/React.createElement(DiscoverField, {
      field: field,
      indexPattern: selectedIndexPattern,
      onAddField: onAddField,
      onRemoveField: onRemoveField,
      onAddFilter: onAddFilter,
      onShowDetails: onShowDetails,
      getDetails: getDetailsByField,
      showDetails: openFieldMap.get(field.name) || false,
      selected: true,
      useShortDots: useShortDots
    }));
  })), /*#__PURE__*/React.createElement("div", {
    className: "euiFlexGroup euiFlexGroup--gutterMedium"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xxxs",
    id: "available_fields",
    className: "euiFlexItem"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.fieldChooser.filter.availableFieldsTitle",
    defaultMessage: "Available fields"
  }))), /*#__PURE__*/React.createElement("div", {
    className: "euiFlexItem euiFlexItem--flexGrowZero"
  }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    className: 'visible-xs visible-sm dscFieldChooser__toggle',
    iconType: showFields ? 'arrowDown' : 'arrowRight',
    onClick: function onClick() {
      return setShowFields(!showFields);
    },
    "aria-label": showFields ? i18n.translate('discover.fieldChooser.filter.indexAndFieldsSectionHideAriaLabel', {
      defaultMessage: 'Hide fields'
    }) : i18n.translate('discover.fieldChooser.filter.indexAndFieldsSectionShowAriaLabel', {
      defaultMessage: 'Show fields'
    })
  })))), popularFields.length > 0 && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xxxs",
    className: "dscFieldListHeader ".concat(!showFields ? 'hidden-sm hidden-xs' : '')
  }, /*#__PURE__*/React.createElement("h4", {
    style: {
      fontWeight: 'normal'
    },
    id: "available_fields_popular"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.fieldChooser.filter.popularTitle",
    defaultMessage: "Popular"
  }))), /*#__PURE__*/React.createElement("ul", {
    className: "dscFieldList dscFieldList--popular ".concat(!showFields ? 'hidden-sm hidden-xs' : ''),
    "aria-labelledby": "available_fields available_fields_popular",
    "data-test-subj": "fieldList-popular"
  }, popularFields.map(function (field, idx) {
    return /*#__PURE__*/React.createElement("li", {
      key: "field".concat(idx),
      "data-attr-field": field.name,
      className: "dscSidebar__item"
    }, /*#__PURE__*/React.createElement(DiscoverField, {
      field: field,
      indexPattern: selectedIndexPattern,
      onAddField: onAddField,
      onRemoveField: onRemoveField,
      onAddFilter: onAddFilter,
      onShowDetails: onShowDetails,
      getDetails: getDetailsByField,
      showDetails: openFieldMap.get(field.name) || false,
      useShortDots: useShortDots
    }));
  }))), /*#__PURE__*/React.createElement("ul", {
    className: "dscFieldList dscFieldList--unpopular ".concat(!showFields ? 'hidden-sm hidden-xs' : ''),
    "aria-labelledby": "available_fields",
    "data-test-subj": "fieldList-unpopular"
  }, unpopularFields.map(function (field, idx) {
    return /*#__PURE__*/React.createElement("li", {
      key: "field".concat(idx),
      "data-attr-field": field.name,
      className: "dscSidebar__item"
    }, /*#__PURE__*/React.createElement(DiscoverField, {
      field: field,
      indexPattern: selectedIndexPattern,
      onAddField: onAddField,
      onRemoveField: onRemoveField,
      onAddFilter: onAddFilter,
      onShowDetails: onShowDetails,
      getDetails: getDetailsByField,
      showDetails: openFieldMap.get(field.name) || false,
      useShortDots: useShortDots
    }));
  })))));
}