function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { first } from 'rxjs/operators';
import { METRIC_TYPE } from '../../../../usage_collection/public';
import { SEARCH_EVENT_TYPE } from './types';
export var createUsageCollector = function createUsageCollector(core, usageCollection) {
  var getCurrentApp = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var _yield$core$getStartS, _yield$core$getStartS2, application;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return core.getStartServices();

            case 2:
              _yield$core$getStartS = _context.sent;
              _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 1);
              application = _yield$core$getStartS2[0].application;
              return _context.abrupt("return", application.currentAppId$.pipe(first()).toPromise());

            case 6:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function getCurrentApp() {
      return _ref.apply(this, arguments);
    };
  }();

  return {
    trackQueryTimedOut: function () {
      var _trackQueryTimedOut = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var currentApp;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return getCurrentApp();

              case 2:
                currentApp = _context2.sent;
                return _context2.abrupt("return", usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiStats(currentApp, METRIC_TYPE.LOADED, SEARCH_EVENT_TYPE.QUERY_TIMED_OUT));

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function trackQueryTimedOut() {
        return _trackQueryTimedOut.apply(this, arguments);
      }

      return trackQueryTimedOut;
    }(),
    trackQueriesCancelled: function () {
      var _trackQueriesCancelled = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        var currentApp;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return getCurrentApp();

              case 2:
                currentApp = _context3.sent;
                return _context3.abrupt("return", usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiStats(currentApp, METRIC_TYPE.LOADED, SEARCH_EVENT_TYPE.QUERIES_CANCELLED));

              case 4:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      function trackQueriesCancelled() {
        return _trackQueriesCancelled.apply(this, arguments);
      }

      return trackQueriesCancelled;
    }(),
    trackLongQueryPopupShown: function () {
      var _trackLongQueryPopupShown = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
        var currentApp;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                _context4.next = 2;
                return getCurrentApp();

              case 2:
                currentApp = _context4.sent;
                return _context4.abrupt("return", usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiStats(currentApp, METRIC_TYPE.LOADED, SEARCH_EVENT_TYPE.LONG_QUERY_POPUP_SHOWN));

              case 4:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4);
      }));

      function trackLongQueryPopupShown() {
        return _trackLongQueryPopupShown.apply(this, arguments);
      }

      return trackLongQueryPopupShown;
    }(),
    trackLongQueryDialogDismissed: function () {
      var _trackLongQueryDialogDismissed = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
        var currentApp;
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                _context5.next = 2;
                return getCurrentApp();

              case 2:
                currentApp = _context5.sent;
                return _context5.abrupt("return", usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiStats(currentApp, METRIC_TYPE.CLICK, SEARCH_EVENT_TYPE.LONG_QUERY_DIALOG_DISMISSED));

              case 4:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5);
      }));

      function trackLongQueryDialogDismissed() {
        return _trackLongQueryDialogDismissed.apply(this, arguments);
      }

      return trackLongQueryDialogDismissed;
    }(),
    trackLongQueryRunBeyondTimeout: function () {
      var _trackLongQueryRunBeyondTimeout = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
        var currentApp;
        return regeneratorRuntime.wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                _context6.next = 2;
                return getCurrentApp();

              case 2:
                currentApp = _context6.sent;
                return _context6.abrupt("return", usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiStats(currentApp, METRIC_TYPE.CLICK, SEARCH_EVENT_TYPE.LONG_QUERY_RUN_BEYOND_TIMEOUT));

              case 4:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6);
      }));

      function trackLongQueryRunBeyondTimeout() {
        return _trackLongQueryRunBeyondTimeout.apply(this, arguments);
      }

      return trackLongQueryRunBeyondTimeout;
    }()
  };
};