function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// Brace's token information types are not accurate.
var toToken = function toToken(lineNumber, column, token) {
  return {
    type: token.type,
    value: token.value,
    position: {
      lineNumber: lineNumber,
      column: column
    }
  };
};

var toTokens = function toTokens(lineNumber, tokens) {
  var acc = '';
  return tokens.map(function (token) {
    var column = acc.length + 1;
    acc += token.value;
    return toToken(lineNumber, column, token);
  });
};

var extractTokenFromAceTokenRow = function extractTokenFromAceTokenRow(lineNumber, column, aceTokens) {
  var acc = '';

  var _iterator = _createForOfIteratorHelper(aceTokens),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var token = _step.value;
      var start = acc.length + 1;
      acc += token.value;
      var end = acc.length;
      if (column < start) continue;
      if (column > end + 1) continue;
      return toToken(lineNumber, start, token);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return null;
};

export var AceTokensProvider = /*#__PURE__*/function () {
  function AceTokensProvider(session) {
    _classCallCheck(this, AceTokensProvider);

    this.session = session;
  }

  _createClass(AceTokensProvider, [{
    key: "getTokens",
    value: function getTokens(lineNumber) {
      if (lineNumber < 1) return null; // Important: must use a .session.getLength because this is a cached value.
      // Calculating line length here will lead to performance issues because this function
      // may be called inside of tight loops.

      var lineCount = this.session.getLength();

      if (lineNumber > lineCount) {
        return null;
      }

      var tokens = this.session.getTokens(lineNumber - 1);

      if (!tokens || !tokens.length) {
        // We are inside of the document but have no tokens for this line. Return an empty
        // array to represent this empty line.
        return [];
      }

      return toTokens(lineNumber, tokens);
    }
  }, {
    key: "getTokenAt",
    value: function getTokenAt(pos) {
      var tokens = this.session.getTokens(pos.lineNumber - 1);

      if (tokens) {
        return extractTokenFromAceTokenRow(pos.lineNumber, pos.column, tokens);
      }

      return null;
    }
  }]);

  return AceTokensProvider;
}();