function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import * as Rx from 'rxjs';
import { ErrorToast } from './error_toast';
import { mountReactNode } from '../../utils';

var normalizeToast = function normalizeToast(toastOrTitle) {
  if (typeof toastOrTitle === 'string') {
    return {
      title: toastOrTitle
    };
  }

  return toastOrTitle;
};
/**
 * Methods for adding and removing global toast messages. See {@link ToastsApi}.
 * @public
 */


/**
 * Methods for adding and removing global toast messages.
 * @public
 */
export var ToastsApi = /*#__PURE__*/function () {
  function ToastsApi(deps) {
    _classCallCheck(this, ToastsApi);

    _defineProperty(this, "toasts$", new Rx.BehaviorSubject([]));

    _defineProperty(this, "idCounter", 0);

    _defineProperty(this, "uiSettings", void 0);

    _defineProperty(this, "overlays", void 0);

    _defineProperty(this, "i18n", void 0);

    this.uiSettings = deps.uiSettings;
  }
  /** @internal */


  _createClass(ToastsApi, [{
    key: "start",
    value: function start(_ref) {
      var overlays = _ref.overlays,
          i18n = _ref.i18n;
      this.overlays = overlays;
      this.i18n = i18n;
    }
    /** Observable of the toast messages to show to the user. */

  }, {
    key: "get$",
    value: function get$() {
      return this.toasts$.asObservable();
    }
    /**
     * Adds a new toast to current array of toast.
     *
     * @param toastOrTitle - a {@link ToastInput}
     * @returns a {@link Toast}
     */

  }, {
    key: "add",
    value: function add(toastOrTitle) {
      var toast = _objectSpread({
        id: String(this.idCounter++),
        toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:info')
      }, normalizeToast(toastOrTitle));

      this.toasts$.next([].concat(_toConsumableArray(this.toasts$.getValue()), [toast]));
      return toast;
    }
    /**
     * Removes a toast from the current array of toasts if present.
     * @param toastOrId - a {@link Toast} returned by {@link ToastsApi.add} or its id
     */

  }, {
    key: "remove",
    value: function remove(toastOrId) {
      var toRemove = typeof toastOrId === 'string' ? toastOrId : toastOrId.id;
      var list = this.toasts$.getValue();
      var listWithoutToast = list.filter(function (t) {
        return t.id !== toRemove;
      });

      if (listWithoutToast.length !== list.length) {
        this.toasts$.next(listWithoutToast);
      }
    }
    /**
     * Adds a new toast pre-configured with the info color and info icon.
     *
     * @param toastOrTitle - a {@link ToastInput}
     * @param options - a {@link ToastOptions}
     * @returns a {@link Toast}
     */

  }, {
    key: "addInfo",
    value: function addInfo(toastOrTitle, options) {
      return this.add(_objectSpread(_objectSpread({
        color: 'primary',
        iconType: 'iInCircle'
      }, normalizeToast(toastOrTitle)), options));
    }
    /**
     * Adds a new toast pre-configured with the success color and check icon.
     *
     * @param toastOrTitle - a {@link ToastInput}
     * @param options - a {@link ToastOptions}
     * @returns a {@link Toast}
     */

  }, {
    key: "addSuccess",
    value: function addSuccess(toastOrTitle, options) {
      return this.add(_objectSpread(_objectSpread({
        color: 'success',
        iconType: 'check'
      }, normalizeToast(toastOrTitle)), options));
    }
    /**
     * Adds a new toast pre-configured with the warning color and help icon.
     *
     * @param toastOrTitle - a {@link ToastInput}
     * @param options - a {@link ToastOptions}
     * @returns a {@link Toast}
     */

  }, {
    key: "addWarning",
    value: function addWarning(toastOrTitle, options) {
      return this.add(_objectSpread(_objectSpread({
        color: 'warning',
        iconType: 'help',
        toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:warning')
      }, normalizeToast(toastOrTitle)), options));
    }
    /**
     * Adds a new toast pre-configured with the danger color and alert icon.
     *
     * @param toastOrTitle - a {@link ToastInput}
     * @param options - a {@link ToastOptions}
     * @returns a {@link Toast}
     */

  }, {
    key: "addDanger",
    value: function addDanger(toastOrTitle, options) {
      return this.add(_objectSpread(_objectSpread({
        color: 'danger',
        iconType: 'alert',
        toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:warning')
      }, normalizeToast(toastOrTitle)), options));
    }
    /**
     * Adds a new toast that displays an exception message with a button to open the full stacktrace in a modal.
     *
     * @param error - an `Error` instance.
     * @param options - {@link ErrorToastOptions}
     * @returns a {@link Toast}
     */

  }, {
    key: "addError",
    value: function addError(error, options) {
      var _this = this;

      var message = options.toastMessage || error.message;
      return this.add(_objectSpread({
        color: 'danger',
        iconType: 'alert',
        toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:error'),
        text: mountReactNode( /*#__PURE__*/React.createElement(ErrorToast, {
          openModal: this.openModal.bind(this),
          error: error,
          title: options.title,
          toastMessage: message,
          i18nContext: function i18nContext() {
            return _this.i18n.Context;
          }
        }))
      }, options));
    }
  }, {
    key: "openModal",
    value: function openModal() {
      var _this$overlays;

      if (!this.overlays) {
        // This case should never happen because no rendering should be occurring
        // before the ToastService is started.
        throw new Error("Modal opened before ToastService was started.");
      }

      return (_this$overlays = this.overlays).openModal.apply(_this$overlays, arguments);
    }
  }]);

  return ToastsApi;
}();