"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiListGroupItem = exports.COLORS = exports.SIZES = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _button = require("../button");

var _icon = require("../icon");

var _tool_tip = require("../tool_tip");

var _inner_text = require("../inner_text");

var _services = require("../../services");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sizeToClassNameMap = {
  xs: 'euiListGroupItem--xSmall',
  s: 'euiListGroupItem--small',
  m: 'euiListGroupItem--medium',
  l: 'euiListGroupItem--large'
};
var SIZES = Object.keys(sizeToClassNameMap);
exports.SIZES = SIZES;
var colorToClassNameMap = {
  inherit: '',
  primary: 'euiListGroupItem--primary',
  text: 'euiListGroupItem--text',
  subdued: 'euiListGroupItem--subdued',
  ghost: 'euiListGroupItem--ghost'
};
var COLORS = Object.keys(colorToClassNameMap);
exports.COLORS = COLORS;

var EuiListGroupItem = function EuiListGroupItem(_ref) {
  var label = _ref.label,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? false : _ref$isActive,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      href = _ref.href,
      target = _ref.target,
      rel = _ref.rel,
      className = _ref.className,
      iconType = _ref.iconType,
      icon = _ref.icon,
      extraAction = _ref.extraAction,
      onClick = _ref.onClick,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'inherit' : _ref$color,
      _ref$showToolTip = _ref.showToolTip,
      showToolTip = _ref$showToolTip === void 0 ? false : _ref$showToolTip,
      wrapText = _ref.wrapText,
      buttonRef = _ref.buttonRef,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["label", "isActive", "isDisabled", "href", "target", "rel", "className", "iconType", "icon", "extraAction", "onClick", "size", "color", "showToolTip", "wrapText", "buttonRef"]);
  var classes = (0, _classnames.default)('euiListGroupItem', sizeToClassNameMap[size], colorToClassNameMap[color], {
    'euiListGroupItem-isActive': isActive,
    'euiListGroupItem-isDisabled': isDisabled,
    'euiListGroupItem-isClickable': href || onClick,
    'euiListGroupItem-hasExtraAction': extraAction,
    'euiListGroupItem--wrapText': wrapText
  }, className);
  var iconNode;

  if (iconType) {
    iconNode = _react.default.createElement(_icon.EuiIcon, {
      className: "euiListGroupItem__icon",
      type: iconType
    });

    if (icon) {
      console.warn('Both `iconType` and `icon` were passed to EuiListGroupItem but only one can exist. The `iconType` was used.');
    }
  } else if (icon) {
    iconNode = _react.default.cloneElement(icon, {
      className: (0, _classnames.default)('euiListGroupItem__icon', icon.props.className)
    });
  }

  var extraActionNode;

  if (extraAction) {
    var _iconType = extraAction.iconType,
        alwaysShow = extraAction.alwaysShow,
        _className = extraAction.className,
        _rest = (0, _objectWithoutProperties2.default)(extraAction, ["iconType", "alwaysShow", "className"]);

    var extraActionClasses = (0, _classnames.default)('euiListGroupItem__extraAction', {
      'euiListGroupItem__extraAction-alwaysShow': alwaysShow
    }, _className);
    extraActionNode = _react.default.createElement(_button.EuiButtonIcon, (0, _extends2.default)({
      className: extraActionClasses,
      iconType: _iconType
    }, _rest, {
      disabled: isDisabled
    }));
  } // Only add the label as the title attribute if it's possibly truncated
  // Also ensure the value of the title attribute is a string


  var _useInnerText = (0, _inner_text.useInnerText)(),
      _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
      ref = _useInnerText2[0],
      innerText = _useInnerText2[1];

  var shouldRenderTitle = !wrapText && !showToolTip;
  var labelContent = shouldRenderTitle ? _react.default.createElement("span", {
    ref: ref,
    className: "euiListGroupItem__label",
    title: typeof label === 'string' ? label : innerText
  }, label) : _react.default.createElement("span", {
    className: "euiListGroupItem__label"
  }, label); // Handle the variety of interaction behavior

  var itemContent;
  var secureRel = (0, _services.getSecureRelForTarget)({
    href: href,
    rel: rel,
    target: target
  });

  if (href && !isDisabled) {
    itemContent = _react.default.createElement("a", (0, _extends2.default)({
      className: "euiListGroupItem__button",
      href: href,
      target: target,
      rel: secureRel,
      onClick: onClick
    }, rest), iconNode, labelContent);
  } else if (href && isDisabled || onClick) {
    itemContent = _react.default.createElement("button", (0, _extends2.default)({
      type: "button",
      className: "euiListGroupItem__button",
      disabled: isDisabled,
      onClick: onClick,
      ref: buttonRef
    }, rest), iconNode, labelContent);
  } else {
    itemContent = _react.default.createElement("span", (0, _extends2.default)({
      className: "euiListGroupItem__text"
    }, rest), iconNode, labelContent);
  }

  if (showToolTip) {
    itemContent = _react.default.createElement("li", {
      className: classes
    }, _react.default.createElement(_tool_tip.EuiToolTip, {
      anchorClassName: "euiListGroupItem__tooltip",
      content: label,
      position: "right",
      delay: "long"
    }, itemContent));
  } else {
    itemContent = _react.default.createElement("li", {
      className: classes
    }, itemContent, extraActionNode);
  }

  return _react.default.createElement(_react.Fragment, null, itemContent);
};

exports.EuiListGroupItem = EuiListGroupItem;
EuiListGroupItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Size of the label text
       */
  size: _propTypes.default.oneOf(["xs", "s", "m", "l"]),

  /**
       * By default the item will inherit the color of its wrapper (button/link/span),
       * otherwise pass one of the acceptable options
       */
  color: _propTypes.default.oneOf(["inherit", "primary", "text", "subdued", "ghost"]),

  /**
       * Content to be displayed in the list item
       */
  label: _propTypes.default.node.isRequired,

  /**
       * Apply styles indicating an item is active
       */
  isActive: _propTypes.default.bool,

  /**
       * Apply styles indicating an item is disabled
       */
  isDisabled: _propTypes.default.bool,

  /**
       * Make the list item label a link.
       * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
       */
  href: _propTypes.default.string,
  target: _propTypes.default.string,
  rel: _propTypes.default.string,

  /**
       * Adds `EuiIcon` of `EuiIcon.type`
       */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

  /**
       * Custom node to pass as the icon. Cannot be used in conjunction
       * with `iconType`.
       */
  icon: _propTypes.default.element,

  /**
       * Display tooltip on list item
       */
  showToolTip: _propTypes.default.bool,

  /**
       * Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;
       * pass `alwaysShow` if you don't want the default behavior of only showing on hover
       */
  extraAction: _propTypes.default.shape({
    onClick: _propTypes.default.func,
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    color: _propTypes.default.oneOf(["danger", "disabled", "ghost", "primary", "subdued", "success", "text", "warning"]),
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    isDisabled: _propTypes.default.bool,
    size: _propTypes.default.oneOf(["s", "m"]),
    iconSize: _propTypes.default.oneOf(["original", "s", "m", "l", "xl", "xxl"]),
    className: _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    buttonRef: _propTypes.default.any,
    alwaysShow: _propTypes.default.bool
  }),

  /**
       * Make the list item label a button.
       * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
       */
  onClick: _propTypes.default.func,

  /**
       * Allow link text to wrap
       */
  wrapText: _propTypes.default.bool,

  /**
       * Pass-through ref reference specifically for targeting
       * instances where the item content is rendered as a `button`
       */
  buttonRef: _propTypes.default.any
};
EuiListGroupItem.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiListGroupItem",
  "props": {
    "isActive": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Apply styles indicating an item is active"
    },
    "isDisabled": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Apply styles indicating an item is disabled"
    },
    "size": {
      "defaultValue": {
        "value": "'m'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"xs\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Size of the label text"
    },
    "color": {
      "defaultValue": {
        "value": "'inherit'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"inherit\"",
          "computed": false
        }, {
          "value": "\"primary\"",
          "computed": false
        }, {
          "value": "\"text\"",
          "computed": false
        }, {
          "value": "\"subdued\"",
          "computed": false
        }, {
          "value": "\"ghost\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "By default the item will inherit the color of its wrapper (button/link/span),\notherwise pass one of the acceptable options"
    },
    "showToolTip": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Display tooltip on list item"
    },
    "className": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.string"
      },
      "required": false,
      "description": ""
    },
    "label": {
      "type": {
        "name": "node"
      },
      "required": true,
      "description": "Content to be displayed in the list item"
    },
    "href": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Make the list item label a link.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems."
    },
    "target": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "rel": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "iconType": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.oneOfType([_propTypes.default.oneOf([\"accessibility\", \"addDataApp\", \"advancedSettingsApp\", \"aggregate\", \"alert\", \"annotation\", \"apmApp\", \"apmTrace\", \"apps\", \"arrowDown\", \"arrowLeft\", \"arrowRight\", \"arrowUp\", \"asterisk\", \"auditbeatApp\", \"beaker\", \"bell\", \"bellSlash\", \"bolt\", \"boxesHorizontal\", \"boxesVertical\", \"branch\", \"broom\", \"brush\", \"bug\", \"bullseye\", \"calendar\", \"canvasApp\", \"codeApp\", \"check\", \"checkInCircleFilled\", \"cheer\", \"clock\", \"cloudDrizzle\", \"cloudStormy\", \"cloudSunny\", \"compute\", \"console\", \"consoleApp\", \"controlsHorizontal\", \"controlsVertical\", \"copy\", \"copyClipboard\", \"createAdvancedJob\", \"createMultiMetricJob\", \"createPopulationJob\", \"createSingleMetricJob\", \"cross\", \"crossClusterReplicationApp\", \"crosshairs\", \"crossInACircleFilled\", \"currency\", \"cut\", \"dashboardApp\", \"database\", \"dataVisualizer\", \"devToolsApp\", \"discoverApp\", \"document\", \"documentEdit\", \"documents\", \"dot\", \"download\", \"editorAlignCenter\", \"editorAlignLeft\", \"editorAlignRight\", \"editorBold\", \"editorCodeBlock\", \"editorComment\", \"editorDistributeHorizontal\", \"editorDistributeVertical\", \"editorHeading\", \"editorItalic\", \"editorItemAlignLeft\", \"editorItemAlignBottom\", \"editorItemAlignCenter\", \"editorItemAlignMiddle\", \"editorItemAlignRight\", \"editorItemAlignTop\", \"editorLink\", \"editorOrderedList\", \"editorPositionBottomLeft\", \"editorPositionBottomRight\", \"editorPositionTopLeft\", \"editorPositionTopRight\", \"editorRedo\", \"editorStrike\", \"editorTable\", \"editorUnderline\", \"editorUndo\", \"editorUnorderedList\", \"email\", \"empty\", \"emsApp\", \"exit\", \"expand\", \"expandMini\", \"exportAction\", \"eye\", \"eyeClosed\", \"faceHappy\", \"faceNeutral\", \"faceSad\", \"filebeatApp\", \"filter\", \"flag\", \"folderCheck\", \"folderClosed\", \"folderExclamation\", \"folderOpen\", \"fullScreen\", \"gear\", \"gisApp\", \"glasses\", \"globe\", \"grab\", \"grabHorizontal\", \"graphApp\", \"grid\", \"grokApp\", \"heart\", \"heartbeatApp\", \"heatmap\", \"help\", \"home\", \"iInCircle\", \"image\", \"importAction\", \"indexClose\", \"indexEdit\", \"indexFlush\", \"indexManagementApp\", \"indexMapping\", \"indexOpen\", \"indexPatternApp\", \"indexRollupApp\", \"indexSettings\", \"inputOutput\", \"inspect\", \"invert\", \"ip\", \"keyboardShortcut\", \"kqlField\", \"kqlFunction\", \"kqlOperand\", \"kqlSelector\", \"kqlValue\", \"lensApp\", \"link\", \"list\", \"listAdd\", \"lock\", \"lockOpen\", \"logsApp\", \"logoAerospike\", \"logoApache\", \"logoAPM\", \"logoAppSearch\", \"logoAWS\", \"logoAWSMono\", \"logoAzure\", \"logoAzureMono\", \"logoBeats\", \"logoBusinessAnalytics\", \"logoCeph\", \"logoCloud\", \"logoCloudEnterprise\", \"logoCode\", \"logoCodesandbox\", \"logoCouchbase\", \"logoDocker\", \"logoDropwizard\", \"logoElastic\", \"logoElasticsearch\", \"logoElasticStack\", \"logoEnterpriseSearch\", \"logoEtcd\", \"logoGCP\", \"logoGCPMono\", \"logoGithub\", \"logoGmail\", \"logoGolang\", \"logoGoogleG\", \"logoHAproxy\", \"logoIBM\", \"logoIBMMono\", \"logoKafka\", \"logoKibana\", \"logoKubernetes\", \"logoLogging\", \"logoLogstash\", \"logoMaps\", \"logoMemcached\", \"logoMetrics\", \"logoMongodb\", \"logoMySQL\", \"logoNginx\", \"logoObservability\", \"logoOsquery\", \"logoPhp\", \"logoPostgres\", \"logoPrometheus\", \"logoRabbitmq\", \"logoRedis\", \"logoSecurity\", \"logoSiteSearch\", \"logoSketch\", \"logoSlack\", \"logoUptime\", \"logoWebhook\", \"logoWindows\", \"logoWorkplaceSearch\", \"logstashFilter\", \"logstashIf\", \"logstashInput\", \"logstashOutput\", \"logstashQueue\", \"machineLearningApp\", \"magnet\", \"magnifyWithMinus\", \"magnifyWithPlus\", \"managementApp\", \"mapMarker\", \"memory\", \"menu\", \"menuLeft\", \"menuRight\", \"merge\", \"metricbeatApp\", \"metricsApp\", \"minimize\", \"minusInCircle\", \"minusInCircleFilled\", \"monitoringApp\", \"moon\", \"nested\", \"node\", \"notebookApp\", \"number\", \"offline\", \"online\", \"package\", \"packetbeatApp\", \"pageSelect\", \"pagesSelect\", \"partial\", \"paperClip\", \"pause\", \"pencil\", \"pin\", \"pinFilled\", \"pipelineApp\", \"play\", \"plusInCircle\", \"plusInCircleFilled\", \"popout\", \"push\", \"questionInCircle\", \"quote\", \"recentlyViewedApp\", \"refresh\", \"reporter\", \"reportingApp\", \"save\", \"savedObjectsApp\", \"scale\", \"search\", \"searchProfilerApp\", \"securityAnalyticsApp\", \"securityApp\", \"securitySignal\", \"securitySignalDetected\", \"securitySignalResolved\", \"shard\", \"share\", \"snowflake\", \"sortable\", \"sortDown\", \"sortLeft\", \"sortRight\", \"sortUp\", \"spacesApp\", \"sqlApp\", \"starEmpty\", \"starEmptySpace\", \"starFilled\", \"starFilledSpace\", \"starMinusEmpty\", \"starMinusFilled\", \"starPlusEmpty\", \"starPlusFilled\", \"stats\", \"stop\", \"stopFilled\", \"stopSlash\", \"storage\", \"string\", \"submodule\", \"swatchInput\", \"symlink\", \"tableOfContents\", \"tableDensityExpanded\", \"tableDensityCompact\", \"tableDensityNormal\", \"tag\", \"tear\", \"temperature\", \"timeline\", \"timelionApp\", \"training\", \"trash\", \"upgradeAssistantApp\", \"uptimeApp\", \"user\", \"users\", \"usersRolesApp\", \"vector\", \"videoPlayer\", \"visArea\", \"visAreaStacked\", \"visBarHorizontal\", \"visBarHorizontalStacked\", \"visBarVertical\", \"visBarVerticalStacked\", \"visGauge\", \"visGoal\", \"visLine\", \"visMapCoordinate\", \"visMapRegion\", \"visMetric\", \"visPie\", \"visTable\", \"visTagCloud\", \"visText\", \"visTimelion\", \"visualizeApp\", \"visVega\", \"visVisualBuilder\", \"watchesApp\", \"wrench\", \"tokenClass\", \"tokenProperty\", \"tokenEnum\", \"tokenVariable\", \"tokenMethod\", \"tokenAnnotation\", \"tokenException\", \"tokenInterface\", \"tokenParameter\", \"tokenField\", \"tokenElement\", \"tokenFunction\", \"tokenBoolean\", \"tokenString\", \"tokenArray\", \"tokenNumber\", \"tokenConstant\", \"tokenObject\", \"tokenEvent\", \"tokenKey\", \"tokenNull\", \"tokenStruct\", \"tokenPackage\", \"tokenOperator\", \"tokenEnumMember\", \"tokenRepo\", \"tokenSymbol\", \"tokenFile\", \"tokenModule\", \"tokenNamespace\", \"tokenDate\", \"tokenIP\", \"tokenNested\", \"tokenAlias\", \"tokenShape\", \"tokenGeo\", \"tokenRange\", \"tokenBinary\", \"tokenJoin\", \"tokenPercolator\", \"tokenFlattened\", \"tokenRankFeature\", \"tokenRankFeatures\", \"tokenKeyword\", \"tokenCompletionSuggester\", \"tokenDenseVector\", \"tokenText\", \"tokenTokenCount\", \"tokenSearchType\", \"tokenHistogram\"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired])"
      },
      "required": false,
      "description": "Adds `EuiIcon` of `EuiIcon.type`"
    },
    "icon": {
      "type": {
        "name": "element"
      },
      "required": false,
      "description": "Custom node to pass as the icon. Cannot be used in conjunction\nwith `iconType`."
    },
    "extraAction": {
      "type": {
        "name": "shape",
        "value": {
          "onClick": {
            "name": "func",
            "required": false
          },
          "iconType": {
            "name": "union",
            "value": [{
              "name": "enum",
              "value": [{
                "value": "\"accessibility\"",
                "computed": false
              }, {
                "value": "\"addDataApp\"",
                "computed": false
              }, {
                "value": "\"advancedSettingsApp\"",
                "computed": false
              }, {
                "value": "\"aggregate\"",
                "computed": false
              }, {
                "value": "\"alert\"",
                "computed": false
              }, {
                "value": "\"annotation\"",
                "computed": false
              }, {
                "value": "\"apmApp\"",
                "computed": false
              }, {
                "value": "\"apmTrace\"",
                "computed": false
              }, {
                "value": "\"apps\"",
                "computed": false
              }, {
                "value": "\"arrowDown\"",
                "computed": false
              }, {
                "value": "\"arrowLeft\"",
                "computed": false
              }, {
                "value": "\"arrowRight\"",
                "computed": false
              }, {
                "value": "\"arrowUp\"",
                "computed": false
              }, {
                "value": "\"asterisk\"",
                "computed": false
              }, {
                "value": "\"auditbeatApp\"",
                "computed": false
              }, {
                "value": "\"beaker\"",
                "computed": false
              }, {
                "value": "\"bell\"",
                "computed": false
              }, {
                "value": "\"bellSlash\"",
                "computed": false
              }, {
                "value": "\"bolt\"",
                "computed": false
              }, {
                "value": "\"boxesHorizontal\"",
                "computed": false
              }, {
                "value": "\"boxesVertical\"",
                "computed": false
              }, {
                "value": "\"branch\"",
                "computed": false
              }, {
                "value": "\"broom\"",
                "computed": false
              }, {
                "value": "\"brush\"",
                "computed": false
              }, {
                "value": "\"bug\"",
                "computed": false
              }, {
                "value": "\"bullseye\"",
                "computed": false
              }, {
                "value": "\"calendar\"",
                "computed": false
              }, {
                "value": "\"canvasApp\"",
                "computed": false
              }, {
                "value": "\"codeApp\"",
                "computed": false
              }, {
                "value": "\"check\"",
                "computed": false
              }, {
                "value": "\"checkInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"cheer\"",
                "computed": false
              }, {
                "value": "\"clock\"",
                "computed": false
              }, {
                "value": "\"cloudDrizzle\"",
                "computed": false
              }, {
                "value": "\"cloudStormy\"",
                "computed": false
              }, {
                "value": "\"cloudSunny\"",
                "computed": false
              }, {
                "value": "\"compute\"",
                "computed": false
              }, {
                "value": "\"console\"",
                "computed": false
              }, {
                "value": "\"consoleApp\"",
                "computed": false
              }, {
                "value": "\"controlsHorizontal\"",
                "computed": false
              }, {
                "value": "\"controlsVertical\"",
                "computed": false
              }, {
                "value": "\"copy\"",
                "computed": false
              }, {
                "value": "\"copyClipboard\"",
                "computed": false
              }, {
                "value": "\"createAdvancedJob\"",
                "computed": false
              }, {
                "value": "\"createMultiMetricJob\"",
                "computed": false
              }, {
                "value": "\"createPopulationJob\"",
                "computed": false
              }, {
                "value": "\"createSingleMetricJob\"",
                "computed": false
              }, {
                "value": "\"cross\"",
                "computed": false
              }, {
                "value": "\"crossClusterReplicationApp\"",
                "computed": false
              }, {
                "value": "\"crosshairs\"",
                "computed": false
              }, {
                "value": "\"crossInACircleFilled\"",
                "computed": false
              }, {
                "value": "\"currency\"",
                "computed": false
              }, {
                "value": "\"cut\"",
                "computed": false
              }, {
                "value": "\"dashboardApp\"",
                "computed": false
              }, {
                "value": "\"database\"",
                "computed": false
              }, {
                "value": "\"dataVisualizer\"",
                "computed": false
              }, {
                "value": "\"devToolsApp\"",
                "computed": false
              }, {
                "value": "\"discoverApp\"",
                "computed": false
              }, {
                "value": "\"document\"",
                "computed": false
              }, {
                "value": "\"documentEdit\"",
                "computed": false
              }, {
                "value": "\"documents\"",
                "computed": false
              }, {
                "value": "\"dot\"",
                "computed": false
              }, {
                "value": "\"download\"",
                "computed": false
              }, {
                "value": "\"editorAlignCenter\"",
                "computed": false
              }, {
                "value": "\"editorAlignLeft\"",
                "computed": false
              }, {
                "value": "\"editorAlignRight\"",
                "computed": false
              }, {
                "value": "\"editorBold\"",
                "computed": false
              }, {
                "value": "\"editorCodeBlock\"",
                "computed": false
              }, {
                "value": "\"editorComment\"",
                "computed": false
              }, {
                "value": "\"editorDistributeHorizontal\"",
                "computed": false
              }, {
                "value": "\"editorDistributeVertical\"",
                "computed": false
              }, {
                "value": "\"editorHeading\"",
                "computed": false
              }, {
                "value": "\"editorItalic\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignLeft\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignBottom\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignCenter\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignMiddle\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignRight\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignTop\"",
                "computed": false
              }, {
                "value": "\"editorLink\"",
                "computed": false
              }, {
                "value": "\"editorOrderedList\"",
                "computed": false
              }, {
                "value": "\"editorPositionBottomLeft\"",
                "computed": false
              }, {
                "value": "\"editorPositionBottomRight\"",
                "computed": false
              }, {
                "value": "\"editorPositionTopLeft\"",
                "computed": false
              }, {
                "value": "\"editorPositionTopRight\"",
                "computed": false
              }, {
                "value": "\"editorRedo\"",
                "computed": false
              }, {
                "value": "\"editorStrike\"",
                "computed": false
              }, {
                "value": "\"editorTable\"",
                "computed": false
              }, {
                "value": "\"editorUnderline\"",
                "computed": false
              }, {
                "value": "\"editorUndo\"",
                "computed": false
              }, {
                "value": "\"editorUnorderedList\"",
                "computed": false
              }, {
                "value": "\"email\"",
                "computed": false
              }, {
                "value": "\"empty\"",
                "computed": false
              }, {
                "value": "\"emsApp\"",
                "computed": false
              }, {
                "value": "\"exit\"",
                "computed": false
              }, {
                "value": "\"expand\"",
                "computed": false
              }, {
                "value": "\"expandMini\"",
                "computed": false
              }, {
                "value": "\"exportAction\"",
                "computed": false
              }, {
                "value": "\"eye\"",
                "computed": false
              }, {
                "value": "\"eyeClosed\"",
                "computed": false
              }, {
                "value": "\"faceHappy\"",
                "computed": false
              }, {
                "value": "\"faceNeutral\"",
                "computed": false
              }, {
                "value": "\"faceSad\"",
                "computed": false
              }, {
                "value": "\"filebeatApp\"",
                "computed": false
              }, {
                "value": "\"filter\"",
                "computed": false
              }, {
                "value": "\"flag\"",
                "computed": false
              }, {
                "value": "\"folderCheck\"",
                "computed": false
              }, {
                "value": "\"folderClosed\"",
                "computed": false
              }, {
                "value": "\"folderExclamation\"",
                "computed": false
              }, {
                "value": "\"folderOpen\"",
                "computed": false
              }, {
                "value": "\"fullScreen\"",
                "computed": false
              }, {
                "value": "\"gear\"",
                "computed": false
              }, {
                "value": "\"gisApp\"",
                "computed": false
              }, {
                "value": "\"glasses\"",
                "computed": false
              }, {
                "value": "\"globe\"",
                "computed": false
              }, {
                "value": "\"grab\"",
                "computed": false
              }, {
                "value": "\"grabHorizontal\"",
                "computed": false
              }, {
                "value": "\"graphApp\"",
                "computed": false
              }, {
                "value": "\"grid\"",
                "computed": false
              }, {
                "value": "\"grokApp\"",
                "computed": false
              }, {
                "value": "\"heart\"",
                "computed": false
              }, {
                "value": "\"heartbeatApp\"",
                "computed": false
              }, {
                "value": "\"heatmap\"",
                "computed": false
              }, {
                "value": "\"help\"",
                "computed": false
              }, {
                "value": "\"home\"",
                "computed": false
              }, {
                "value": "\"iInCircle\"",
                "computed": false
              }, {
                "value": "\"image\"",
                "computed": false
              }, {
                "value": "\"importAction\"",
                "computed": false
              }, {
                "value": "\"indexClose\"",
                "computed": false
              }, {
                "value": "\"indexEdit\"",
                "computed": false
              }, {
                "value": "\"indexFlush\"",
                "computed": false
              }, {
                "value": "\"indexManagementApp\"",
                "computed": false
              }, {
                "value": "\"indexMapping\"",
                "computed": false
              }, {
                "value": "\"indexOpen\"",
                "computed": false
              }, {
                "value": "\"indexPatternApp\"",
                "computed": false
              }, {
                "value": "\"indexRollupApp\"",
                "computed": false
              }, {
                "value": "\"indexSettings\"",
                "computed": false
              }, {
                "value": "\"inputOutput\"",
                "computed": false
              }, {
                "value": "\"inspect\"",
                "computed": false
              }, {
                "value": "\"invert\"",
                "computed": false
              }, {
                "value": "\"ip\"",
                "computed": false
              }, {
                "value": "\"keyboardShortcut\"",
                "computed": false
              }, {
                "value": "\"kqlField\"",
                "computed": false
              }, {
                "value": "\"kqlFunction\"",
                "computed": false
              }, {
                "value": "\"kqlOperand\"",
                "computed": false
              }, {
                "value": "\"kqlSelector\"",
                "computed": false
              }, {
                "value": "\"kqlValue\"",
                "computed": false
              }, {
                "value": "\"lensApp\"",
                "computed": false
              }, {
                "value": "\"link\"",
                "computed": false
              }, {
                "value": "\"list\"",
                "computed": false
              }, {
                "value": "\"listAdd\"",
                "computed": false
              }, {
                "value": "\"lock\"",
                "computed": false
              }, {
                "value": "\"lockOpen\"",
                "computed": false
              }, {
                "value": "\"logsApp\"",
                "computed": false
              }, {
                "value": "\"logoAerospike\"",
                "computed": false
              }, {
                "value": "\"logoApache\"",
                "computed": false
              }, {
                "value": "\"logoAPM\"",
                "computed": false
              }, {
                "value": "\"logoAppSearch\"",
                "computed": false
              }, {
                "value": "\"logoAWS\"",
                "computed": false
              }, {
                "value": "\"logoAWSMono\"",
                "computed": false
              }, {
                "value": "\"logoAzure\"",
                "computed": false
              }, {
                "value": "\"logoAzureMono\"",
                "computed": false
              }, {
                "value": "\"logoBeats\"",
                "computed": false
              }, {
                "value": "\"logoBusinessAnalytics\"",
                "computed": false
              }, {
                "value": "\"logoCeph\"",
                "computed": false
              }, {
                "value": "\"logoCloud\"",
                "computed": false
              }, {
                "value": "\"logoCloudEnterprise\"",
                "computed": false
              }, {
                "value": "\"logoCode\"",
                "computed": false
              }, {
                "value": "\"logoCodesandbox\"",
                "computed": false
              }, {
                "value": "\"logoCouchbase\"",
                "computed": false
              }, {
                "value": "\"logoDocker\"",
                "computed": false
              }, {
                "value": "\"logoDropwizard\"",
                "computed": false
              }, {
                "value": "\"logoElastic\"",
                "computed": false
              }, {
                "value": "\"logoElasticsearch\"",
                "computed": false
              }, {
                "value": "\"logoElasticStack\"",
                "computed": false
              }, {
                "value": "\"logoEnterpriseSearch\"",
                "computed": false
              }, {
                "value": "\"logoEtcd\"",
                "computed": false
              }, {
                "value": "\"logoGCP\"",
                "computed": false
              }, {
                "value": "\"logoGCPMono\"",
                "computed": false
              }, {
                "value": "\"logoGithub\"",
                "computed": false
              }, {
                "value": "\"logoGmail\"",
                "computed": false
              }, {
                "value": "\"logoGolang\"",
                "computed": false
              }, {
                "value": "\"logoGoogleG\"",
                "computed": false
              }, {
                "value": "\"logoHAproxy\"",
                "computed": false
              }, {
                "value": "\"logoIBM\"",
                "computed": false
              }, {
                "value": "\"logoIBMMono\"",
                "computed": false
              }, {
                "value": "\"logoKafka\"",
                "computed": false
              }, {
                "value": "\"logoKibana\"",
                "computed": false
              }, {
                "value": "\"logoKubernetes\"",
                "computed": false
              }, {
                "value": "\"logoLogging\"",
                "computed": false
              }, {
                "value": "\"logoLogstash\"",
                "computed": false
              }, {
                "value": "\"logoMaps\"",
                "computed": false
              }, {
                "value": "\"logoMemcached\"",
                "computed": false
              }, {
                "value": "\"logoMetrics\"",
                "computed": false
              }, {
                "value": "\"logoMongodb\"",
                "computed": false
              }, {
                "value": "\"logoMySQL\"",
                "computed": false
              }, {
                "value": "\"logoNginx\"",
                "computed": false
              }, {
                "value": "\"logoObservability\"",
                "computed": false
              }, {
                "value": "\"logoOsquery\"",
                "computed": false
              }, {
                "value": "\"logoPhp\"",
                "computed": false
              }, {
                "value": "\"logoPostgres\"",
                "computed": false
              }, {
                "value": "\"logoPrometheus\"",
                "computed": false
              }, {
                "value": "\"logoRabbitmq\"",
                "computed": false
              }, {
                "value": "\"logoRedis\"",
                "computed": false
              }, {
                "value": "\"logoSecurity\"",
                "computed": false
              }, {
                "value": "\"logoSiteSearch\"",
                "computed": false
              }, {
                "value": "\"logoSketch\"",
                "computed": false
              }, {
                "value": "\"logoSlack\"",
                "computed": false
              }, {
                "value": "\"logoUptime\"",
                "computed": false
              }, {
                "value": "\"logoWebhook\"",
                "computed": false
              }, {
                "value": "\"logoWindows\"",
                "computed": false
              }, {
                "value": "\"logoWorkplaceSearch\"",
                "computed": false
              }, {
                "value": "\"logstashFilter\"",
                "computed": false
              }, {
                "value": "\"logstashIf\"",
                "computed": false
              }, {
                "value": "\"logstashInput\"",
                "computed": false
              }, {
                "value": "\"logstashOutput\"",
                "computed": false
              }, {
                "value": "\"logstashQueue\"",
                "computed": false
              }, {
                "value": "\"machineLearningApp\"",
                "computed": false
              }, {
                "value": "\"magnet\"",
                "computed": false
              }, {
                "value": "\"magnifyWithMinus\"",
                "computed": false
              }, {
                "value": "\"magnifyWithPlus\"",
                "computed": false
              }, {
                "value": "\"managementApp\"",
                "computed": false
              }, {
                "value": "\"mapMarker\"",
                "computed": false
              }, {
                "value": "\"memory\"",
                "computed": false
              }, {
                "value": "\"menu\"",
                "computed": false
              }, {
                "value": "\"menuLeft\"",
                "computed": false
              }, {
                "value": "\"menuRight\"",
                "computed": false
              }, {
                "value": "\"merge\"",
                "computed": false
              }, {
                "value": "\"metricbeatApp\"",
                "computed": false
              }, {
                "value": "\"metricsApp\"",
                "computed": false
              }, {
                "value": "\"minimize\"",
                "computed": false
              }, {
                "value": "\"minusInCircle\"",
                "computed": false
              }, {
                "value": "\"minusInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"monitoringApp\"",
                "computed": false
              }, {
                "value": "\"moon\"",
                "computed": false
              }, {
                "value": "\"nested\"",
                "computed": false
              }, {
                "value": "\"node\"",
                "computed": false
              }, {
                "value": "\"notebookApp\"",
                "computed": false
              }, {
                "value": "\"number\"",
                "computed": false
              }, {
                "value": "\"offline\"",
                "computed": false
              }, {
                "value": "\"online\"",
                "computed": false
              }, {
                "value": "\"package\"",
                "computed": false
              }, {
                "value": "\"packetbeatApp\"",
                "computed": false
              }, {
                "value": "\"pageSelect\"",
                "computed": false
              }, {
                "value": "\"pagesSelect\"",
                "computed": false
              }, {
                "value": "\"partial\"",
                "computed": false
              }, {
                "value": "\"paperClip\"",
                "computed": false
              }, {
                "value": "\"pause\"",
                "computed": false
              }, {
                "value": "\"pencil\"",
                "computed": false
              }, {
                "value": "\"pin\"",
                "computed": false
              }, {
                "value": "\"pinFilled\"",
                "computed": false
              }, {
                "value": "\"pipelineApp\"",
                "computed": false
              }, {
                "value": "\"play\"",
                "computed": false
              }, {
                "value": "\"plusInCircle\"",
                "computed": false
              }, {
                "value": "\"plusInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"popout\"",
                "computed": false
              }, {
                "value": "\"push\"",
                "computed": false
              }, {
                "value": "\"questionInCircle\"",
                "computed": false
              }, {
                "value": "\"quote\"",
                "computed": false
              }, {
                "value": "\"recentlyViewedApp\"",
                "computed": false
              }, {
                "value": "\"refresh\"",
                "computed": false
              }, {
                "value": "\"reporter\"",
                "computed": false
              }, {
                "value": "\"reportingApp\"",
                "computed": false
              }, {
                "value": "\"save\"",
                "computed": false
              }, {
                "value": "\"savedObjectsApp\"",
                "computed": false
              }, {
                "value": "\"scale\"",
                "computed": false
              }, {
                "value": "\"search\"",
                "computed": false
              }, {
                "value": "\"searchProfilerApp\"",
                "computed": false
              }, {
                "value": "\"securityAnalyticsApp\"",
                "computed": false
              }, {
                "value": "\"securityApp\"",
                "computed": false
              }, {
                "value": "\"securitySignal\"",
                "computed": false
              }, {
                "value": "\"securitySignalDetected\"",
                "computed": false
              }, {
                "value": "\"securitySignalResolved\"",
                "computed": false
              }, {
                "value": "\"shard\"",
                "computed": false
              }, {
                "value": "\"share\"",
                "computed": false
              }, {
                "value": "\"snowflake\"",
                "computed": false
              }, {
                "value": "\"sortable\"",
                "computed": false
              }, {
                "value": "\"sortDown\"",
                "computed": false
              }, {
                "value": "\"sortLeft\"",
                "computed": false
              }, {
                "value": "\"sortRight\"",
                "computed": false
              }, {
                "value": "\"sortUp\"",
                "computed": false
              }, {
                "value": "\"spacesApp\"",
                "computed": false
              }, {
                "value": "\"sqlApp\"",
                "computed": false
              }, {
                "value": "\"starEmpty\"",
                "computed": false
              }, {
                "value": "\"starEmptySpace\"",
                "computed": false
              }, {
                "value": "\"starFilled\"",
                "computed": false
              }, {
                "value": "\"starFilledSpace\"",
                "computed": false
              }, {
                "value": "\"starMinusEmpty\"",
                "computed": false
              }, {
                "value": "\"starMinusFilled\"",
                "computed": false
              }, {
                "value": "\"starPlusEmpty\"",
                "computed": false
              }, {
                "value": "\"starPlusFilled\"",
                "computed": false
              }, {
                "value": "\"stats\"",
                "computed": false
              }, {
                "value": "\"stop\"",
                "computed": false
              }, {
                "value": "\"stopFilled\"",
                "computed": false
              }, {
                "value": "\"stopSlash\"",
                "computed": false
              }, {
                "value": "\"storage\"",
                "computed": false
              }, {
                "value": "\"string\"",
                "computed": false
              }, {
                "value": "\"submodule\"",
                "computed": false
              }, {
                "value": "\"swatchInput\"",
                "computed": false
              }, {
                "value": "\"symlink\"",
                "computed": false
              }, {
                "value": "\"tableOfContents\"",
                "computed": false
              }, {
                "value": "\"tableDensityExpanded\"",
                "computed": false
              }, {
                "value": "\"tableDensityCompact\"",
                "computed": false
              }, {
                "value": "\"tableDensityNormal\"",
                "computed": false
              }, {
                "value": "\"tag\"",
                "computed": false
              }, {
                "value": "\"tear\"",
                "computed": false
              }, {
                "value": "\"temperature\"",
                "computed": false
              }, {
                "value": "\"timeline\"",
                "computed": false
              }, {
                "value": "\"timelionApp\"",
                "computed": false
              }, {
                "value": "\"training\"",
                "computed": false
              }, {
                "value": "\"trash\"",
                "computed": false
              }, {
                "value": "\"upgradeAssistantApp\"",
                "computed": false
              }, {
                "value": "\"uptimeApp\"",
                "computed": false
              }, {
                "value": "\"user\"",
                "computed": false
              }, {
                "value": "\"users\"",
                "computed": false
              }, {
                "value": "\"usersRolesApp\"",
                "computed": false
              }, {
                "value": "\"vector\"",
                "computed": false
              }, {
                "value": "\"videoPlayer\"",
                "computed": false
              }, {
                "value": "\"visArea\"",
                "computed": false
              }, {
                "value": "\"visAreaStacked\"",
                "computed": false
              }, {
                "value": "\"visBarHorizontal\"",
                "computed": false
              }, {
                "value": "\"visBarHorizontalStacked\"",
                "computed": false
              }, {
                "value": "\"visBarVertical\"",
                "computed": false
              }, {
                "value": "\"visBarVerticalStacked\"",
                "computed": false
              }, {
                "value": "\"visGauge\"",
                "computed": false
              }, {
                "value": "\"visGoal\"",
                "computed": false
              }, {
                "value": "\"visLine\"",
                "computed": false
              }, {
                "value": "\"visMapCoordinate\"",
                "computed": false
              }, {
                "value": "\"visMapRegion\"",
                "computed": false
              }, {
                "value": "\"visMetric\"",
                "computed": false
              }, {
                "value": "\"visPie\"",
                "computed": false
              }, {
                "value": "\"visTable\"",
                "computed": false
              }, {
                "value": "\"visTagCloud\"",
                "computed": false
              }, {
                "value": "\"visText\"",
                "computed": false
              }, {
                "value": "\"visTimelion\"",
                "computed": false
              }, {
                "value": "\"visualizeApp\"",
                "computed": false
              }, {
                "value": "\"visVega\"",
                "computed": false
              }, {
                "value": "\"visVisualBuilder\"",
                "computed": false
              }, {
                "value": "\"watchesApp\"",
                "computed": false
              }, {
                "value": "\"wrench\"",
                "computed": false
              }, {
                "value": "\"tokenClass\"",
                "computed": false
              }, {
                "value": "\"tokenProperty\"",
                "computed": false
              }, {
                "value": "\"tokenEnum\"",
                "computed": false
              }, {
                "value": "\"tokenVariable\"",
                "computed": false
              }, {
                "value": "\"tokenMethod\"",
                "computed": false
              }, {
                "value": "\"tokenAnnotation\"",
                "computed": false
              }, {
                "value": "\"tokenException\"",
                "computed": false
              }, {
                "value": "\"tokenInterface\"",
                "computed": false
              }, {
                "value": "\"tokenParameter\"",
                "computed": false
              }, {
                "value": "\"tokenField\"",
                "computed": false
              }, {
                "value": "\"tokenElement\"",
                "computed": false
              }, {
                "value": "\"tokenFunction\"",
                "computed": false
              }, {
                "value": "\"tokenBoolean\"",
                "computed": false
              }, {
                "value": "\"tokenString\"",
                "computed": false
              }, {
                "value": "\"tokenArray\"",
                "computed": false
              }, {
                "value": "\"tokenNumber\"",
                "computed": false
              }, {
                "value": "\"tokenConstant\"",
                "computed": false
              }, {
                "value": "\"tokenObject\"",
                "computed": false
              }, {
                "value": "\"tokenEvent\"",
                "computed": false
              }, {
                "value": "\"tokenKey\"",
                "computed": false
              }, {
                "value": "\"tokenNull\"",
                "computed": false
              }, {
                "value": "\"tokenStruct\"",
                "computed": false
              }, {
                "value": "\"tokenPackage\"",
                "computed": false
              }, {
                "value": "\"tokenOperator\"",
                "computed": false
              }, {
                "value": "\"tokenEnumMember\"",
                "computed": false
              }, {
                "value": "\"tokenRepo\"",
                "computed": false
              }, {
                "value": "\"tokenSymbol\"",
                "computed": false
              }, {
                "value": "\"tokenFile\"",
                "computed": false
              }, {
                "value": "\"tokenModule\"",
                "computed": false
              }, {
                "value": "\"tokenNamespace\"",
                "computed": false
              }, {
                "value": "\"tokenDate\"",
                "computed": false
              }, {
                "value": "\"tokenIP\"",
                "computed": false
              }, {
                "value": "\"tokenNested\"",
                "computed": false
              }, {
                "value": "\"tokenAlias\"",
                "computed": false
              }, {
                "value": "\"tokenShape\"",
                "computed": false
              }, {
                "value": "\"tokenGeo\"",
                "computed": false
              }, {
                "value": "\"tokenRange\"",
                "computed": false
              }, {
                "value": "\"tokenBinary\"",
                "computed": false
              }, {
                "value": "\"tokenJoin\"",
                "computed": false
              }, {
                "value": "\"tokenPercolator\"",
                "computed": false
              }, {
                "value": "\"tokenFlattened\"",
                "computed": false
              }, {
                "value": "\"tokenRankFeature\"",
                "computed": false
              }, {
                "value": "\"tokenRankFeatures\"",
                "computed": false
              }, {
                "value": "\"tokenKeyword\"",
                "computed": false
              }, {
                "value": "\"tokenCompletionSuggester\"",
                "computed": false
              }, {
                "value": "\"tokenDenseVector\"",
                "computed": false
              }, {
                "value": "\"tokenText\"",
                "computed": false
              }, {
                "value": "\"tokenTokenCount\"",
                "computed": false
              }, {
                "value": "\"tokenSearchType\"",
                "computed": false
              }, {
                "value": "\"tokenHistogram\"",
                "computed": false
              }]
            }, {
              "name": "string"
            }, {
              "name": "elementType"
            }],
            "required": false
          },
          "color": {
            "name": "enum",
            "value": [{
              "value": "\"danger\"",
              "computed": false
            }, {
              "value": "\"disabled\"",
              "computed": false
            }, {
              "value": "\"ghost\"",
              "computed": false
            }, {
              "value": "\"primary\"",
              "computed": false
            }, {
              "value": "\"subdued\"",
              "computed": false
            }, {
              "value": "\"success\"",
              "computed": false
            }, {
              "value": "\"text\"",
              "computed": false
            }, {
              "value": "\"warning\"",
              "computed": false
            }],
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "aria-labelledby": {
            "name": "string",
            "required": false
          },
          "isDisabled": {
            "name": "bool",
            "required": false
          },
          "size": {
            "name": "enum",
            "value": [{
              "value": "\"s\"",
              "computed": false
            }, {
              "value": "\"m\"",
              "computed": false
            }],
            "required": false
          },
          "iconSize": {
            "name": "enum",
            "value": [{
              "value": "\"original\"",
              "computed": false
            }, {
              "value": "\"s\"",
              "computed": false
            }, {
              "value": "\"m\"",
              "computed": false
            }, {
              "value": "\"l\"",
              "computed": false
            }, {
              "value": "\"xl\"",
              "computed": false
            }, {
              "value": "\"xxl\"",
              "computed": false
            }],
            "required": false
          },
          "className": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "buttonRef": {
            "name": "any",
            "required": false
          },
          "alwaysShow": {
            "name": "bool",
            "required": false
          }
        }
      },
      "required": false,
      "description": "Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;\npass `alwaysShow` if you don't want the default behavior of only showing on hover"
    },
    "onClick": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Make the list item label a button.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems."
    },
    "wrapText": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Allow link text to wrap"
    },
    "buttonRef": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Pass-through ref reference specifically for targeting\ninstances where the item content is rendered as a `button`"
    }
  }
};