/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
var responsiveSizesToClassNameMap = {
  xs: 'eui-showFor--xs',
  s: 'eui-showFor--s',
  m: 'eui-showFor--m',
  l: 'eui-showFor--l',
  xl: 'eui-showFor--xl'
};
export var EuiShowFor = function EuiShowFor(_ref) {
  var children = _ref.children,
      sizes = _ref.sizes,
      display = _ref.display;
  var utilityClasses = sizes.map(function (item) {
    var append = display ? "--".concat(display) : '';
    return "".concat(responsiveSizesToClassNameMap[item]).concat(append);
  });

  if (React.isValidElement(children)) {
    return React.createElement(React.Fragment, null, React.Children.map(children, function (child) {
      return React.cloneElement(child, {
        className: classNames(child.props.className, utilityClasses)
      });
    }));
  } else {
    return React.createElement("span", {
      className: classNames(utilityClasses)
    }, children);
  }
};
EuiShowFor.propTypes = {
  children: PropTypes.node,

  /**
     * List of all the responsive sizes to show the children for.
     * Options are `'xs' | 's' | 'm' | 'l' | 'xl'`
     */
  sizes: PropTypes.arrayOf(PropTypes.oneOf(["xs", "s", "m", "l", "xl"]).isRequired).isRequired,

  /**
     * Optional display as property. Leaving as `undefined` renders as `inline`.
     */
  display: PropTypes.oneOf(["block", "inlineBlock", "flex"])
};
EuiShowFor.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiShowFor",
  "props": {
    "children": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "sizes": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "enum",
          "value": [{
            "value": "\"xs\"",
            "computed": false
          }, {
            "value": "\"s\"",
            "computed": false
          }, {
            "value": "\"m\"",
            "computed": false
          }, {
            "value": "\"l\"",
            "computed": false
          }, {
            "value": "\"xl\"",
            "computed": false
          }]
        }
      },
      "required": true,
      "description": "List of all the responsive sizes to show the children for.\nOptions are `'xs' | 's' | 'm' | 'l' | 'xl'`"
    },
    "display": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"block\"",
          "computed": false
        }, {
          "value": "\"inlineBlock\"",
          "computed": false
        }, {
          "value": "\"flex\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Optional display as property. Leaving as `undefined` renders as `inline`."
    }
  }
};