/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.versionmapping;

import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;

public class DefaultVariantVersionMappingStrategy
implements VariantVersionMappingStrategyInternal {
    private final ConfigurationContainer configurations;
    private boolean usePublishedVersions;
    private Configuration targetConfiguration;

    public DefaultVariantVersionMappingStrategy(ConfigurationContainer configurations) {
        this.configurations = configurations;
    }

    @Override
    public void fromResolutionResult() {
        this.usePublishedVersions = true;
    }

    @Override
    public void fromResolutionOf(Configuration configuration) {
        this.usePublishedVersions = true;
        this.targetConfiguration = configuration;
    }

    @Override
    public void fromResolutionOf(String configurationName) {
        this.fromResolutionOf(this.configurations.getByName(configurationName));
    }

    @Override
    public ModuleVersionIdentifier maybeResolveVersion(String group, String module) {
        if (this.usePublishedVersions && this.targetConfiguration != null) {
            ResolutionResult resolutionResult = this.targetConfiguration.getIncoming().getResolutionResult();
            Set resolvedComponentResults = resolutionResult.getAllComponents();
            for (ResolvedComponentResult selected : resolvedComponentResults) {
                ModuleVersionIdentifier moduleVersion = selected.getModuleVersion();
                if (moduleVersion == null || !group.equals(moduleVersion.getGroup()) || !module.equals(moduleVersion.getName())) continue;
                return moduleVersion;
            }
            Set allDependencies = resolutionResult.getAllDependencies();
            for (DependencyResult dependencyResult : allDependencies) {
                ModuleComponentSelector requested;
                if (!(dependencyResult instanceof ResolvedDependencyResult) || !(dependencyResult.getRequested() instanceof ModuleComponentSelector) || !(requested = (ModuleComponentSelector)dependencyResult.getRequested()).getGroup().equals(group) || !requested.getModule().equals(module)) continue;
                return ((ResolvedDependencyResult)dependencyResult).getSelected().getModuleVersion();
            }
        }
        return null;
    }

    public void setTargetConfiguration(Configuration target) {
        this.targetConfiguration = target;
    }
}

