/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.ProjectDataActionContext;
import ghidra.framework.main.datatable.ProjectDataContextAction;
import ghidra.framework.main.datatable.ProjectDataTableModel;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import resources.ResourceManager;

public class ProjectDataRenameAction
extends ProjectDataContextAction {
    private static Icon icon = ResourceManager.loadImage((String)"images/page_edit.png");

    public ProjectDataRenameAction(String owner, String group) {
        super("Rename", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Rename"}, icon, group));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(ProjectDataActionContext context) {
        Component component;
        if (context.getFileCount() == 1) {
            DomainFile file = context.getSelectedFiles().get(0);
            if (file.isCheckedOut()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponent(), (String)"Rename Not Allowed", (Object)"Can't rename a file that is checked out!");
                return;
            }
            if (!file.getConsumers().isEmpty() || file.isBusy()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponent(), (String)"Rename Not Allowed", (Object)"Can't rename a file that is open!");
                return;
            }
        }
        if ((component = context.getComponent()) instanceof DataTree) {
            DataTree tree = (DataTree)((Object)component);
            GTreeNode node = (GTreeNode)context.getContextObject();
            tree.setEditable(true);
            tree.startEditing(node.getParent(), node.getName());
        } else if (component instanceof GFilterTable) {
            GFilterTable filterTable = (GFilterTable)component;
            DomainFileInfo info = (DomainFileInfo)context.getContextObject();
            ProjectDataTableModel model = (ProjectDataTableModel)filterTable.getModel();
            List modelData = model.getModelData();
            int indexOf = modelData.indexOf(info);
            if (indexOf >= 0) {
                model.setEditing(true);
                filterTable.getTable().editCellAt(indexOf, this.findNameColumn(filterTable.getTable()));
                model.setEditing(false);
            }
        }
    }

    private int findNameColumn(GTable table) {
        TableColumnModel model = table.getColumnModel();
        int columnCount = model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            TableColumn column = model.getColumn(col);
            if (!"Name".equals(column.getHeaderValue().toString())) continue;
            return col;
        }
        return 0;
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataActionContext context) {
        DomainFolder folder;
        DomainFile file;
        if (!context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        if (context.getFileCount() == 1 ? (file = context.getSelectedFiles().get(0)).isReadOnly() : (folder = context.getSelectedFolders().get(0)).getParent() == null) {
            return false;
        }
        return !context.isReadOnlyProject();
    }
}

