/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class CopyFileVersionTask
extends Task {
    private final DomainFile file;
    private final int version;
    private final DomainFolder destFolder;

    CopyFileVersionTask(DomainFile file, int version, DomainFolder destFolder) {
        super("Copy File Version", true, true, true);
        this.file = file;
        this.version = version;
        this.destFolder = destFolder;
    }

    public void run(TaskMonitor monitor) {
        try {
            monitor.setMessage("Copying " + this.file.getName() + " version " + this.version + "...");
            if (this.file.copyVersionTo(this.version, this.destFolder, monitor) == null) {
                Msg.showError((Object)((Object)this), null, (String)"Version Copy Failed", (Object)"Failed to copy file version");
            }
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)AppInfo.getActiveProject().getRepository(), (Exception)e, (String)"Version Copy", null);
        }
    }
}

