/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.tar;

import ghidra.file.formats.tar.TarFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

@FileSystemInfo(type="tar", description="TAR", priority=10, factory=TarFileSystemFactory.class)
public class TarFileSystem
implements GFileSystem {
    private FSRLRoot fsrl;
    private FileSystemService fsService;
    private File containerFile;
    private FileSystemIndexHelper<TarMetadata> fsih;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private int fileCount;

    public TarFileSystem(File file, FSRLRoot fsrl, FileSystemService fsService) {
        this.fsrl = fsrl;
        this.fsih = new FileSystemIndexHelper((GFileSystem)this, fsrl);
        this.containerFile = file;
        this.fsService = fsService;
    }

    void mount(boolean precache, TaskMonitor monitor) throws IOException, CancelledException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new FileInputStream(this.containerFile));){
            TarArchiveEntry tarEntry;
            while ((tarEntry = tarInput.getNextTarEntry()) != null) {
                monitor.setMessage(tarEntry.getName());
                monitor.checkCanceled();
                GFileImpl newFile = this.fsih.storeFile(tarEntry.getName(), this.fileCount, tarEntry.isDirectory(), tarEntry.getSize(), (Object)new TarMetadata(tarEntry, this.fileCount));
                ++this.fileCount;
                if (!precache) continue;
                FileCacheEntry fce = this.fsService.addFileToCache((GFile)newFile, (InputStream)tarInput, monitor);
                newFile.setFSRL(newFile.getFSRL().withMD5(fce.md5));
            }
        }
    }

    public File getRawContainerFile() {
        return this.containerFile;
    }

    public String getName() {
        return this.fsrl.getContainer().getName();
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsih.clear();
        this.containerFile = null;
    }

    public boolean isClosed() {
        return this.containerFile == null;
    }

    public FSRLRoot getFSRL() {
        return this.fsrl;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public Map<String, String> getInfoMap(TarArchiveEntry blob) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Name", blob.getName());
        info.put("Mode", Integer.toUnsignedString(blob.getMode(), 8));
        info.put("Size", Long.toString(blob.getSize()));
        info.put("Date", blob.getLastModifiedDate().toString());
        info.put("User/Group", blob.getUserName() + " / " + blob.getGroupName());
        info.put("UserId/GroupId", blob.getUserId() + " / " + blob.getGroupId());
        return info;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsih.lookup(path);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        TarArchiveEntry tarEntry;
        TarMetadata tmd = (TarMetadata)this.fsih.getMetadata(file);
        if (tmd == null) {
            throw new IOException("Unknown file " + file);
        }
        TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new FileInputStream(this.containerFile));
        int fileNum = 0;
        while ((tarEntry = tarInput.getNextTarEntry()) != null) {
            if (fileNum == tmd.fileNum) {
                if (!tmd.tarArchiveEntry.getName().equals(tarEntry.getName())) {
                    throw new IOException("Mismatch between filenum and tarEntry for " + file);
                }
                return tarInput;
            }
            ++fileNum;
        }
        throw new IOException("Could not find requested file " + file);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsih.getListing(directory);
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        TarMetadata tmd = (TarMetadata)this.fsih.getMetadata(file);
        return tmd != null ? FSUtilities.infoMapToString(this.getInfoMap(tmd.tarArchiveEntry)) : null;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    private static class TarMetadata {
        TarArchiveEntry tarArchiveEntry;
        int fileNum;

        TarMetadata(TarArchiveEntry tae, int fileNum) {
            this.tarArchiveEntry = tae;
            this.fileNum = fileNum;
        }
    }
}

