/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

class IntObjectCache {
    private MySoftRef[] values;
    private ReferenceQueue<Object> refQueue;

    IntObjectCache(int size) {
        try {
            this.values = new MySoftRef[size];
            this.refQueue = new ReferenceQueue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void put(int index, Object obj) {
        if (this.values != null) {
            this.removeStaleEntries();
            this.values[index] = new MySoftRef(index, obj, this.refQueue);
        }
    }

    Object get(int index) {
        if (this.values != null) {
            this.removeStaleEntries();
            if (this.values[index] != null) {
                return this.values[index].get();
            }
        }
        return null;
    }

    private void removeStaleEntries() {
        Reference<Object> r;
        while ((r = this.refQueue.poll()) != null) {
            MySoftRef e = (MySoftRef)r;
            this.values[e.index] = null;
        }
    }

    private static class MySoftRef
    extends SoftReference<Object> {
        int index;

        MySoftRef(int index, Object obj, ReferenceQueue<Object> refQueue) {
            super(obj, refQueue);
            this.index = index;
        }
    }
}

