/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.archive;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class LongNamesMember
implements StructConverter {
    private static final String LONGNAME_STR_TERM_CHARS = "\u0000\n";
    private int _nStrings;
    private long _fileOffset;
    private List<Integer> lengths = new ArrayList<Integer>();

    public LongNamesMember(BinaryReader reader, CoffArchiveMemberHeader header) throws IOException {
        long tmpOffset = this._fileOffset = reader.getPointerIndex();
        long endOfStrings = tmpOffset + header.getSize();
        reader.setPointerIndex(endOfStrings);
        while (tmpOffset < endOfStrings) {
            String s = reader.readTerminatedString(tmpOffset, LONGNAME_STR_TERM_CHARS);
            tmpOffset += (long)(s.length() + 1);
            ++this._nStrings;
            this.lengths.add(s.length() + 1);
        }
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public String getStringAtOffset(ByteProvider provider, long offset) throws IOException {
        BinaryReader reader = new BinaryReader(provider, false);
        return reader.readTerminatedString(this._fileOffset + offset, LONGNAME_STR_TERM_CHARS);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(LongNamesMember.class);
        String uniqueName = name + "_" + this._nStrings;
        StructureDataType struct = new StructureDataType(uniqueName, 0);
        for (int i = 0; i < this._nStrings; ++i) {
            struct.add(STRING, this.lengths.get(i).intValue(), "string[" + i + "]", null);
        }
        return struct;
    }

    public String findName(ByteProvider provider, CoffArchiveMemberHeader archiveMemberHeader) throws IOException {
        String nm = archiveMemberHeader.getName();
        if (nm.startsWith("/")) {
            try {
                int offset = Integer.parseInt(nm.substring(1));
                nm = this.getStringAtOffset(provider, offset);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (nm.endsWith("/")) {
            nm = nm.substring(0, nm.length() - 1);
        }
        return nm;
    }
}

