/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.AddRemoveListItem;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableSortingContext;
import docking.widgets.table.threaded.TableData;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Algorithms;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;

public class TableUpdateJob<T> {
    private ThreadedTableModel<T, ?> model;
    private TaskMonitor monitor;
    private TableData<T> sourceData;
    private TableData<T> updatedData;
    private boolean disableSubFiltering = SystemUtilities.getBooleanProperty((String)"tables.subfilter.disabled", (boolean)false);
    private volatile boolean reloadData;
    private volatile boolean doForceSort;
    private volatile boolean doForceFilter = true;
    private volatile TableSortingContext<T> newSortContext;
    private TableSortingContext<T> lastSortContext;
    protected List<AddRemoveListItem<T>> addRemoveList = new ArrayList<AddRemoveListItem<T>>();
    private volatile JobState currentState;
    private volatile JobState pendingRequestedState;
    private List<JobState> debugStateHistory = new ArrayList<JobState>();
    private volatile boolean isFired;

    TableUpdateJob(ThreadedTableModel<T, ?> model, TaskMonitor taskMonitor) {
        this.model = model;
        this.monitor = taskMonitor;
        this.setState(JobState.NOT_RUNNING);
    }

    protected void setData(TableData<T> data) {
        this.sourceData = data;
    }

    protected void setForceFilter(boolean force) {
        this.doForceFilter = force;
    }

    public void run() {
        this.gotoNextState();
        while (this.currentState != JobState.DONE) {
            block4: {
                try {
                    this.processState(this.currentState);
                }
                catch (CancelledException cancelledException) {
                }
                catch (Exception e) {
                    if (this.isFired) break block4;
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    break;
                }
            }
            this.gotoNextState();
        }
    }

    public synchronized void reload() {
        if (this.currentState != JobState.NOT_RUNNING) {
            throw new IllegalStateException("Cannot reload once a job starts");
        }
        this.isFired = false;
        this.reloadData = true;
        this.addRemoveList.clear();
        if (this.newSortContext == null) {
            this.newSortContext = this.model.getSortingContext();
        }
    }

    public synchronized void addRemove(AddRemoveListItem<T> item, int maxAddRemoveCount) {
        if (this.currentState != JobState.NOT_RUNNING) {
            throw new IllegalStateException("Cannot add or remove once a job starts");
        }
        if (this.reloadData) {
            return;
        }
        if (this.addRemoveList.size() > maxAddRemoveCount) {
            this.reload();
            return;
        }
        this.addRemoveList.add(item);
    }

    public synchronized boolean requestSort(TableSortingContext<T> newSortingContext, boolean forceSort) {
        if (this.currentState == JobState.DONE) {
            return false;
        }
        this.doForceSort = forceSort;
        this.newSortContext = newSortingContext;
        if (this.hasSorted()) {
            this.monitor.cancel();
            this.pendingRequestedState = JobState.SORTING;
        }
        return true;
    }

    public synchronized boolean requestFilter() {
        if (this.currentState == JobState.DONE) {
            return false;
        }
        if (this.hasFiltered()) {
            this.monitor.cancel();
            this.pendingRequestedState = JobState.FILTERING;
        }
        return true;
    }

    private boolean hasSorted() {
        return this.currentState.compareTo(JobState.SORTING) >= 0;
    }

    private boolean hasFiltered() {
        return this.currentState.compareTo(JobState.FILTERING) >= 0;
    }

    private synchronized void gotoNextState() {
        if (this.monitor.isCancelled()) {
            if (this.pendingRequestedState != null) {
                this.setState(this.pendingRequestedState);
                this.pendingRequestedState = null;
                this.monitor.clearCanceled();
            } else {
                this.setState(JobState.DONE);
            }
        } else {
            this.setState(this.getNextState(this.currentState));
        }
    }

    private void setState(JobState state) {
        this.debugStateHistory.add(state);
        this.currentState = state;
    }

    private JobState getNextState(JobState state) {
        switch (state) {
            case NOT_RUNNING: {
                return JobState.LOADING;
            }
            case LOADING: {
                return JobState.FILTERING;
            }
            case FILTERING: {
                return JobState.ADD_REMOVING;
            }
            case ADD_REMOVING: {
                return JobState.SORTING;
            }
            case SORTING: {
                return JobState.APPLYING;
            }
        }
        return JobState.DONE;
    }

    private void processState(JobState state) throws CancelledException {
        switch (state) {
            case LOADING: {
                this.loadData();
                break;
            }
            case FILTERING: {
                this.doFilterData();
                break;
            }
            case ADD_REMOVING: {
                this.doProcessAddRemoves();
                break;
            }
            case SORTING: {
                this.sortData();
                break;
            }
            case APPLYING: {
                this.applyData();
                break;
            }
        }
    }

    private void loadData() throws CancelledException {
        this.monitor.setMessage("Loading " + this.model.getName() + "...");
        if (this.reloadData) {
            List<T> newData = this.model.load(this.monitor);
            this.sourceData = TableData.createFullDataset(newData);
        } else if (this.sourceData == null) {
            this.sourceData = this.pickExistingTableData();
            this.lastSortContext = this.sourceData.getSortContext();
        }
        this.monitor.setMessage("Done loading");
    }

    private TableData<T> pickExistingTableData() {
        if (this.disableSubFiltering) {
            return this.model.getAllTableData();
        }
        TableData<T> startSourceData = this.getReusableFilteredData();
        if (startSourceData == null) {
            startSourceData = this.model.getAllTableData();
        }
        TableData<T> copy = startSourceData.copy();
        return copy;
    }

    private TableData<T> getReusableFilteredData() {
        TableData<T> currentAppliedData;
        TableData<T> allTableData = this.model.getAllTableData();
        if (allTableData == (currentAppliedData = this.model.getCurrentTableData())) {
            return null;
        }
        if (currentAppliedData.isUnrelatedTo(allTableData)) {
            return null;
        }
        TableFilter<T> appliedOrPendingFilter = this.model.getTableFilter();
        TableData<T> alreadyFilteredData = currentAppliedData.getLowestLevelSourceDataForFilter(appliedOrPendingFilter);
        return alreadyFilteredData;
    }

    private boolean needsSorting() {
        if (this.doForceSort) {
            return true;
        }
        if (this.hasNewSort()) {
            return true;
        }
        if (this.tableSortDiffersFromSourceData()) {
            this.newSortContext = this.model.getSortingContext();
            return true;
        }
        return false;
    }

    private boolean hasNewSort() {
        if (this.newSortContext == null) {
            return false;
        }
        return !this.newSortContext.equals(this.lastSortContext);
    }

    private boolean tableSortDiffersFromSourceData() {
        return !SystemUtilities.isEqual(this.sourceData.getSortContext(), this.model.getSortingContext());
    }

    private boolean isCurrentSortReversable() {
        if (this.lastSortContext == null || this.doForceSort) {
            return false;
        }
        return this.lastSortContext.isReverseOf(this.newSortContext);
    }

    private void sortData() {
        if (!this.needsSorting()) {
            return;
        }
        List<T> sortData = this.updatedData.getData();
        if (this.isCurrentSortReversable()) {
            Collections.reverse(sortData);
        } else {
            this.initializeSortCache();
            this.maybeSortSourceData();
            this.doSortData(sortData);
            this.clearSortCache();
        }
        this.lastSortContext = this.monitor.isCancelled() ? null : this.newSortContext;
        this.updatedData.setSortContext(this.lastSortContext);
    }

    private void doSortData(List<T> data) {
        if (this.newSortContext.isUnsorted()) {
            return;
        }
        int size = data.size();
        this.monitor.setMessage("Sorting " + this.model.getName() + " (" + size + " rows)...");
        this.monitor.initialize((long)size);
        Comparator<T> comparator = this.newSortContext.getComparator();
        Algorithms.mergeSort(data, comparator, (TaskMonitor)this.monitor);
        this.monitor.setMessage("Done sorting");
    }

    private void maybeSortSourceData() {
        if (this.sourceData == this.updatedData) {
            return;
        }
        if (this.sourceData.isSorted()) {
            return;
        }
        this.doSortData(this.sourceData.getData());
        if (this.monitor.isCancelled()) {
            this.sourceData.setSortContext(null);
        } else {
            this.sourceData.setSortContext(this.newSortContext);
        }
    }

    private void doProcessAddRemoves() throws CancelledException {
        int n = this.addRemoveList.size();
        this.monitor.setMessage("Adding/Removing " + n + " items...");
        this.monitor.initialize((long)n);
        this.initializeSortCache();
        for (int i = 0; i < n; ++i) {
            AddRemoveListItem<T> item = this.addRemoveList.get(i);
            T value = item.getValue();
            if (item.isChange()) {
                this.updatedData.remove(value);
                this.updatedData.insert(value);
            } else if (item.isRemove()) {
                this.updatedData.remove(value);
            } else if (item.isAdd()) {
                this.updatedData.insert(value);
            }
            this.monitor.checkCanceled();
            this.monitor.setProgress((long)i);
        }
        this.monitor.setMessage("Done adding/removing");
        this.clearSortCache();
    }

    private void initializeSortCache() {
        this.model.initializeCache();
    }

    private void clearSortCache() {
        this.model.clearCache();
    }

    private void doFilterData() throws CancelledException {
        if (this.canReuseCurrentFilteredData()) {
            this.copyCurrentFilterData();
            return;
        }
        TableData<T> filterSourceData = this.sourceData;
        int size = filterSourceData.size();
        this.monitor.setMessage("Filtering " + this.model.getName() + " (" + size + " rows)...");
        List<T> list = filterSourceData.getData();
        List<T> result = this.model.doFilter(list, this.lastSortContext, this.monitor);
        if (result == list) {
            this.updatedData = filterSourceData;
        } else {
            TableSortingContext<T> sortContext = filterSourceData.getSortContext();
            this.updatedData = TableData.createSubDataset(filterSourceData, result, sortContext);
            this.updatedData.setTableFilter(this.model.getTableFilter());
        }
        this.monitor.setMessage("Done filtering " + this.model.getName() + " (" + this.updatedData.size() + " rows)");
    }

    private void copyCurrentFilterData() {
        TableData<T> currentFilteredData = this.getCurrentFilteredData();
        this.updatedData = currentFilteredData.copy(this.sourceData);
        this.lastSortContext = this.updatedData.getSortContext();
    }

    private boolean canReuseCurrentFilteredData() {
        if (this.doForceFilter) {
            return false;
        }
        TableData<T> currentTableData = this.getCurrentFilteredData();
        TableFilter<T> appliedOrPendingFilter = this.model.getTableFilter();
        if (currentTableData.isUnrelatedTo(this.sourceData)) {
            return false;
        }
        return currentTableData.matchesFilter(appliedOrPendingFilter);
    }

    private TableData<T> getCurrentFilteredData() {
        TableData<T> currentData = this.model.getCurrentTableData();
        return currentData;
    }

    private void applyData() {
        TableData<T> allData = this.sourceData.getRootData();
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.isFired) {
                    return;
                }
                this.model.setModelState(allData, this.updatedData);
            });
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public synchronized void cancel() {
        this.isFired = true;
        this.pendingRequestedState = JobState.DONE;
        this.monitor.cancel();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - [state history=\n" + this.getStateHistoryString() + "]";
    }

    private String getStateHistoryString() {
        StringBuilder buffy = new StringBuilder();
        for (JobState state : this.debugStateHistory) {
            buffy.append('\t').append((Object)state).append('\n');
        }
        return buffy.toString();
    }

    static enum JobState {
        NOT_RUNNING,
        LOADING,
        FILTERING,
        ADD_REMOVING,
        SORTING,
        APPLYING,
        DONE;

    }
}

