/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.json;

import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class JsonDateReader {
    public static final JsonReader<Date> Dropbox = new JsonReader<Date>(){

        @Override
        public Date read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation l = parser.getCurrentLocation();
            try {
                char[] buffer = parser.getTextCharacters();
                int offset = parser.getTextOffset();
                int length = parser.getTextLength();
                Date d = JsonDateReader.parseDropboxDate(buffer, offset, length);
                parser.nextToken();
                return d;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson((JsonProcessingException)ex);
            }
            catch (ParseException ex) {
                throw new JsonReadException("bad date: \"" + ex.getMessage() + " at offset " + ex.getErrorOffset(), l);
            }
        }
    };
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static Date parseDropboxDate(char[] buffer, int offset, int length) throws ParseException {
        int i = offset;
        char[] b = buffer;
        if (length != 31) {
            throw new ParseException("expecting date to be 31 characters, got " + length, 0);
        }
        if (b.length < i + 31 || i < 0) {
            throw new IllegalArgumentException("range is not within 'b'");
        }
        if (b[i + 3] != ',' | b[i + 4] != ' ' | b[i + 7] != ' ' | b[i + 11] != ' ' | b[i + 16] != ' ' | b[i + 19] != ':' | b[i + 22] != ':' | b[i + 25] != ' ' | b[i + 26] != '+' | b[i + 27] != '0' | b[i + 28] != '0' | b[i + 29] != '0' | b[i + 30] != '0') {
            if (b[i + 3] != ',') {
                throw new ParseException("expecting ','", 3);
            }
            if (b[i + 4] != ' ') {
                throw new ParseException("expecting ' '", 4);
            }
            if (b[i + 7] != ' ') {
                throw new ParseException("expecting ' '", 7);
            }
            if (b[i + 11] != ' ') {
                throw new ParseException("expecting ' '", 11);
            }
            if (b[i + 16] != ' ') {
                throw new ParseException("expecting ' '", 16);
            }
            if (b[i + 19] != ':') {
                throw new ParseException("expecting ':'", 19);
            }
            if (b[i + 22] != ':') {
                throw new ParseException("expecting ':'", 22);
            }
            if (b[i + 25] != ' ') {
                throw new ParseException("expecting ' '", 25);
            }
            if (b[i + 26] != '+') {
                throw new ParseException("expecting '+'", 26);
            }
            if (b[i + 27] != '0') {
                throw new ParseException("expecting '0'", 27);
            }
            if (b[i + 28] != '0') {
                throw new ParseException("expecting '0'", 28);
            }
            if (b[i + 29] != '0') {
                throw new ParseException("expecting '0'", 29);
            }
            if (b[i + 30] != '0') {
                throw new ParseException("expecting '0'", 30);
            }
            throw new AssertionError((Object)"unreachable");
        }
        if (!JsonDateReader.isValidDayOfWeek(b[i], b[i + 1], b[i + 2])) {
            throw new ParseException("invalid day of week", i);
        }
        int month = JsonDateReader.getMonthIndex(b[i + 8], b[i + 9], b[i + 10]);
        if (month == -1) {
            throw new ParseException("invalid month", 8);
        }
        char d1 = b[i + 5];
        char d2 = b[i + 6];
        if (!JsonDateReader.isDigit(d1) || !JsonDateReader.isDigit(d2)) {
            throw new ParseException("invalid day of month", 5);
        }
        int dayOfMonth = d1 * 10 + d2 - 528;
        char y1 = b[i + 12];
        char y2 = b[i + 13];
        char y3 = b[i + 14];
        char y4 = b[i + 15];
        if (!JsonDateReader.isDigit(y1) | !JsonDateReader.isDigit(y2) | !JsonDateReader.isDigit(y3) | !JsonDateReader.isDigit(y4)) {
            throw new ParseException("invalid year", 12);
        }
        int year = y1 * 1000 + y2 * 100 + y3 * 10 + y4 - 53328;
        char h1 = b[i + 17];
        char h2 = b[i + 18];
        if (!JsonDateReader.isDigit(h1) | !JsonDateReader.isDigit(h2)) {
            throw new ParseException("invalid hour", 17);
        }
        int hour = h1 * 10 + h2 - 528;
        char m1 = b[i + 20];
        char m2 = b[i + 21];
        if (!JsonDateReader.isDigit(m1) | !JsonDateReader.isDigit(m2)) {
            throw new ParseException("invalid minute", 20);
        }
        int minute = m1 * 10 + m2 - 528;
        char s1 = b[i + 23];
        char s2 = b[i + 24];
        if (!JsonDateReader.isDigit(s1) | !JsonDateReader.isDigit(s2)) {
            throw new ParseException("invalid second", 23);
        }
        int second = s1 * 10 + s2 - 528;
        GregorianCalendar c = new GregorianCalendar(year, month, dayOfMonth, hour, minute, second);
        c.setTimeZone(UTC);
        return c.getTime();
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isValidDayOfWeek(char a, char b, char c) {
        switch (a) {
            case 'S': {
                if (b == 'u' & c == 'n') {
                    return true;
                }
                return b == 'a' & c == 't';
            }
            case 'M': {
                return b == 'o' & c == 'n';
            }
            case 'T': {
                if (b == 'u' & c == 'e') {
                    return true;
                }
                return b == 'h' & c == 'u';
            }
            case 'W': {
                return b == 'e' & c == 'd';
            }
            case 'F': {
                return b == 'r' & c == 'i';
            }
        }
        return false;
    }

    public static int getMonthIndex(char a, char b, char c) {
        switch (a) {
            case 'J': {
                if (b == 'a' & c == 'n') {
                    return 0;
                }
                if (b == 'u') {
                    if (c == 'n') {
                        return 5;
                    }
                    if (c == 'l') {
                        return 6;
                    }
                    return -1;
                }
                return -1;
            }
            case 'F': {
                if (b == 'e' & c == 'b') {
                    return 1;
                }
                return 0;
            }
            case 'M': {
                if (b == 'a') {
                    if (c == 'r') {
                        return 2;
                    }
                    if (c == 'y') {
                        return 4;
                    }
                    return -1;
                }
                return -1;
            }
            case 'A': {
                if (b == 'p' & c == 'r') {
                    return 3;
                }
                if (b == 'u' & c == 'g') {
                    return 7;
                }
                return -1;
            }
            case 'S': {
                if (b == 'e' & c == 'p') {
                    return 8;
                }
                return -1;
            }
            case 'O': {
                if (b == 'c' & c == 't') {
                    return 9;
                }
                return -1;
            }
            case 'N': {
                if (b == 'o' & c == 'v') {
                    return 10;
                }
                return -1;
            }
            case 'D': {
                if (b == 'e' & c == 'c') {
                    return 11;
                }
                return -1;
            }
        }
        return -1;
    }
}

