/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.BitFieldDBDataType;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AlignedStructureInspector;
import ghidra.program.model.data.AlignedStructurePacker;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

class StructureDB
extends CompositeDB
implements Structure {
    private static Structure.OrdinalComparator ordinalComparator = new Structure.OrdinalComparator();
    private static Structure.OffsetComparator offsetComparator = new Structure.OffsetComparator();
    private static ComponentComparator componentComparator = new ComponentComparator();
    protected static Comparator<Object> bitOffsetComparatorLE = new Structure.BitOffsetComparator(false);
    protected static Comparator<Object> bitOffsetComparatorBE = new Structure.BitOffsetComparator(true);
    private int structLength;
    private int numComponents;
    private ArrayList<DataTypeComponentDB> components;
    private DataTypeComponentDB flexibleArrayComponent;
    private int alignment = -1;

    public StructureDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, Record record) {
        super(dataMgr, cache, compositeAdapter, componentAdapter, record);
    }

    @Override
    protected void initialize() {
        this.components = new ArrayList();
        try {
            long[] ids;
            for (long id : ids = this.componentAdapter.getComponentIdsInComposite(this.key)) {
                Record rec = this.componentAdapter.getRecord(id);
                DataTypeComponentDB component = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
                if (component.isFlexibleArrayComponent()) {
                    this.flexibleArrayComponent = component;
                    continue;
                }
                this.components.add(component);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        Collections.sort(this.components, componentComparator);
        this.structLength = this.record.getIntValue(4);
        this.numComponents = this.record.getIntValue(5);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Structure>";
        }
        return "";
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String name, String comment) {
        return this.doAdd(dataType, length, false, name, comment, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTypeComponent doAdd(DataType dataType, int length, boolean isFlexibleArray, String name, String comment, boolean alignAndNotify) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            DataTypeComponentDB dtc = null;
            try {
                if (dataType == DataType.DEFAULT && !isFlexibleArray) {
                    dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, this.numComponents, this.structLength);
                } else {
                    int componentLength;
                    int offset = this.structLength;
                    int ordinal = this.numComponents;
                    if (isFlexibleArray) {
                        offset = -1;
                        ordinal = -1;
                        if (this.flexibleArrayComponent != null) {
                            this.flexibleArrayComponent.getDataType().removeParent(this);
                            this.componentAdapter.removeRecord(this.flexibleArrayComponent.getKey());
                            this.flexibleArrayComponent = null;
                        }
                        componentLength = 0;
                    } else {
                        componentLength = this.getPreferredComponentLength(dataType, length);
                    }
                    Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, componentLength, ordinal, offset, name, comment);
                    dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
                    dataType.addParent(this);
                    if (isFlexibleArray) {
                        this.flexibleArrayComponent = dtc;
                    } else {
                        this.components.add(dtc);
                    }
                }
                if (!isFlexibleArray) {
                    int structureGrowth = dtc.getLength();
                    if (!this.isInternallyAligned() && length > 0) {
                        structureGrowth = length;
                    }
                    this.record.setIntValue(5, ++this.numComponents);
                    this.structLength += structureGrowth;
                    this.record.setIntValue(4, this.structLength);
                    this.compositeAdapter.updateRecord(this.record, true);
                }
                if (alignAndNotify) {
                    this.adjustInternalAlignment(false);
                    this.notifySizeChanged();
                }
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void growStructure(int amount) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (!this.isInternallyAligned()) {
                this.doGrowStructure(amount);
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    private void doGrowStructure(int amount) {
        if (!this.isInternallyAligned()) {
            this.numComponents += amount;
        }
        this.record.setIntValue(5, this.numComponents);
        this.structLength += amount;
        this.record.setIntValue(4, this.structLength);
        try {
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            DataTypeComponent existingDtc;
            int idx;
            this.checkDeleted();
            if (ordinal < 0 || ordinal > this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            if (ordinal == this.numComponents) {
                DataTypeComponent dataTypeComponent = this.add(dataType, length, name, comment);
                return dataTypeComponent;
            }
            this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            if (this.isInternallyAligned()) {
                idx = ordinal;
            } else {
                DataTypeComponentDB previousDtc;
                idx = Collections.binarySearch(this.components, ordinal, ordinalComparator);
                if (idx > 0 && ((DataTypeComponentDB)(existingDtc = this.components.get(idx))).isBitFieldComponent() && (previousDtc = this.components.get(idx - 1)).getEndOffset() == ((DataTypeComponentDB)existingDtc).getOffset()) {
                    this.shiftOffsets(idx, 0, 1);
                }
            }
            if (idx < 0) {
                idx = -idx - 1;
            }
            if (dataType == DataType.DEFAULT) {
                this.shiftOffsets(idx, 1, 1);
                this.notifySizeChanged();
                existingDtc = this.getComponent(ordinal);
                return existingDtc;
            }
            length = this.getPreferredComponentLength(dataType, length);
            int offset = this.getComponent(ordinal).getOffset();
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, length, ordinal, offset, name, comment);
            DataTypeComponentDB dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            dataType.addParent(this);
            this.shiftOffsets(idx, 1, dtc.getLength());
            this.components.add(idx, dtc);
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.getDataTypeManager());
        BitFieldDBDataType bitFieldDt = new BitFieldDBDataType(baseDataType, bitSize, 0);
        return this.add(bitFieldDt, componentName, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insertBitField(int ordinal, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, ArrayIndexOutOfBoundsException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal > this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            if (!this.isInternallyAligned()) {
                int offset = this.structLength;
                if (ordinal < this.numComponents) {
                    offset = this.getComponent(ordinal).getOffset();
                }
                DataTypeComponent dataTypeComponent = this.insertBitFieldAt(offset, byteWidth, bitOffset, baseDataType, bitSize, componentName, comment);
                return dataTypeComponent;
            }
            BitFieldDBDataType bitFieldDt = new BitFieldDBDataType(baseDataType, bitSize, 0);
            DataTypeComponent dataTypeComponent = this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insertBitFieldAt(int byteOffset, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        this.lock.acquire();
        try {
            int requiredLength;
            int ordinal;
            this.checkDeleted();
            BitFieldDataType.checkBaseDataType(baseDataType);
            baseDataType = baseDataType.clone(this.dataMgr);
            if (byteOffset < 0 || bitSize < 0) {
                throw new IllegalArgumentException("Negative values not permitted when defining bitfield");
            }
            if (byteWidth <= 0) {
                throw new IllegalArgumentException("Invalid byteWidth");
            }
            int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
            int minByteWidth = BitFieldDataType.getMinimumStorageSize(effectiveBitSize + bitOffset);
            if (byteWidth < minByteWidth) {
                throw new IllegalArgumentException("Bitfield does not fit within specified constraints");
            }
            boolean bigEndian = this.getDataOrganization().isBigEndian();
            boolean hasConflict = false;
            int additionalShift = 0;
            int startBitOffset = Structure.BitOffsetComparator.getNormalizedBitfieldOffset(byteOffset, byteWidth, effectiveBitSize, bitOffset, bigEndian);
            Comparator<Object> bitOffsetComparator = bigEndian ? bitOffsetComparatorBE : bitOffsetComparatorLE;
            int startIndex = Collections.binarySearch(this.components, startBitOffset, bitOffsetComparator);
            if (startIndex < 0) {
                startIndex = -startIndex - 1;
            } else {
                hasConflict = true;
                DataTypeComponentDB dtc = this.components.get(startIndex);
                if (bitSize == 0 || dtc.isZeroBitFieldComponent()) {
                    boolean bl = hasConflict = dtc.getOffset() != startBitOffset / 8;
                }
                if (hasConflict) {
                    additionalShift = byteOffset - dtc.getOffset();
                }
            }
            if (startIndex < this.components.size()) {
                DataTypeComponentDB dtc = this.components.get(startIndex);
                ordinal = dtc.getOrdinal();
            } else {
                ordinal = startIndex;
            }
            if (this.isInternallyAligned()) {
                this.insertBitField(ordinal, 0, 0, baseDataType, effectiveBitSize, componentName, comment);
            }
            int endIndex = startIndex;
            if (startIndex < this.components.size()) {
                int endBitOffset = startBitOffset;
                if (effectiveBitSize != 0) {
                    endBitOffset += effectiveBitSize - 1;
                }
                if ((endIndex = Collections.binarySearch(this.components, endBitOffset, bitOffsetComparator)) < 0) {
                    endIndex = -endIndex - 1;
                } else if (effectiveBitSize != 0) {
                    hasConflict = true;
                }
            }
            if (startIndex != endIndex) {
                hasConflict = true;
            }
            if (hasConflict) {
                this.shiftOffsets(startIndex, 1, byteWidth + additionalShift);
            }
            if ((requiredLength = byteOffset + byteWidth) > this.structLength) {
                this.structLength = requiredLength;
            }
            int storageBitOffset = bitOffset % 8;
            int revisedOffset = bigEndian ? byteOffset + byteWidth - (effectiveBitSize + bitOffset + 7) / 8 : byteOffset + bitOffset / 8;
            BitFieldDBDataType bitfieldDt = new BitFieldDBDataType(baseDataType, bitSize, storageBitOffset);
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(bitfieldDt), this.key, bitfieldDt.getStorageSize(), ordinal, revisedOffset, componentName, comment);
            DataTypeComponentDB dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            bitfieldDt.addParent(this);
            this.components.add(startIndex, dtc);
            this.adjustUnalignedComponents();
            this.notifySizeChanged();
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public void delete(int ordinal) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, ordinal, ordinalComparator);
            if (idx >= 0) {
                this.doDelete(idx);
                this.adjustInternalAlignment(false);
            } else {
                idx = -idx - 1;
                this.shiftOffsets(idx, -1, -1);
            }
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    private void doDelete(int index) {
        DataTypeComponentDB dtc = this.components.remove(index);
        dtc.getDataType().removeParent(this);
        try {
            this.componentAdapter.removeRecord(dtc.getKey());
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        if (this.isInternallyAligned()) {
            return;
        }
        int shiftAmount = dtc.isBitFieldComponent() ? 0 : dtc.getLength();
        this.shiftOffsets(index, -1, -shiftAmount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int[] ordinals) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            for (int ordinal : ordinals) {
                if (ordinal >= 0 && ordinal < this.numComponents) continue;
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            int[] sortedOrdinals = (int[])ordinals.clone();
            Arrays.sort(sortedOrdinals);
            for (int i = sortedOrdinals.length - 1; i >= 0; --i) {
                int ordinal = sortedOrdinals[i];
                int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, ordinal, ordinalComparator);
                if (idx >= 0) {
                    this.doDelete(idx);
                    continue;
                }
                idx = -idx - 1;
                this.shiftOffsets(idx, -1, -1);
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartOf(DataType dataType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.equals(dataType)) {
                boolean bl = true;
                return bl;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponent dtc = this.components.get(i);
                DataType subDt = dtc.getDataType();
                if (subDt instanceof Composite) {
                    if (!((Composite)subDt).isPartOf(dataType)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!subDt.equals(dataType)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.numComponents;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumDefinedComponents() {
        this.lock.acquire();
        try {
            int n = this.components.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getComponent(int ordinal) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (ordinal == this.numComponents && this.flexibleArrayComponent != null) {
                DataTypeComponentDB dataTypeComponentDB = this.flexibleArrayComponent;
                return dataTypeComponentDB;
            }
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            if (this.isInternallyAligned()) {
                DataTypeComponent dataTypeComponent = this.components.get(ordinal);
                return dataTypeComponent;
            }
            int idx = Collections.binarySearch(this.components, ordinal, ordinalComparator);
            if (idx >= 0) {
                DataTypeComponent dataTypeComponent = this.components.get(idx);
                return dataTypeComponent;
            }
            int offset = 0;
            if ((idx = -idx - 1) == 0) {
                offset = ordinal;
            } else {
                DataTypeComponent dtc = this.components.get(idx - 1);
                offset = dtc.getEndOffset() + ordinal - dtc.getOrdinal();
            }
            DataTypeComponentDB dataTypeComponentDB = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, ordinal, offset);
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent[] getComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponent[] comps = new DataTypeComponent[this.numComponents];
            for (int i = 0; i < comps.length; ++i) {
                comps[i] = this.getComponent(i);
            }
            DataTypeComponent[] dataTypeComponentArray = comps;
            return dataTypeComponentArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.getCategoryPath(), this.getName(), this.getLength(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.getCategoryPath(), this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public boolean isNotYetDefined() {
        return this.structLength == 0 && this.flexibleArrayComponent == null;
    }

    @Override
    public int getAlignment() {
        if (!this.isInternallyAligned()) {
            return 1;
        }
        if (this.alignment <= 0) {
            AlignedStructurePacker.StructurePackResult packResult = AlignedStructureInspector.packComponents(this);
            this.alignment = packResult.alignment;
        }
        return this.alignment;
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.structLength == 0) {
                int n = 1;
                return n;
            }
            int n = this.structLength;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearComponent(int ordinal) {
        block7: {
            this.lock.acquire();
            try {
                this.checkDeleted();
                if (ordinal < 0 || ordinal >= this.numComponents) {
                    throw new ArrayIndexOutOfBoundsException(ordinal);
                }
                int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, ordinal, ordinalComparator);
                if (idx < 0) break block7;
                DataTypeComponentDB dtc = this.components.remove(idx);
                dtc.getDataType().removeParent(this);
                try {
                    this.componentAdapter.removeRecord(dtc.getKey());
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                int len = dtc.getLength();
                if (len > 1) {
                    this.shiftOffsets(idx, len - 1, 0);
                }
                this.adjustInternalAlignment(true);
                this.dataMgr.dataTypeChanged(this);
            }
            finally {
                this.lock.release();
            }
        }
    }

    private int backupToFirstComponentContainingOffset(int index, int offset) {
        DataTypeComponentDB previous;
        if (index == 0) {
            return 0;
        }
        DataTypeComponentDB dtc = this.components.get(index);
        while (index != 0 && dtc.isBitFieldComponent() && (previous = this.components.get(index - 1)).containsOffset(offset)) {
            dtc = previous;
            --index;
        }
        return index;
    }

    private int advanceToLastComponentContainingOffset(int index, int offset) {
        DataTypeComponentDB next;
        DataTypeComponentDB dtc = this.components.get(index);
        while (index < this.components.size() - 1 && dtc.isBitFieldComponent() && (next = this.components.get(index + 1)).containsOffset(offset)) {
            dtc = next;
            ++index;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAtOffset(int offset) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (offset < 0) {
                throw new IllegalArgumentException("Offset cannot be negative.");
            }
            if (offset >= this.structLength) {
                return;
            }
            int index = Collections.binarySearch(this.components, offset, offsetComparator);
            int offsetDelta = 0;
            int ordinalDelta = 0;
            if (index < 0) {
                index = -index - 1;
                offsetDelta = -1;
                this.shiftOffsets(index, --ordinalDelta, offsetDelta);
            } else {
                index = this.advanceToLastComponentContainingOffset(index, offset);
                DataTypeComponentDB dtc = this.components.get(index);
                while (dtc.containsOffset(offset)) {
                    this.doDelete(index);
                    if (--index < 0) break;
                    dtc = this.components.get(index);
                }
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getComponentAt(int offset) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (offset >= this.structLength || offset < 0) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            int index = Collections.binarySearch(this.components, offset, offsetComparator);
            if (index >= 0) {
                DataTypeComponent dtc = this.components.get(index);
                if (dtc.isBitFieldComponent()) {
                    index = this.backupToFirstComponentContainingOffset(index, offset);
                    dtc = this.components.get(index);
                }
                DataTypeComponent dataTypeComponent = dtc;
                return dataTypeComponent;
            }
            if (this.isInternallyAligned()) {
                DataTypeComponent dtc = null;
                return dtc;
            }
            index = -index - 1;
            int ordinal = offset;
            if (index > 0) {
                DataTypeComponent dtc = this.components.get(index - 1);
                ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            }
            DataTypeComponentDB dataTypeComponentDB = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, ordinal, offset);
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getDataTypeAt(int offset) {
        this.lock.acquire();
        try {
            DataType dt;
            DataTypeComponent dtc = this.getComponentAt(offset);
            if (dtc != null && (dt = dtc.getDataType()) instanceof Structure) {
                DataTypeComponent dataTypeComponent = ((Structure)dt).getDataTypeAt(offset - dtc.getOffset());
                return dataTypeComponent;
            }
            DataTypeComponent dataTypeComponent = dtc;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent[] getDefinedComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponent[] dataTypeComponentArray = this.components.toArray(new DataTypeComponent[this.components.size()]);
            return dataTypeComponentArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public final DataTypeComponent insertAtOffset(int offset, DataType dataType, int length) {
        return this.insertAtOffset(offset, dataType, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insertAtOffset(int offset, DataType dataType, int length, String name, String comment) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (dataType instanceof BitFieldDataType) {
            BitFieldDataType bfDt = (BitFieldDataType)dataType;
            if (length <= 0) {
                length = dataType.getLength();
            }
            try {
                return this.insertBitFieldAt(offset, length, bfDt.getBitOffset(), bfDt.getBaseDataType(), bfDt.getDeclaredBitSize(), name, comment);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)((Object)e));
            }
        }
        this.lock.acquire();
        try {
            DataTypeComponentDB dtc;
            this.checkDeleted();
            this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            if (offset > this.structLength && !this.isInternallyAligned()) {
                this.numComponents += offset - this.structLength;
                this.structLength = offset;
            }
            int index = Collections.binarySearch(this.components, offset, offsetComparator);
            int additionalShift = 0;
            if (index >= 0) {
                index = this.backupToFirstComponentContainingOffset(index, offset);
                DataTypeComponentDB dtc2 = this.components.get(index);
                additionalShift = offset - dtc2.getOffset();
            } else {
                index = -index - 1;
            }
            int ordinal = offset;
            if (index > 0) {
                dtc = this.components.get(index - 1);
                ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            }
            if (dataType == DataType.DEFAULT) {
                this.shiftOffsets(index, 1 + additionalShift, 1 + additionalShift);
                this.adjustInternalAlignment(true);
                this.notifySizeChanged();
                dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, ordinal, offset);
                return dtc;
            }
            length = this.getPreferredComponentLength(dataType, length);
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, length, ordinal, offset, name, comment);
            dataType.addParent(this);
            DataTypeComponentDB dtc3 = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            this.shiftOffsets(index, 1 + additionalShift, dtc3.getLength() + additionalShift);
            this.components.add(index, dtc3);
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
            DataTypeComponentDB dataTypeComponentDB = dtc3;
            return dataTypeComponentDB;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent replace(int ordinal, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            this.validateDataType(dataType);
            DataTypeComponent origDtc = this.getComponent(ordinal);
            if (origDtc.isBitFieldComponent()) {
                throw new IllegalArgumentException("Bit-field component may not be directly replaced");
            }
            if (dataType == DataType.DEFAULT) {
                this.clearComponent(ordinal);
                DataTypeComponent dataTypeComponent = this.getComponent(ordinal);
                return dataTypeComponent;
            }
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            length = this.getPreferredComponentLength(dataType, length);
            DataTypeComponent replaceComponent = this.replaceComponent(origDtc, dataType, length, name, comment, true);
            this.adjustInternalAlignment(true);
            DataTypeComponent dataTypeComponent = replaceComponent;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public final DataTypeComponent replace(int ordinal, DataType dataType, int length) {
        return this.replace(ordinal, dataType, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent replaceAtOffset(int offset, DataType dataType, int length, String name, String comment) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (offset >= this.getLength()) {
            throw new IllegalArgumentException("Offset " + offset + " is beyond end of structure (" + this.structLength + ").");
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.validateDataType(dataType);
            DataTypeComponent origDtc = this.getComponentAt(offset);
            if (origDtc.isBitFieldComponent()) {
                throw new IllegalArgumentException("Bit-field component may not be directly replaced");
            }
            if (dataType == DataType.DEFAULT) {
                int ordinal = origDtc.getOrdinal();
                this.clearComponent(ordinal);
                DataTypeComponent dataTypeComponent = this.getComponent(ordinal);
                return dataTypeComponent;
            }
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            length = this.getPreferredComponentLength(dataType, length);
            DataTypeComponent replaceComponent = this.replaceComponent(origDtc, dataType, length, name, comment, true);
            this.adjustInternalAlignment(true);
            DataTypeComponent dataTypeComponent = replaceComponent;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Structure)) {
            throw new IllegalArgumentException();
        }
        this.doReplaceWith((Structure)dataType, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReplaceWith(Structure struct, boolean notify, DataTypeConflictHandler handler) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldLength = this.structLength;
            int oldMinAlignment = this.getMinimumAlignment();
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponentDB dtc = this.components.get(i);
                dtc.getDataType().removeParent(this);
                this.componentAdapter.removeRecord(dtc.getKey());
            }
            this.components.clear();
            this.numComponents = 0;
            this.structLength = 0;
            if (this.flexibleArrayComponent != null) {
                this.flexibleArrayComponent.getDataType().removeParent(this);
                this.componentAdapter.removeRecord(this.flexibleArrayComponent.getKey());
                this.flexibleArrayComponent = null;
            }
            this.setAlignment(struct, false);
            if (struct.isInternallyAligned()) {
                this.doReplaceWithAligned(struct);
            } else {
                this.doReplaceWithUnaligned(struct);
            }
            DataTypeComponent flexComponent = struct.getFlexibleArrayComponent();
            if (flexComponent != null) {
                this.setFlexibleArrayComponent(flexComponent.getDataType(), flexComponent.getFieldName(), flexComponent.getComment());
            }
            this.record.setIntValue(5, this.numComponents);
            this.record.setIntValue(4, this.structLength);
            this.compositeAdapter.updateRecord(this.record, false);
            if (notify) {
                if (oldMinAlignment != this.getMinimumAlignment()) {
                    this.notifyAlignmentChanged();
                } else if (oldLength != this.structLength) {
                    this.notifySizeChanged();
                } else {
                    this.dataMgr.dataTypeChanged(this);
                }
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void doReplaceWithAligned(Structure struct) {
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = dtc.getDataType();
            int length = dt instanceof Dynamic ? dtc.getLength() : -1;
            this.doAdd(dt, length, false, dtc.getFieldName(), dtc.getComment(), false);
        }
        this.adjustInternalAlignment(false);
        this.dataMgr.dataTypeChanged(this);
    }

    private void doReplaceWithUnaligned(Structure struct) throws IOException {
        if (struct.isNotYetDefined()) {
            return;
        }
        this.numComponents = this.structLength = struct.getLength();
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = this.resolve(dtc.getDataType());
            this.checkAncestry(dt);
            int length = this.getPreferredComponentLength(dt, dtc.getLength());
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dt), this.key, length, dtc.getOrdinal(), dtc.getOffset(), dtc.getFieldName(), dtc.getComment());
            dt.addParent(this);
            DataTypeComponentDB newDtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            this.components.add(newDtc);
        }
        this.adjustComponents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeDeleted(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean didChange = false;
            if (this.flexibleArrayComponent != null && this.flexibleArrayComponent.getDataType() == dt) {
                this.flexibleArrayComponent.getDataType().removeParent(this);
                this.componentAdapter.removeRecord(this.flexibleArrayComponent.getKey());
                this.flexibleArrayComponent = null;
                didChange = true;
            }
            int n = this.components.size();
            for (int i = n - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                boolean removeBitFieldComponent = false;
                if (dtc.isBitFieldComponent()) {
                    BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                    boolean bl = removeBitFieldComponent = bitfieldDt.getBaseDataType() == dt;
                }
                if (!removeBitFieldComponent && dtc.getDataType() != dt) continue;
                dt.removeParent(this);
                this.components.remove(i);
                this.shiftOffsets(i, dtc.getLength() - 1, 0);
                this.componentAdapter.removeRecord(dtc.getKey());
                didChange = true;
            }
            if (didChange) {
                this.adjustInternalAlignment(true);
                this.notifySizeChanged();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeSizeChanged(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.isInternallyAligned()) {
                this.adjustInternalAlignment(true);
                return;
            }
            boolean didChange = false;
            int n = this.components.size();
            for (int i = 0; i < n; ++i) {
                int consumed;
                int dtcLen;
                DataTypeComponentDB dtc = this.components.get(i);
                int nextIndex = i + 1;
                if (dtc.getDataType() != dt) continue;
                int dtLen = dt.getLength();
                if (dtLen < (dtcLen = dtc.getLength())) {
                    dtc.setLength(dtLen, true);
                    this.shiftOffsets(nextIndex, dtcLen - dtLen, 0);
                    didChange = true;
                    continue;
                }
                if (dtLen <= dtcLen || (consumed = this.consumeBytesAfter(i, dtLen - dtcLen)) <= 0) continue;
                dtc.updateRecord();
                this.shiftOffsets(nextIndex, -consumed, 0);
                didChange = true;
            }
            if (didChange) {
                this.adjustInternalAlignment(true);
                this.notifySizeChanged();
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.adjustInternalAlignment(true);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isEquivalent(DataType dataType) {
        int otherNumComps;
        if (dataType == this) {
            return true;
        }
        if (dataType == null || !(dataType instanceof Structure)) {
            return false;
        }
        this.checkIsValid();
        if (this.resolving) {
            if (dataType.getUniversalID().equals((Object)this.getUniversalID())) {
                return true;
            }
            return DataTypeUtilities.equalsIgnoreConflict(this.getPathName(), dataType.getPathName());
        }
        Structure struct = (Structure)dataType;
        if (this.isInternallyAligned() != struct.isInternallyAligned() || this.isDefaultAligned() != struct.isDefaultAligned() || this.isMachineAligned() != struct.isMachineAligned() || this.getMinimumAlignment() != struct.getMinimumAlignment() || this.getPackingValue() != struct.getPackingValue() || !this.isInternallyAligned() && this.getLength() != struct.getLength()) {
            return false;
        }
        DataTypeComponent myFlexComp = this.getFlexibleArrayComponent();
        DataTypeComponent otherFlexComp = struct.getFlexibleArrayComponent();
        if (myFlexComp != null ? otherFlexComp == null || !myFlexComp.isEquivalent(otherFlexComp) : otherFlexComp != null) {
            return false;
        }
        int myNumComps = this.getNumComponents();
        if (myNumComps != (otherNumComps = struct.getNumComponents())) {
            return false;
        }
        for (int i = 0; i < myNumComps; ++i) {
            DataTypeComponent otherDtc;
            DataTypeComponent myDtc = this.getComponent(i);
            if (myDtc.isEquivalent(otherDtc = struct.getComponent(i))) continue;
            return false;
        }
        return true;
    }

    private int consumeBytesAfter(int definedComponentIndex, int numBytes) {
        int available;
        DataTypeComponentDB thisDtc = this.components.get(definedComponentIndex);
        int thisLen = thisDtc.getLength();
        int nextOffset = thisDtc.getOffset() + thisLen;
        if (definedComponentIndex == this.components.size() - 1) {
            available = this.structLength - nextOffset;
            if (numBytes > available) {
                this.doGrowStructure(numBytes - available);
                available = numBytes;
            }
        } else {
            DataTypeComponent nextDtc = this.components.get(definedComponentIndex + 1);
            available = nextDtc.getOffset() - nextOffset;
        }
        if (numBytes <= available) {
            thisDtc.setLength(thisLen + numBytes, true);
            return numBytes;
        }
        thisDtc.setLength(thisLen + available, true);
        return available;
    }

    private int getLastDefinedComponentIndex() {
        if (this.components.size() == 0) {
            return 0;
        }
        DataTypeComponentDB dataTypeComponentDB = this.components.get(this.components.size() - 1);
        return dataTypeComponentDB.getOrdinal();
    }

    private void shiftOffsets(int definedComponentIndex, int deltaOrdinal, int deltaOffset) {
        for (int i = definedComponentIndex; i < this.components.size(); ++i) {
            DataTypeComponentDB dtc = this.components.get(i);
            this.shiftOffset(dtc, deltaOrdinal, deltaOffset);
        }
        this.structLength += deltaOffset;
        if (!this.isInternallyAligned()) {
            this.numComponents += deltaOrdinal;
        }
        this.record.setIntValue(5, this.numComponents);
        this.record.setIntValue(4, this.structLength);
        try {
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    protected void shiftOffset(DataTypeComponentDB dtc, int deltaOrdinal, int deltaOffset) {
        dtc.setOffset(dtc.getOffset() + deltaOffset, false);
        dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal, false);
        dtc.updateRecord();
    }

    private DataTypeComponent replaceComponent(DataTypeComponent origDtc, DataType resolvedDataType, int length, String name, String comment, boolean doNotify) {
        try {
            int bytesAvailable;
            int ordinal = origDtc.getOrdinal();
            int newOffset = origDtc.getOffset();
            int dtcLength = origDtc.getLength();
            int bytesNeeded = length - dtcLength;
            int deltaOrdinal = -bytesNeeded;
            int origStructLength = this.structLength;
            if (!this.isInternallyAligned() && bytesNeeded > 0 && (bytesAvailable = this.getNumUndefinedBytes(ordinal + 1)) < bytesNeeded) {
                if (ordinal == this.getLastDefinedComponentIndex()) {
                    this.growStructure(bytesNeeded - bytesAvailable);
                } else {
                    throw new IllegalArgumentException("Not enough undefined bytes to fit " + resolvedDataType.getPathName() + " in structure " + this.getPathName() + " at offset 0x" + Integer.toHexString(newOffset) + ". It needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.");
                }
            }
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(resolvedDataType), this.key, length, ordinal, newOffset, name, comment);
            resolvedDataType.addParent(this);
            DataTypeComponentDB newDtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            int index = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, ordinal, ordinalComparator);
            if (index < 0) {
                index = -index - 1;
            } else {
                DataTypeComponentDB dataTypeComponentDB = this.components.get(index);
                dataTypeComponentDB.getDataType().removeParent(this);
                DataTypeComponentDB dtc = this.components.remove(index);
                this.componentAdapter.removeRecord(dtc.getKey());
            }
            this.components.add(index, newDtc);
            if (deltaOrdinal != 0) {
                this.shiftOffsets(index + 1, deltaOrdinal, 0);
            }
            if (this.structLength != origStructLength) {
                this.record.setIntValue(4, this.structLength);
                this.compositeAdapter.updateRecord(this.record, true);
                this.adjustInternalAlignment(false);
                this.notifySizeChanged();
            } else if (doNotify) {
                this.dataMgr.dataTypeChanged(this);
            }
            return newDtc;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            return null;
        }
    }

    private int getNumUndefinedBytes(int ordinal) {
        if (this.isInternallyAligned()) {
            return 0;
        }
        if (ordinal >= this.numComponents) {
            return 0;
        }
        int idx = Collections.binarySearch(this.components, ordinal, ordinalComparator);
        DataTypeComponentDB dtc = null;
        if (idx < 0) {
            if ((idx = -idx - 1) >= this.components.size()) {
                return this.numComponents - ordinal;
            }
            dtc = this.components.get(idx);
            return dtc.getOrdinal() - ordinal;
        }
        return 0;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (oldDt == this) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataType replacementDt = newDt;
            try {
                this.validateDataType(replacementDt);
                if (!(replacementDt instanceof DataTypeDB) || replacementDt.getDataTypeManager() != this.dataMgr) {
                    replacementDt = this.resolve(replacementDt);
                }
                this.checkAncestry(replacementDt);
            }
            catch (Exception e) {
                replacementDt = DataType.DEFAULT;
            }
            boolean changed = false;
            if (this.flexibleArrayComponent != null && this.flexibleArrayComponent.getDataType() == oldDt) {
                this.flexibleArrayComponent.getDataType().removeParent(this);
                if (this.isInvalidFlexArrayDataType(replacementDt)) {
                    this.componentAdapter.removeRecord(this.flexibleArrayComponent.getKey());
                    this.flexibleArrayComponent = null;
                    Msg.error((Object)this, (Object)("Invalid flex array replacement type " + newDt.getName() + ", removing flex array: " + this.getPathName()));
                } else {
                    this.flexibleArrayComponent.setDataType(replacementDt);
                    replacementDt.addParent(this);
                }
                changed = true;
            }
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DataTypeComponentDB comp = this.components.get(i);
                int nextIndex = i + 1;
                boolean remove = false;
                if (comp.isBitFieldComponent()) {
                    try {
                        changed |= this.updateBitFieldDataType(comp, oldDt, replacementDt);
                    }
                    catch (InvalidDataTypeException e) {
                        Msg.error((Object)this, (Object)("Invalid bitfield replacement type " + newDt.getName() + ", removing bitfield " + comp.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    }
                } else if (comp.getDataType() == oldDt) {
                    if (replacementDt == DEFAULT && this.isInternallyAligned()) {
                        Msg.error((Object)this, (Object)("Invalid replacement type " + newDt.getName() + ", removing component " + comp.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    } else {
                        this.setComponentDataType(comp, replacementDt, nextIndex);
                        changed = true;
                    }
                }
                if (!remove) continue;
                oldDt.removeParent(this);
                this.components.remove(i);
                this.shiftOffsets(i, comp.getLength() - 1, 0);
                this.componentAdapter.removeRecord(comp.getKey());
                changed = true;
            }
            if (changed) {
                this.adjustInternalAlignment(false);
                this.notifySizeChanged();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void setComponentDataType(DataTypeComponentDB comp, DataType replacementDt, int nextIndex) {
        comp.getDataType().removeParent(this);
        comp.setDataType(replacementDt);
        replacementDt.addParent(this);
        if (this.isInternallyAligned()) {
            return;
        }
        int len = replacementDt.getLength();
        int oldLen = comp.getLength();
        if (len > 0) {
            if (len < oldLen) {
                comp.setLength(len, true);
                this.shiftOffsets(nextIndex, oldLen - len, 0);
            } else if (len > oldLen) {
                int bytesNeeded = len - oldLen;
                int bytesAvailable = this.getNumUndefinedBytes(comp.getOrdinal() + 1);
                if (bytesNeeded <= bytesAvailable) {
                    comp.setLength(len, true);
                    this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                } else if (comp.getOrdinal() == this.getLastDefinedComponentIndex()) {
                    this.doGrowStructure(bytesNeeded - bytesAvailable);
                    comp.setLength(len, true);
                    this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                } else {
                    comp.setLength(oldLen + bytesAvailable, true);
                    this.shiftOffsets(nextIndex, -bytesAvailable, 0);
                }
            }
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.flexibleArrayComponent != null) {
                this.flexibleArrayComponent.getDataType().removeParent(this);
                this.componentAdapter.removeRecord(this.flexibleArrayComponent.getKey());
                this.flexibleArrayComponent = null;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponentDB dtc = this.components.get(i);
                dtc.getDataType().removeParent(this);
                try {
                    this.componentAdapter.removeRecord(dtc.getKey());
                    continue;
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
            }
            this.components.clear();
            this.structLength = 0;
            this.numComponents = 0;
            this.record.setIntValue(4, 0);
            this.record.setIntValue(5, 0);
            this.compositeAdapter.updateRecord(this.record, true);
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean adjustComponents(boolean notify) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean changed = false;
            this.alignment = -1;
            if (!this.isInternallyAligned()) {
                if (notify && (changed |= this.adjustUnalignedComponents())) {
                    this.dataMgr.dataTypeChanged(this);
                }
                boolean bl = changed;
                return bl;
            }
            int oldLength = this.structLength;
            AlignedStructurePacker.StructurePackResult packResult = AlignedStructurePacker.packComponents(this, this.components);
            changed = packResult.componentsChanged;
            if (notify & (changed |= this.updateComposite(packResult.numComponents, packResult.structureLength, packResult.alignment, false))) {
                if (oldLength != this.structLength) {
                    this.notifySizeChanged();
                } else {
                    this.dataMgr.dataTypeChanged(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    private boolean adjustUnalignedComponents() {
        boolean changed = false;
        int componentCount = 0;
        int currentOffset = 0;
        for (DataTypeComponentDB dataTypeComponent : this.components) {
            int componentLength = dataTypeComponent.getLength();
            int componentOffset = dataTypeComponent.getOffset();
            int numUndefinedsBefore = componentOffset - currentOffset;
            if (numUndefinedsBefore > 0) {
                componentCount += numUndefinedsBefore;
            }
            currentOffset = componentOffset + componentLength;
            if (dataTypeComponent.getOrdinal() != componentCount) {
                dataTypeComponent.setOrdinal(componentCount, true);
                changed = true;
            }
            ++componentCount;
        }
        int numUndefinedsAfter = this.structLength - currentOffset;
        if (this.updateNumComponents(componentCount += numUndefinedsAfter)) {
            changed = true;
        }
        return changed;
    }

    private boolean updateNumComponents(int currentNumComponents) {
        boolean compositeChanged = false;
        if (this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            this.record.setIntValue(5, this.numComponents);
            compositeChanged = true;
        }
        if (compositeChanged) {
            try {
                this.compositeAdapter.updateRecord(this.record, true);
                return true;
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        return false;
    }

    private boolean updateComposite(int currentNumComponents, int currentLength, int currentAlignment, boolean setLastChangeTime) {
        boolean compositeChanged = false;
        if (this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            this.record.setIntValue(5, this.numComponents);
            compositeChanged = true;
        }
        if (this.structLength != currentLength) {
            this.structLength = currentLength;
            this.record.setIntValue(4, this.structLength);
            compositeChanged = true;
        }
        if (this.alignment != currentAlignment) {
            this.alignment = currentAlignment;
            compositeChanged = true;
        }
        if (compositeChanged) {
            try {
                this.compositeAdapter.updateRecord(this.record, setLastChangeTime);
                return true;
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        return false;
    }

    @Override
    public void realign() {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment(true);
        }
    }

    @Override
    public void pack(int packingSize) throws InvalidInputException {
        this.setPackingValue(packingSize);
    }

    @Override
    protected void adjustInternalAlignment(boolean notify) {
        this.adjustComponents(notify);
    }

    @Override
    public boolean hasFlexibleArrayComponent() {
        return this.flexibleArrayComponent != null;
    }

    @Override
    public DataTypeComponent getFlexibleArrayComponent() {
        return this.flexibleArrayComponent;
    }

    private boolean isInvalidFlexArrayDataType(DataType dataType) {
        return dataType == null || dataType == DataType.DEFAULT || dataType instanceof BitFieldDataType || dataType instanceof Dynamic || dataType instanceof FactoryDataType;
    }

    @Override
    public DataTypeComponent setFlexibleArrayComponent(DataType flexType, String name, String comment) {
        if (this.isInvalidFlexArrayDataType(flexType)) {
            throw new IllegalArgumentException("Unsupported flexType: " + flexType.getDisplayName());
        }
        return this.doAdd(flexType, 0, true, name, comment, true);
    }

    @Override
    public void clearFlexibleArrayComponent() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.flexibleArrayComponent == null) {
                return;
            }
            DataTypeComponentDB dtc = this.flexibleArrayComponent;
            this.flexibleArrayComponent = null;
            dtc.getDataType().removeParent(this);
            try {
                this.componentAdapter.removeRecord(dtc.getKey());
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected void dumpComponents(StringBuilder buffer, String pad) {
        super.dumpComponents(buffer, pad);
        DataTypeComponent dtc = this.getFlexibleArrayComponent();
        if (dtc != null) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dataType.getDisplayName() + "[0]");
            buffer.append(pad + dtc.getLength());
            buffer.append(pad + dtc.getFieldName());
            String comment = dtc.getComment();
            if (comment == null) {
                comment = "";
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }

    private static class ComponentComparator
    implements Comparator<DataTypeComponent> {
        private ComponentComparator() {
        }

        @Override
        public int compare(DataTypeComponent dtc1, DataTypeComponent dtc2) {
            return dtc1.getOrdinal() - dtc2.getOrdinal();
        }
    }
}

