(declare (block) (standard-bindings) (extended-bindings))
(begin
  (bind-method! (macro-type-port) 'destroy close-port)
  (define std/misc/ports#copy-port
    (lambda (_in181286_ _out181287_)
      (if (not (input-port? _in181286_))
          (error '"Expected input port" _in181286_)
          (if (not (output-port? _out181287_))
              (error '"Expected output port" _out181287_)
              (if (macro-byte-port? _in181286_)
                  (if (macro-byte-port? _out181287_)
                      (std/misc/ports#try-copy-byte-port
                       _in181286_
                       _out181287_)
                      (if (macro-character-port? _out181287_)
                          (std/misc/ports#copy-character-port
                           _in181286_
                           _out181287_)
                          (std/misc/ports#copy-object-port
                           _in181286_
                           _out181287_)))
                  (if (macro-character-port? _in181286_)
                      (if (macro-character-port? _out181287_)
                          (std/misc/ports#copy-character-port
                           _in181286_
                           _out181287_)
                          (std/misc/ports#copy-object-port
                           _in181286_
                           _out181287_))
                      (std/misc/ports#copy-object-port
                       _in181286_
                       _out181287_)))))))
  (define std/misc/ports#try-copy-byte-port
    (lambda (_in181280_ _out181281_)
      (macro-port-mutex-lock! _in181280_)
      (if (or (##fx< (macro-character-port-rlo _in181280_)
                     (macro-character-port-rhi _in181280_))
              (macro-character-port-peek-eof? _in181280_))
          (std/misc/ports#copy-character-port/lock _in181280_ _out181281_)
          (std/misc/ports#copy-byte-port/lock _in181280_ _out181281_))))
  (define std/misc/ports#copy-character-port
    (lambda (_in181277_ _out181278_)
      (macro-port-mutex-lock! _in181277_)
      (std/misc/ports#copy-character-port/lock _in181277_ _out181278_)))
  (define std/misc/ports#copy-byte-port/lock
    (lambda (_in181252_ _out181253_)
      (letrec ((_loop181255_
                (lambda ()
                  (let ((_rlo181265_ (macro-byte-port-rlo _in181252_))
                        (_rhi181266_ (macro-byte-port-rhi _in181252_)))
                    (if (##fx< _rlo181265_ _rhi181266_)
                        (let ((_rbuf181268_ (macro-byte-port-rbuf _in181252_)))
                          (with-exception-catcher
                           (lambda (_g181269181271_)
                             (if '#t
                                 (let ((_e181274_ _g181269181271_))
                                   (if (eq? _in181252_ _out181253_)
                                       '#!void
                                       (macro-port-mutex-unlock! _in181252_))
                                   (raise _e181274_))
                                 (raise _g181269181271_)))
                           (lambda ()
                             (if (eq? _in181252_ _out181253_)
                                 (macro-port-mutex-unlock! _in181252_)
                                 '#!void)
                             (write-subu8vector
                              _rbuf181268_
                              _rlo181265_
                              _rhi181266_
                              _out181253_)
                             (if (eq? _in181252_ _out181253_)
                                 (macro-port-mutex-lock! _in181252_)
                                 '#!void)))
                          (macro-byte-port-rlo-set! _in181252_ _rhi181266_)
                          (_rbuf-fill181256_))
                        (_rbuf-fill181256_)))))
               (_rbuf-fill181256_
                (lambda ()
                  (let* ((_rbuf181259_ (macro-byte-port-rbuf _in181252_))
                         (_res181261_
                          ((macro-byte-port-rbuf-fill _in181252_)
                           _in181252_
                           (##u8vector-length _rbuf181259_)
                           '#t)))
                    (if (eq? _res181261_ ##err-code-EAGAIN)
                        (macro-port-mutex-unlock! _in181252_)
                        (if (fixnum? _res181261_)
                            (begin
                              (macro-port-mutex-unlock! _in181252_)
                              (##raise-os-io-exception
                               _in181252_
                               '#f
                               _res181261_
                               std/misc/ports#copy-port
                               _in181252_
                               _out181253_))
                            (if _res181261_
                                (_loop181255_)
                                (macro-port-mutex-unlock! _in181252_))))))))
        (_loop181255_))))
  (define std/misc/ports#copy-character-port/lock
    (lambda (_in181227_ _out181228_)
      (letrec ((_loop181230_
                (lambda ()
                  (let ((_rlo181240_ (macro-character-port-rlo _in181227_))
                        (_rhi181241_ (macro-character-port-rhi _in181227_)))
                    (if (##fx< _rlo181240_ _rhi181241_)
                        (let ((_rbuf181243_
                               (macro-character-port-rbuf _in181227_)))
                          (with-exception-catcher
                           (lambda (_g181244181246_)
                             (if '#t
                                 (let ((_e181249_ _g181244181246_))
                                   (if (eq? _in181227_ _out181228_)
                                       '#!void
                                       (macro-port-mutex-unlock! _in181227_))
                                   (raise _e181249_))
                                 (raise _g181244181246_)))
                           (lambda ()
                             (if (eq? _in181227_ _out181228_)
                                 (macro-port-mutex-unlock! _in181227_)
                                 '#!void)
                             (write-substring
                              _rbuf181243_
                              _rlo181240_
                              _rhi181241_
                              _out181228_)
                             (if (eq? _in181227_ _out181228_)
                                 (macro-port-mutex-lock! _in181227_)
                                 '#!void)))
                          (macro-character-port-rlo-set!
                           _in181227_
                           _rhi181241_)
                          (_rbuf-fill181231_))
                        (if (macro-character-port-peek-eof? _in181227_)
                            (begin
                              (macro-character-port-peek-eof?-set!
                               _in181227_
                               '#f)
                              (macro-port-mutex-unlock! _in181227_))
                            (_rbuf-fill181231_))))))
               (_rbuf-fill181231_
                (lambda ()
                  (let* ((_rbuf181234_ (macro-character-port-rbuf _in181227_))
                         (_res181236_
                          ((macro-character-port-rbuf-fill _in181227_)
                           _in181227_
                           (##string-length _rbuf181234_)
                           '#t)))
                    (if (eq? _res181236_ ##err-code-EAGAIN)
                        (macro-port-mutex-unlock! _in181227_)
                        (if (fixnum? _res181236_)
                            (begin
                              (macro-port-mutex-unlock! _in181227_)
                              (##raise-os-io-exception
                               _in181227_
                               '#f
                               _res181236_
                               std/misc/ports#copy-port
                               _in181227_
                               _out181228_))
                            (if _res181236_
                                (_loop181230_)
                                (macro-port-mutex-unlock! _in181227_))))))))
        (_loop181230_))))
  (define std/misc/ports#copy-object-port
    (lambda (_in181220_ _out181221_)
      (let _lp181223_ ((_next181225_ (read _in181220_)))
        (if (eof-object? _next181225_)
            '#!void
            (begin
              (write _next181225_ _out181221_)
              (_lp181223_ (read _in181220_)))))))
  (define std/misc/ports#read-all-as-string
    (lambda (_port181216_)
      (let ((_string181218_ (read-line _port181216_ '#f)))
        (if (string? _string181218_) _string181218_ '""))))
  (define std/misc/ports#read-file-string__%
    (lambda (_g181288_ _settings181193181196_ _file181198_)
      (let ((_settings181200_
             (if (eq? _settings181193181196_ absent-value)
                 '()
                 _settings181193181196_)))
        (call-with-input-file
         (cons 'path: (cons _file181198_ _settings181200_))
         std/misc/ports#read-all-as-string))))
  (define std/misc/ports#read-file-string__@
    (lambda (_keys181192181205_ . _args181207_)
      (apply std/misc/ports#read-file-string__%
             _keys181192181205_
             (table-ref _keys181192181205_ 'settings: absent-value)
             _args181207_)))
  (define std/misc/ports#read-file-string
    (lambda _args181194181213_
      (apply keyword-dispatch
             '#(settings:)
             std/misc/ports#read-file-string__@
             _args181194181213_)))
  (define std/misc/ports#read-all-as-lines__%
    (lambda (_g181289_
             _separator181157181161_
             _include-separator?181158181163_
             _port181165_)
      (let* ((_separator181167_
              (if (eq? _separator181157181161_ absent-value)
                  '#\newline
                  _separator181157181161_))
             (_include-separator?181169_
              (if (eq? _include-separator?181158181163_ absent-value)
                  '#f
                  _include-separator?181158181163_)))
        (let _loop181171_ ((_lines181173_ '()))
          (let ((_line181175_
                 (read-line
                  _port181165_
                  _separator181167_
                  _include-separator?181169_)))
            (if (string? _line181175_)
                (_loop181171_ (cons _line181175_ _lines181173_))
                (reverse _lines181173_)))))))
  (define std/misc/ports#read-all-as-lines__@
    (lambda (_keys181156181180_ . _args181182_)
      (apply std/misc/ports#read-all-as-lines__%
             _keys181156181180_
             (table-ref _keys181156181180_ 'separator: absent-value)
             (table-ref _keys181156181180_ 'include-separator?: absent-value)
             _args181182_)))
  (define std/misc/ports#read-all-as-lines
    (lambda _args181159181188_
      (apply keyword-dispatch
             '#(separator: #f include-separator?: #f)
             std/misc/ports#read-all-as-lines__@
             _args181159181188_)))
  (define std/misc/ports#read-file-lines__%
    (lambda (_g181290_ _settings181132181135_ _file181137_)
      (let ((_settings181139_
             (if (eq? _settings181132181135_ absent-value)
                 '()
                 _settings181132181135_)))
        (call-with-input-file
         (cons 'path: (cons _file181137_ _settings181139_))
         std/misc/ports#read-all-as-lines))))
  (define std/misc/ports#read-file-lines__@
    (lambda (_keys181131181144_ . _args181146_)
      (apply std/misc/ports#read-file-lines__%
             _keys181131181144_
             (table-ref _keys181131181144_ 'settings: absent-value)
             _args181146_)))
  (define std/misc/ports#read-file-lines
    (lambda _args181133181152_
      (apply keyword-dispatch
             '#(settings:)
             std/misc/ports#read-file-lines__@
             _args181133181152_))))
