/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import openlink.util.Vector;
import virtuoso.jdbc2.VirtuosoBlobStream;
import virtuoso.jdbc2.VirtuosoClobStream;
import virtuoso.jdbc2.VirtuosoConnection;
import virtuoso.jdbc2.VirtuosoException;
import virtuoso.jdbc2.VirtuosoFuture;

public class VirtuosoBlob
implements Blob,
Clob {
    private boolean request = true;
    private long length;
    private long bh_page;
    private long ask;
    private long bh_current_page;
    private long bh_start_offset;
    private long bh_position;
    private byte[] buffer;
    private Reader rd;
    private InputStream is;
    private VirtuosoConnection connection;
    protected int dtp;
    protected long key_id = 0L;
    protected long frag_no = 0L;
    protected long dir_page = 0L;
    protected long bh_timestamp = 0L;
    protected Object pages = null;

    VirtuosoBlob(InputStream inputStream, long l, long l2) throws VirtuosoException {
        this.is = inputStream;
        this.bh_page = l2;
        this.length = l;
        this.rewind();
    }

    private void rewind() {
        this.bh_current_page = this.bh_page;
        this.bh_start_offset = 0L;
        this.bh_position = 0L;
    }

    private long bh_offset() {
        return this.bh_start_offset;
    }

    VirtuosoBlob(byte[] byArray) throws VirtuosoException {
        this.buffer = byArray;
        this.request = false;
        this.length = byArray.length;
    }

    VirtuosoBlob() throws VirtuosoException {
    }

    VirtuosoBlob(Object object, long l) throws VirtuosoException {
    }

    VirtuosoBlob(Reader reader, long l, long l2) throws VirtuosoException {
        this.rd = reader;
        this.length = l;
        this.bh_page = l2;
        this.rewind();
    }

    VirtuosoBlob(VirtuosoConnection virtuosoConnection, long l, long l2, long l3) throws VirtuosoException {
        this.connection = virtuosoConnection;
        this.ask = l;
        this.bh_page = l2;
        this.length = l3;
        this.dtp = 126;
        this.rewind();
    }

    VirtuosoBlob(VirtuosoConnection virtuosoConnection, long l, long l2, long l3, long l4, long l5, long l6, long l7, Object object, int n) throws VirtuosoException {
        this.connection = virtuosoConnection;
        this.ask = l;
        this.bh_page = l2;
        this.length = l3;
        this.dtp = n;
        this.key_id = l4;
        this.frag_no = l5;
        this.dir_page = l6;
        this.bh_timestamp = l7;
        this.pages = object;
        this.rewind();
    }

    protected void setInputStream(InputStream inputStream, long l) {
        this.is = inputStream;
        this.length = l;
    }

    protected void setReader(Reader reader, long l) {
        this.rd = reader;
        this.length = l;
    }

    protected void setObject(Object object) {
    }

    private void checkBlobError(Vector vector) throws VirtuosoException {
        if (vector.firstElement() instanceof Long && ((Number)vector.firstElement()).longValue() == 3L) {
            throw new VirtuosoException(vector.elementAt(2).toString(), vector.elementAt(1).toString(), -8);
        }
    }

    public byte[] getBytes(long l, int n) throws VirtuosoException {
        if (l <= 0L) {
            throw new VirtuosoException("Invalid param to the getBytes", "22023", -4);
        }
        if (!this.request) {
            if (--l > (long)this.buffer.length || l + (long)n > (long)this.buffer.length) {
                return null;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, (int)l, byArray, 0, n);
            return byArray;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (l < 0L || n <= 0 || l + (long)n - 1L > this.length) {
                return null;
            }
            Long l2 = null;
            if (l - 1L < this.bh_offset()) {
                this.rewind();
                l2 = new Long(l - 1L);
            } else if (l - 1L > this.bh_offset()) {
                l2 = new Long(l - this.bh_offset() - 1L);
            }
            if (l2 != null) {
                object4 = null;
                object3 = this.connection;
                synchronized (object3) {
                    Object[] objectArray = new Object[]{new Long(this.bh_current_page), l2, new Long(this.bh_position), new Long(this.key_id), new Long(this.frag_no), new Long(this.dir_page), this.pages, this.dtp == 133 ? new Long(1L) : new Long(0L), new Long(this.bh_timestamp)};
                    object2 = this.connection.getFuture("GETDA", objectArray, -1);
                    object4 = ((VirtuosoFuture)object2).nextResult();
                    object4 = (Vector)((Vector)object4).firstElement();
                    this.connection.removeFuture((VirtuosoFuture)object2);
                }
                if (!(object4 instanceof Vector)) {
                    return null;
                }
                this.checkBlobError((Vector)object4);
                int n2 = 0;
                while (n2 < ((Vector)object4).size()) {
                    object2 = ((Vector)object4).elementAt(n2);
                    if (object2 instanceof Vector) {
                        object = (Vector)object2;
                        this.bh_current_page = ((Number)((Vector)object).elementAt(1)).longValue();
                        this.bh_position = ((Number)((Vector)object).elementAt(2)).longValue();
                        break;
                    }
                    if (object2 instanceof String) {
                        object = (String)object2;
                        this.bh_start_offset = this.dtp == 133 ? (this.bh_start_offset += (long)((String)object).length()) : (this.bh_start_offset += (long)((String)object).getBytes("8859_1").length);
                    }
                    ++n2;
                }
            }
            object4 = new ByteArrayOutputStream();
            object3 = null;
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                object2 = new Object[]{new Long(this.bh_current_page), new Long(n), new Long(this.bh_position), new Long(this.key_id), new Long(this.frag_no), new Long(this.dir_page), this.pages, this.dtp == 133 ? new Long(1L) : new Long(0L), new Long(this.bh_timestamp)};
                object = this.connection.getFuture("GETDA", (Object[])object2, -1);
                object3 = ((VirtuosoFuture)object).nextResult();
                object3 = (Vector)((Vector)object3).firstElement();
                this.connection.removeFuture((VirtuosoFuture)object);
            }
            if (!(object3 instanceof Vector)) {
                return null;
            }
            this.checkBlobError((Vector)object3);
            int n3 = 0;
            while (n3 < ((Vector)object3).size()) {
                Object object5;
                object = ((Vector)object3).elementAt(n3);
                if (object instanceof Vector) {
                    object5 = (Vector)object;
                    this.bh_current_page = ((Number)((Vector)object5).elementAt(1)).longValue();
                    this.bh_position = ((Number)((Vector)object5).elementAt(2)).longValue();
                } else if (object instanceof String) {
                    object5 = (String)object;
                    ((OutputStream)object4).write(((String)object5).getBytes("8859_1"));
                    this.bh_start_offset += (long)((String)object5).getBytes("8859_1").length;
                }
                ++n3;
            }
            object = ((ByteArrayOutputStream)object4).toByteArray();
            return object;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
    }

    public String getSubString(long l, int n) throws VirtuosoException {
        byte[] byArray = this.getBytes(l, n);
        if (this.dtp == 133) {
            try {
                return new String(byArray, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new VirtuosoException("UTF8 not supported in getSubString", -17);
            }
        }
        try {
            return new String(byArray, "8859_1");
        }
        catch (Exception exception) {
            throw new VirtuosoException("8859-1 not supported in getSubString", -17);
        }
    }

    public long length() throws VirtuosoException {
        return this.length;
    }

    public InputStream getBinaryStream() throws VirtuosoException {
        if (this.is != null) {
            return this.is;
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        return new VirtuosoBlobStream(this);
    }

    public Reader getCharacterStream() throws VirtuosoException {
        if (this.rd != null) {
            return this.rd;
        }
        if (this.buffer != null) {
            return new StringReader(new String(this.buffer));
        }
        try {
            switch (this.dtp) {
                case 132: {
                    return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), "UTF8");
                }
                case 131: {
                    return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), "8859_1");
                }
            }
            return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), this.connection.charset != null ? this.connection.charset : "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new VirtuosoException("Unsupported charset encoding : " + unsupportedEncodingException.getMessage(), -10);
        }
    }

    public InputStream getAsciiStream() throws VirtuosoException {
        if (this.is != null) {
            return this.is;
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        return new VirtuosoClobStream(this);
    }

    public long position(byte[] byArray, long l) throws VirtuosoException {
        if (!this.request) {
            if (l >= (long)this.buffer.length || l + (long)byArray.length >= (long)this.buffer.length) {
                return -1L;
            }
            boolean bl = true;
            int n = (int)l - 1;
            while (n < this.buffer.length && bl) {
                bl &= this.buffer[n] == byArray[n];
                ++n;
            }
            if (bl) {
                return n;
            }
            return -1L;
        }
        try {
            VirtuosoBlobStream virtuosoBlobStream = (VirtuosoBlobStream)this.getBinaryStream();
            virtuosoBlobStream.skip(l - 1L);
            byte[] byArray2 = new byte[byArray.length];
            while (virtuosoBlobStream.available() > byArray2.length) {
                if (virtuosoBlobStream.read(byArray2, 0, byArray2.length) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                boolean bl = true;
                int n = 0;
                while (n < byArray2.length && bl) {
                    bl &= byArray2[n] == byArray[n];
                    ++n;
                }
                if (!bl) continue;
                return virtuosoBlobStream.pos;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
    }

    public long position(Blob blob, long l) throws VirtuosoException {
        try {
            VirtuosoBlobStream virtuosoBlobStream = (VirtuosoBlobStream)blob.getBinaryStream();
            virtuosoBlobStream.skip(l - 1L);
            byte[] byArray = new byte[8192];
            while (virtuosoBlobStream.available() > 8192) {
                if (virtuosoBlobStream.read(byArray, 0, 8192) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                long l2 = this.position(byArray, l += 8192L);
                if (l2 == -1L) continue;
                return l2;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
        catch (SQLException sQLException) {
            throw new VirtuosoException("SQL error occurred : " + sQLException.getMessage(), -8);
        }
    }

    public long position(String string, long l) throws VirtuosoException {
        try {
            VirtuosoClobStream virtuosoClobStream = (VirtuosoClobStream)this.getAsciiStream();
            virtuosoClobStream.skip(l - 1L);
            byte[] byArray = new byte[string.length()];
            while (virtuosoClobStream.available() > byArray.length) {
                if (virtuosoClobStream.read(byArray, 0, byArray.length) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                if (!string.equals(new String(byArray))) continue;
                return virtuosoClobStream.pos;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
    }

    public long position(Clob clob, long l) throws VirtuosoException {
        try {
            VirtuosoClobStream virtuosoClobStream = (VirtuosoClobStream)clob.getAsciiStream();
            virtuosoClobStream.skip(l - 1L);
            byte[] byArray = new byte[8192];
            while (virtuosoClobStream.available() > 8192) {
                if (virtuosoClobStream.read(byArray, 0, 8192) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                long l2 = this.position(new String(byArray), l += 8192L);
                if (l2 == -1L) continue;
                return l2;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
        catch (SQLException sQLException) {
            throw new VirtuosoException("SQL error occurred : " + sQLException.getMessage(), -8);
        }
    }

    public int hashCode() {
        return (int)this.bh_page;
    }

    public String toString() {
        return "Blob " + this.length + "b";
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public void free() throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }
}

