/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.database.IdentityManager;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class FuelDropEventHandler
extends BaseEventHandler {
    public static final String ATTRIBUTE_FUEL_DROP_THRESHOLD = "fuelDropThreshold";
    private final IdentityManager identityManager;

    public FuelDropEventHandler(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Device device = this.identityManager.getById(position.getDeviceId());
        if (device == null) {
            return null;
        }
        if (!this.identityManager.isLatestPosition(position)) {
            return null;
        }
        double fuelDropThreshold = this.identityManager.lookupAttributeDouble(device.getId(), ATTRIBUTE_FUEL_DROP_THRESHOLD, 0.0, true, false);
        if (fuelDropThreshold > 0.0) {
            double drop;
            Position lastPosition = this.identityManager.getLastPosition(position.getDeviceId());
            if (position.getAttributes().containsKey("fuel") && lastPosition != null && lastPosition.getAttributes().containsKey("fuel") && (drop = lastPosition.getDouble("fuel") - position.getDouble("fuel")) >= fuelDropThreshold) {
                Event event = new Event("deviceFuelDrop", position.getDeviceId(), position.getId());
                event.set(ATTRIBUTE_FUEL_DROP_THRESHOLD, fuelDropThreshold);
                return Collections.singletonMap(event, position);
            }
        }
        return null;
    }
}

