/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.ssl;

import com.cloudhopper.smpp.ssl.AliasedX509ExtendedKeyManager;
import com.cloudhopper.smpp.ssl.CertificateValidator;
import com.cloudhopper.smpp.ssl.SslConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(SslContextFactory.class);
    private SSLContext sslContext;
    private InputStream keyStoreInputStream;
    private InputStream trustStoreInputStream;
    private final SslConfiguration sslConfig;

    public SslContextFactory() throws Exception {
        this(new SslConfiguration());
    }

    public SslContextFactory(SslConfiguration sslConfig) throws Exception {
        this.sslConfig = sslConfig;
        this.init();
    }

    private void init() throws Exception {
        if (this.sslContext == null) {
            if (this.keyStoreInputStream == null && this.sslConfig.getKeyStorePath() == null && this.trustStoreInputStream == null && this.sslConfig.getTrustStorePath() == null) {
                TrustManager[] trust_managers = null;
                if (this.sslConfig.isTrustAll()) {
                    logger.debug("No keystore or trust store configured.  ACCEPTING UNTRUSTED CERTIFICATES!!!!!");
                    X509TrustManager trustAllCerts = new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    };
                    trust_managers = new TrustManager[]{trustAllCerts};
                }
                SecureRandom secureRandom = this.sslConfig.getSecureRandomAlgorithm() == null ? null : SecureRandom.getInstance(this.sslConfig.getSecureRandomAlgorithm());
                this.sslContext = SSLContext.getInstance(this.sslConfig.getProtocol());
                this.sslContext.init(null, trust_managers, secureRandom);
            } else {
                this.checkKeyStore();
                KeyStore keyStore = this.loadKeyStore();
                KeyStore trustStore = this.loadTrustStore();
                Collection<? extends CRL> crls = this.loadCRL(this.sslConfig.getCrlPath());
                if (this.sslConfig.isValidateCerts() && keyStore != null) {
                    Certificate cert;
                    if (this.sslConfig.getCertAlias() == null) {
                        ArrayList<String> aliases = Collections.list(keyStore.aliases());
                        this.sslConfig.setCertAlias(aliases.size() == 1 ? (String)aliases.get(0) : null);
                    }
                    Certificate certificate = cert = this.sslConfig.getCertAlias() == null ? null : keyStore.getCertificate(this.sslConfig.getCertAlias());
                    if (cert == null) {
                        throw new Exception("No certificate found in the keystore" + (this.sslConfig.getCertAlias() == null ? "" : " for alias " + this.sslConfig.getCertAlias()));
                    }
                    CertificateValidator validator = new CertificateValidator(trustStore, crls);
                    validator.setMaxCertPathLength(this.sslConfig.getMaxCertPathLength());
                    validator.setEnableCRLDP(this.sslConfig.isEnableCRLDP());
                    validator.setEnableOCSP(this.sslConfig.isEnableOCSP());
                    validator.setOcspResponderURL(this.sslConfig.getOcspResponderURL());
                    validator.validate(keyStore, cert);
                }
                KeyManager[] keyManagers = this.getKeyManagers(keyStore);
                TrustManager[] trustManagers = this.getTrustManagers(trustStore, crls);
                SecureRandom secureRandom = this.sslConfig.getSecureRandomAlgorithm() == null ? null : SecureRandom.getInstance(this.sslConfig.getSecureRandomAlgorithm());
                this.sslContext = this.sslConfig.getProvider() == null ? SSLContext.getInstance(this.sslConfig.getProtocol()) : SSLContext.getInstance(this.sslConfig.getProtocol(), this.sslConfig.getProvider());
                this.sslContext.init(keyManagers, trustManagers, secureRandom);
                SSLEngine engine = this.newSslEngine();
                logger.info("Enabled Protocols {} of {}", Arrays.asList(engine.getEnabledProtocols()), Arrays.asList(engine.getSupportedProtocols()));
                logger.debug("Enabled Ciphers {} of {}", Arrays.asList(engine.getEnabledCipherSuites()), Arrays.asList(engine.getSupportedCipherSuites()));
            }
        }
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    protected KeyStore loadKeyStore() throws Exception {
        return this.getKeyStore(this.keyStoreInputStream, this.sslConfig.getKeyStorePath(), this.sslConfig.getKeyStoreType(), this.sslConfig.getKeyStoreProvider(), this.sslConfig.getKeyStorePassword());
    }

    protected KeyStore loadTrustStore() throws Exception {
        return this.getKeyStore(this.trustStoreInputStream, this.sslConfig.getTrustStorePath(), this.sslConfig.getTrustStoreType(), this.sslConfig.getTrustStoreProvider(), this.sslConfig.getTrustStorePassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        Collection<? extends CRL> crlList = null;
        if (crlPath != null) {
            try (FileInputStream in = null;){
                in = new FileInputStream(crlPath);
                crlList = CertificateFactory.getInstance("X.509").generateCRLs(in);
            }
        }
        return crlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore getKeyStore(InputStream storeStream, String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        KeyStore keystore = null;
        if (storeStream != null || storePath != null) {
            try (InputStream inStream = storeStream;){
                if (inStream == null) {
                    inStream = new FileInputStream(storePath);
                }
                keystore = storeProvider != null ? KeyStore.getInstance(storeType, storeProvider) : KeyStore.getInstance(storeType);
                keystore.load(inStream, storePassword == null ? null : storePassword.toCharArray());
            }
        }
        return keystore;
    }

    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManager[] managers = null;
        if (keyStore != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.sslConfig.getKeyManagerFactoryAlgorithm());
            keyManagerFactory.init(keyStore, (char[])(this.sslConfig.getKeyManagerPassword() == null ? (Object)(this.sslConfig.getKeyStorePassword() == null ? null : this.sslConfig.getKeyStorePassword().toCharArray()) : this.sslConfig.getKeyManagerPassword().toCharArray()));
            managers = keyManagerFactory.getKeyManagers();
            if (this.sslConfig.getCertAlias() != null) {
                for (int idx = 0; idx < managers.length; ++idx) {
                    if (!(managers[idx] instanceof X509KeyManager)) continue;
                    managers[idx] = new AliasedX509ExtendedKeyManager(this.sslConfig.getCertAlias(), (X509KeyManager)managers[idx]);
                }
            }
        }
        return managers;
    }

    protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        TrustManager[] managers = null;
        if (trustStore != null) {
            if (this.sslConfig.isValidatePeerCerts() && this.sslConfig.getTrustManagerFactoryAlgorithm().equalsIgnoreCase("PKIX")) {
                PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                pbParams.setMaxPathLength(this.sslConfig.getMaxCertPathLength());
                pbParams.setRevocationEnabled(true);
                if (crls != null && !crls.isEmpty()) {
                    pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
                }
                if (this.sslConfig.isEnableCRLDP()) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                }
                if (this.sslConfig.isEnableOCSP()) {
                    Security.setProperty("ocsp.enable", "true");
                    if (this.sslConfig.getOcspResponderURL() != null) {
                        Security.setProperty("ocsp.responderURL", this.sslConfig.getOcspResponderURL());
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.sslConfig.getTrustManagerFactoryAlgorithm());
                trustManagerFactory.init(new CertPathTrustManagerParameters(pbParams));
                managers = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.sslConfig.getTrustManagerFactoryAlgorithm());
                trustManagerFactory.init(trustStore);
                managers = trustManagerFactory.getTrustManagers();
            }
        }
        return managers;
    }

    public void checkKeyStore() {
        if (this.sslContext != null) {
            return;
        }
        if (this.keyStoreInputStream == null && this.sslConfig.getKeyStorePath() == null) {
            throw new IllegalStateException("SSL doesn't have a valid keystore");
        }
        if (this.trustStoreInputStream == null && this.sslConfig.getTrustStorePath() == null) {
            this.trustStoreInputStream = this.keyStoreInputStream;
            this.sslConfig.setTrustStorePath(this.sslConfig.getKeyStorePath());
            this.sslConfig.setTrustStoreType(this.sslConfig.getKeyStoreType());
            this.sslConfig.setTrustStoreProvider(this.sslConfig.getKeyStoreProvider());
            this.sslConfig.setTrustStorePassword(this.sslConfig.getKeyStorePassword());
            this.sslConfig.setTrustManagerFactoryAlgorithm(this.sslConfig.getKeyManagerFactoryAlgorithm());
        }
        if (this.keyStoreInputStream != null && this.keyStoreInputStream == this.trustStoreInputStream) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                SslContextFactory.streamCopy(this.keyStoreInputStream, baos, null, false);
                this.keyStoreInputStream.close();
                this.keyStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
                this.trustStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static void streamCopy(InputStream is, OutputStream os, byte[] buf, boolean close) throws IOException {
        int len;
        if (buf == null) {
            buf = new byte[4096];
        }
        while ((len = is.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        os.flush();
        if (close) {
            is.close();
        }
    }

    private static boolean contains(Object[] arr, Object obj) {
        for (Object o : arr) {
            if (!o.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public String[] selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
        HashSet<String> selected_protocols = new HashSet<String>();
        if (this.sslConfig.getIncludeProtocols() != null) {
            for (String protocol : supportedProtocols) {
                if (!SslContextFactory.contains(this.sslConfig.getIncludeProtocols(), protocol)) continue;
                selected_protocols.add(protocol);
            }
        } else {
            selected_protocols.addAll(Arrays.asList(enabledProtocols));
        }
        if (this.sslConfig.getExcludeProtocols() != null) {
            selected_protocols.removeAll(Arrays.asList(this.sslConfig.getExcludeProtocols()));
        }
        return selected_protocols.toArray(new String[selected_protocols.size()]);
    }

    public String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
        HashSet<String> selected_ciphers = new HashSet<String>();
        if (this.sslConfig.getIncludeCipherSuites() != null) {
            for (String cipherSuite : supportedCipherSuites) {
                if (!SslContextFactory.contains(this.sslConfig.getIncludeCipherSuites(), cipherSuite)) continue;
                selected_ciphers.add(cipherSuite);
            }
        } else {
            selected_ciphers.addAll(Arrays.asList(enabledCipherSuites));
        }
        if (this.sslConfig.getExcludeCipherSuites() != null) {
            selected_ciphers.removeAll(Arrays.asList(this.sslConfig.getExcludeCipherSuites()));
        }
        return selected_ciphers.toArray(new String[selected_ciphers.size()]);
    }

    public SSLServerSocket newSslServerSocket(String host, int port, int backlog) throws IOException {
        SSLServerSocketFactory factory = this.sslContext.getServerSocketFactory();
        SSLServerSocket socket = (SSLServerSocket)(host == null ? factory.createServerSocket(port, backlog) : factory.createServerSocket(port, backlog, InetAddress.getByName(host)));
        if (this.sslConfig.getWantClientAuth()) {
            socket.setWantClientAuth(this.sslConfig.getWantClientAuth());
        }
        if (this.sslConfig.getNeedClientAuth()) {
            socket.setNeedClientAuth(this.sslConfig.getNeedClientAuth());
        }
        socket.setEnabledCipherSuites(this.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
        socket.setEnabledProtocols(this.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols()));
        return socket;
    }

    public SSLSocket newSslSocket() throws IOException {
        SSLSocketFactory factory = this.sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket();
        if (this.sslConfig.getWantClientAuth()) {
            socket.setWantClientAuth(this.sslConfig.getWantClientAuth());
        }
        if (this.sslConfig.getNeedClientAuth()) {
            socket.setNeedClientAuth(this.sslConfig.getNeedClientAuth());
        }
        socket.setEnabledCipherSuites(this.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
        socket.setEnabledProtocols(this.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols()));
        return socket;
    }

    public SSLEngine newSslEngine(String host, int port) {
        SSLEngine sslEngine = this.sslConfig.isSessionCachingEnabled() ? this.sslContext.createSSLEngine(host, port) : this.sslContext.createSSLEngine();
        this.customize(sslEngine);
        return sslEngine;
    }

    public SSLEngine newSslEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        this.customize(sslEngine);
        return sslEngine;
    }

    private void customize(SSLEngine sslEngine) {
        if (this.sslConfig.getWantClientAuth()) {
            sslEngine.setWantClientAuth(this.sslConfig.getWantClientAuth());
        }
        if (this.sslConfig.getNeedClientAuth()) {
            sslEngine.setNeedClientAuth(this.sslConfig.getNeedClientAuth());
        }
        sslEngine.setEnabledCipherSuites(this.selectCipherSuites(sslEngine.getEnabledCipherSuites(), sslEngine.getSupportedCipherSuites()));
        sslEngine.setEnabledProtocols(this.selectProtocols(sslEngine.getEnabledProtocols(), sslEngine.getSupportedProtocols()));
    }
}

