/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BaseGlobalOrdinalScorer;
import org.apache.lucene.search.join.GlobalOrdinalsQuery;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreCollector;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;

final class GlobalOrdinalsWithScoreQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(GlobalOrdinalsWithScoreQuery.class);
    private final GlobalOrdinalsWithScoreCollector collector;
    private final String joinField;
    private final OrdinalMap globalOrds;
    private final Query toQuery;
    private final ScoreMode scoreMode;
    private final Query fromQuery;
    private final int min;
    private final int max;
    private final Object indexReaderContextId;
    private final long ramBytesUsed;

    GlobalOrdinalsWithScoreQuery(GlobalOrdinalsWithScoreCollector collector, ScoreMode scoreMode, String joinField, OrdinalMap globalOrds, Query toQuery, Query fromQuery, int min, int max, Object indexReaderContextId) {
        this.collector = collector;
        this.joinField = joinField;
        this.globalOrds = globalOrds;
        this.toQuery = toQuery;
        this.scoreMode = scoreMode;
        this.fromQuery = fromQuery;
        this.min = min;
        this.max = max;
        this.indexReaderContextId = indexReaderContextId;
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject((Object)this.fromQuery, (long)1024L) + RamUsageEstimator.sizeOfObject((Object)this.globalOrds) + RamUsageEstimator.sizeOfObject((Object)this.joinField) + RamUsageEstimator.sizeOfObject((Object)this.toQuery, (long)1024L);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, org.apache.lucene.search.ScoreMode scoreMode, float boost) throws IOException {
        boolean doNoMinMax;
        if (searcher.getTopReaderContext().id() != this.indexReaderContextId) {
            throw new IllegalStateException("Creating the weight against a different index reader than this query has been built for.");
        }
        boolean bl = doNoMinMax = this.min <= 0 && this.max == Integer.MAX_VALUE;
        if (!scoreMode.needsScores() && doNoMinMax) {
            GlobalOrdinalsQuery globalOrdinalsQuery = new GlobalOrdinalsQuery(this.collector.collectedOrds, this.joinField, this.globalOrds, this.toQuery, this.fromQuery, this.indexReaderContextId);
            return globalOrdinalsQuery.createWeight(searcher, org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES, boost);
        }
        return new W(this, this.toQuery.createWeight(searcher, org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES, 1.0f));
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((GlobalOrdinalsWithScoreQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(GlobalOrdinalsWithScoreQuery other) {
        return this.min == other.min && this.max == other.max && this.scoreMode.equals((Object)other.scoreMode) && this.joinField.equals(other.joinField) && this.fromQuery.equals((Object)other.fromQuery) && this.toQuery.equals((Object)other.toQuery) && this.indexReaderContextId.equals(other.indexReaderContextId);
    }

    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.scoreMode.hashCode();
        result = 31 * result + this.joinField.hashCode();
        result = 31 * result + this.toQuery.hashCode();
        result = 31 * result + this.fromQuery.hashCode();
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        result = 31 * result + this.indexReaderContextId.hashCode();
        return result;
    }

    public String toString(String field) {
        return "GlobalOrdinalsQuery{joinField=" + this.joinField + "min=" + this.min + "max=" + this.max + "fromQuery=" + this.fromQuery + '}';
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    static final class SegmentOrdinalScorer
    extends BaseGlobalOrdinalScorer {
        final GlobalOrdinalsWithScoreCollector collector;

        public SegmentOrdinalScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation) {
            super(weight, values, approximation);
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                public boolean matches() throws IOException {
                    int segmentOrd;
                    if (values.advanceExact(this.approximation.docID()) && collector.match(segmentOrd = values.ordValue())) {
                        score = collector.score(segmentOrd);
                        return true;
                    }
                    return false;
                }

                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    static final class OrdinalMapScorer
    extends BaseGlobalOrdinalScorer {
        final LongValues segmentOrdToGlobalOrdLookup;
        final GlobalOrdinalsWithScoreCollector collector;

        public OrdinalMapScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation, LongValues segmentOrdToGlobalOrdLookup) {
            super(weight, values, approximation);
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                public boolean matches() throws IOException {
                    long segmentOrd;
                    int globalOrd;
                    if (values.advanceExact(this.approximation.docID()) && collector.match(globalOrd = (int)segmentOrdToGlobalOrdLookup.get(segmentOrd = (long)values.ordValue()))) {
                        score = collector.score(globalOrd);
                        return true;
                    }
                    return false;
                }

                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    final class W
    extends FilterWeight {
        W(Query query, Weight approximationWeight) {
            super(query, approximationWeight);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            SortedDocValues values = DocValues.getSorted((LeafReader)context.reader(), (String)GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values == null) {
                return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
            }
            if (values.advance(doc) != doc) {
                return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
            }
            int segmentOrd = values.ordValue();
            BytesRef joinValue = values.lookupOrd(segmentOrd);
            int ord = GlobalOrdinalsWithScoreQuery.this.globalOrds != null ? (int)GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context.ord).get((long)segmentOrd) : segmentOrd;
            if (!GlobalOrdinalsWithScoreQuery.this.collector.match(ord)) {
                return Explanation.noMatch((String)("Not a match, join value " + Term.toString((BytesRef)joinValue)), (Explanation[])new Explanation[0]);
            }
            float score = GlobalOrdinalsWithScoreQuery.this.collector.score(ord);
            return Explanation.match((Number)Float.valueOf(score), (String)("A match, join value " + Term.toString((BytesRef)joinValue)), (Explanation[])new Explanation[0]);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            SortedDocValues values = DocValues.getSorted((LeafReader)context.reader(), (String)GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values == null) {
                return null;
            }
            Scorer approximationScorer = this.in.scorer(context);
            if (approximationScorer == null) {
                return null;
            }
            if (GlobalOrdinalsWithScoreQuery.this.globalOrds != null) {
                return new OrdinalMapScorer((Weight)this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator(), GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context.ord));
            }
            return new SegmentOrdinalScorer((Weight)this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator());
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

