/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.ClientInfo;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u001a\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010\u001fJ\u0016\u0010#\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiService;", "Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "requestIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "requests", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/io/fastCgi/ClientInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addCloseListener", "", "it", "Lio/netty/channel/Channel;", "allocateRequestId", "", "channel", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "configureBootstrap", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "handleError", "fastCgiRequest", "Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "content", "Lio/netty/buffer/ByteBuf;", "responseReceived", "id", "buffer", "send", "intellij.platform.builtInServer.impl"})
public abstract class FastCgiService
extends SingleConnectionNetService {
    private final AtomicInteger requestIdCounter;
    private final ConcurrentIntObjectMap<ClientInfo> requests;

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap $this$handler$iv = bootstrap;
        boolean $i$f$handler = false;
        $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, errorOutputConsumer){
            final /* synthetic */ FastCgiService this$0;
            final /* synthetic */ Consumer $errorOutputConsumer$inlined;
            {
                this.this$0 = fastCgiService;
                this.$errorOutputConsumer$inlined = consumer;
            }

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Channel it = channel;
                boolean bl = false;
                it.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)this.$errorOutputConsumer$inlined, this.this$0));
                it.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
            }
        });
    }

    @Override
    protected void addCloseListener(@NotNull Channel it) {
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        super.addCloseListener(it);
        ChannelFuture channelFuture = it.closeFuture();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it.closeFuture()");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ FastCgiService this$0;
            {
                this.this$0 = fastCgiService;
            }

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                boolean bl = false;
                FastCgiService.access$getRequestIdCounter$p(this.this$0).set(0);
                if (!FastCgiService.access$getRequests$p(this.this$0).isEmpty()) {
                    Enumeration enumeration = FastCgiService.access$getRequests$p(this.this$0).elements();
                    Intrinsics.checkExpressionValueIsNotNull((Object)enumeration, (String)"requests.elements()");
                    Enumeration enumeration2 = enumeration;
                    boolean bl2 = false;
                    ArrayList<T> arrayList = Collections.list(enumeration2);
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
                    List waitingClients = arrayList;
                    FastCgiService.access$getRequests$p(this.this$0).clear();
                    for (ClientInfo client : waitingClients) {
                        FastCgiServiceKt.access$sendBadGateway(client.getChannel(), client.getExtraHeaders());
                    }
                }
            }
        });
    }

    public final void send(@NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content2) {
        Intrinsics.checkParameterIsNotNull((Object)fastCgiRequest, (String)"fastCgiRequest");
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        ByteBuf notEmptyContent = null;
        if (content2.isReadable()) {
            content2.retain();
            notEmptyContent = content2;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            Promise<Channel> promise = null;
            OSProcessHandler handler2 = (OSProcessHandler)this.getProcessHandler().getResultIfFullFilled();
            if (handler2 == null) {
                Promise<Channel> promise2 = this.getProcessHandler().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"processHandler.get()");
                promise = promise2;
            } else {
                Channel channel = this.getProcessChannel().get();
                if (channel == null || !channel.isOpen()) {
                    promise = this.connectAgain();
                } else {
                    fastCgiRequest.writeToServerChannel(notEmptyContent, channel);
                    return;
                }
            }
            promise.onSuccess((java.util.function.Consumer)new java.util.function.Consumer<Object>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void accept(Object it) {
                    V v = FastCgiService.access$getProcessChannel$p(this.this$0).get();
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$fastCgiRequest.writeToServerChannel(this.$notEmptyContent, (Channel)v);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            }).onError((java.util.function.Consumer)new java.util.function.Consumer<Throwable>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void accept(Throwable it) {
                    Logger logger = FastCgiServiceKt.getLOG();
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    Promises.errorIfNotMessage((Logger)logger, (Throwable)throwable);
                    FastCgiService.access$handleError(this.this$0, this.$fastCgiRequest, this.$notEmptyContent);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            });
        }
        catch (Throwable e) {
            FastCgiServiceKt.getLOG().error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleError(FastCgiRequest fastCgiRequest, ByteBuf content2) {
        try {
            if (content2 != null && content2.refCnt() != 0) {
                content2.release();
            }
        }
        finally {
            ClientInfo clientInfo = (ClientInfo)this.requests.remove(fastCgiRequest.getRequestId());
            if (clientInfo != null) {
                ClientInfo clientInfo2 = clientInfo;
                boolean bl = false;
                boolean bl2 = false;
                ClientInfo it = clientInfo2;
                boolean bl3 = false;
                FastCgiServiceKt.access$sendBadGateway(it.getChannel(), it.getExtraHeaders());
            }
        }
    }

    public final int allocateRequestId(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)new ClientInfo(channel, extraHeaders));
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void responseReceived(int id2, @Nullable ByteBuf buffer) {
        ClientInfo client = (ClientInfo)this.requests.remove(id2);
        if (client == null || !client.getChannel().isActive()) {
            ByteBuf byteBuf = buffer;
            if (byteBuf != null) {
                byteBuf.release();
            }
            return;
        }
        Channel channel = client.getChannel();
        if (buffer == null) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_GATEWAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_GATEWAY");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, null, null, null, (int)14, null);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        try {
            FastCgiServiceKt.access$parseHeaders((HttpResponse)httpResponse, buffer);
            if (!HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)httpResponse))) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)httpResponse), (long)buffer.readableBytes());
            }
            httpResponse.headers().add(client.getExtraHeaders());
        }
        catch (Throwable e) {
            buffer.release();
            try {
                FastCgiServiceKt.getLOG().error(e);
            }
            finally {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.INTERNAL_SERVER_ERROR");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, null, null, null, (int)14, null);
            }
            return;
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    public FastCgiService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.requestIdCounter = new AtomicInteger();
        ConcurrentIntObjectMap concurrentIntObjectMap = ContainerUtil.createConcurrentIntObjectMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentIntObjectMap, (String)"ContainerUtil.createConc\u2026ntObjectMap<ClientInfo>()");
        this.requests = concurrentIntObjectMap;
    }

    public static final /* synthetic */ AtomicInteger access$getRequestIdCounter$p(FastCgiService $this) {
        return $this.requestIdCounter;
    }

    public static final /* synthetic */ ConcurrentIntObjectMap access$getRequests$p(FastCgiService $this) {
        return $this.requests;
    }

    public static final /* synthetic */ AtomicReference access$getProcessChannel$p(FastCgiService $this) {
        return $this.getProcessChannel();
    }

    public static final /* synthetic */ void access$handleError(FastCgiService $this, FastCgiRequest fastCgiRequest, ByteBuf content2) {
        $this.handleError(fastCgiRequest, content2);
    }
}

